/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.team;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.team.TeamInfoResponseIF;
import com.hubspot.slack.client.models.teams.SlackTeam;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class TeamInfoResponse
implements TeamInfoResponseIF {
    private final SlackTeam slackTeam;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private TeamInfoResponse(SlackTeam slackTeam, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.slackTeam = slackTeam;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public SlackTeam getSlackTeam() {
        return this.slackTeam;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final TeamInfoResponse withSlackTeam(SlackTeam slackTeam) {
        if (this.slackTeam == slackTeam) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(slackTeam, "slackTeam");
        return new TeamInfoResponse(newValue, this.ok, this.responseMetadata);
    }

    public final TeamInfoResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new TeamInfoResponse(this.slackTeam, ok, this.responseMetadata);
    }

    public final TeamInfoResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new TeamInfoResponse(this.slackTeam, this.ok, newValue);
    }

    public final TeamInfoResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new TeamInfoResponse(this.slackTeam, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TeamInfoResponse && this.equalTo((TeamInfoResponse)another);
    }

    private boolean equalTo(TeamInfoResponse another) {
        return this.slackTeam.equals(another.slackTeam) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.slackTeam.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TeamInfoResponse{");
        builder.append("slackTeam=").append(this.slackTeam);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static TeamInfoResponse fromJson(Json json) {
        Builder builder = TeamInfoResponse.builder();
        if (json.slackTeam != null) {
            builder.setSlackTeam(json.slackTeam);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static TeamInfoResponse copyOf(TeamInfoResponseIF instance) {
        if (instance instanceof TeamInfoResponse) {
            return (TeamInfoResponse)instance;
        }
        return TeamInfoResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SLACK_TEAM = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackTeam slackTeam;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(TeamInfoResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof TeamInfoResponseIF) {
                instance = (TeamInfoResponseIF)object;
                this.setSlackTeam(instance.getSlackTeam());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder setSlackTeam(SlackTeam slackTeam) {
            this.slackTeam = Objects.requireNonNull(slackTeam, "slackTeam");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public TeamInfoResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new TeamInfoResponse(this.slackTeam, this.ok, this.responseMetadata);
        }

        private boolean slackTeamIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.slackTeamIsSet()) {
                attributes.add("slackTeam");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build TeamInfoResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TeamInfoResponseIF {
        @Nullable
        SlackTeam slackTeam;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setSlackTeam(SlackTeam slackTeam) {
            this.slackTeam = slackTeam;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public SlackTeam getSlackTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

