/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.usergroups;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.usergroups.UsergroupPreferences;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface SlackUsergroupIF {
    public String getId();

    public String getTeamId();

    @JsonProperty(value="is_usergroup")
    public boolean isUsergroup();

    public String getName();

    public Optional<String> getDescription();

    public String getHandle();

    @JsonProperty(value="is_external")
    public boolean isExternal();

    @JsonProperty(value="date_create")
    public int getDateCreatedEpochSeconds();

    @JsonProperty(value="date_update")
    public int getDateUpdatedEpochSeconds();

    @JsonProperty(value="date_delete")
    public int getDateDeletedEpochSeconds();

    public Optional<String> getAutoType();

    public Optional<String> getCreatedBy();

    public Optional<String> getUpdatedBy();

    public Optional<String> getDeletedBy();

    @Value.Derived
    default public boolean isDeleted() {
        return this.getDeletedBy().isPresent();
    }

    @JsonProperty(value="prefs")
    public UsergroupPreferences getPreferences();

    @JsonProperty(value="users")
    public List<String> getUserIdsInGroup();

    public Optional<Integer> getUserCount();
}

