/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.http.HttpExchangeIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class HttpExchange
implements HttpExchangeIF {
    private final HttpRequest request;
    private final HttpResponse response;
    private final Duration exchangeDuration;

    private HttpExchange(HttpRequest request, HttpResponse response, Duration exchangeDuration) {
        this.request = request;
        this.response = response;
        this.exchangeDuration = exchangeDuration;
    }

    @Override
    @JsonProperty
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    @JsonProperty
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    @JsonProperty
    public Duration getExchangeDuration() {
        return this.exchangeDuration;
    }

    public final HttpExchange withRequest(HttpRequest request) {
        if (this.request == request) {
            return this;
        }
        HttpRequest newValue = Objects.requireNonNull(request, "request");
        return new HttpExchange(newValue, this.response, this.exchangeDuration);
    }

    public final HttpExchange withResponse(HttpResponse response) {
        if (this.response == response) {
            return this;
        }
        HttpResponse newValue = Objects.requireNonNull(response, "response");
        return new HttpExchange(this.request, newValue, this.exchangeDuration);
    }

    public final HttpExchange withExchangeDuration(Duration exchangeDuration) {
        if (this.exchangeDuration == exchangeDuration) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(exchangeDuration, "exchangeDuration");
        return new HttpExchange(this.request, this.response, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HttpExchange && this.equalTo((HttpExchange)another);
    }

    private boolean equalTo(HttpExchange another) {
        return this.request.equals(another.request) && this.response.equals(another.response) && this.exchangeDuration.equals(another.exchangeDuration);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.request.hashCode();
        h = h * 17 + this.response.hashCode();
        h = h * 17 + this.exchangeDuration.hashCode();
        return h;
    }

    public String toString() {
        return "HttpExchange{request=" + this.request + ", response=" + this.response + ", exchangeDuration=" + this.exchangeDuration + "}";
    }

    @Deprecated
    @JsonCreator
    static HttpExchange fromJson(Json json) {
        Builder builder = HttpExchange.builder();
        if (json.request != null) {
            builder.setRequest(json.request);
        }
        if (json.response != null) {
            builder.setResponse(json.response);
        }
        if (json.exchangeDuration != null) {
            builder.setExchangeDuration(json.exchangeDuration);
        }
        return builder.build();
    }

    public static HttpExchange copyOf(HttpExchangeIF instance) {
        if (instance instanceof HttpExchange) {
            return (HttpExchange)instance;
        }
        return HttpExchange.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REQUEST = 1L;
        private static final long INIT_BIT_RESPONSE = 2L;
        private static final long INIT_BIT_EXCHANGE_DURATION = 4L;
        private long initBits = 7L;
        @Nullable
        private HttpRequest request;
        @Nullable
        private HttpResponse response;
        @Nullable
        private Duration exchangeDuration;

        private Builder() {
        }

        public final Builder from(HttpExchangeIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setRequest(instance.getRequest());
            this.setResponse(instance.getResponse());
            this.setExchangeDuration(instance.getExchangeDuration());
            return this;
        }

        public final Builder setRequest(HttpRequest request) {
            this.request = Objects.requireNonNull(request, "request");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponse(HttpResponse response) {
            this.response = Objects.requireNonNull(response, "response");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setExchangeDuration(Duration exchangeDuration) {
            this.exchangeDuration = Objects.requireNonNull(exchangeDuration, "exchangeDuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public HttpExchange build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new HttpExchange(this.request, this.response, this.exchangeDuration);
        }

        private boolean requestIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean responseIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean exchangeDurationIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.requestIsSet()) {
                attributes.add("request");
            }
            if (!this.responseIsSet()) {
                attributes.add("response");
            }
            if (!this.exchangeDurationIsSet()) {
                attributes.add("exchangeDuration");
            }
            return "Cannot build HttpExchange, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements HttpExchangeIF {
        @Nullable
        HttpRequest request;
        @Nullable
        HttpResponse response;
        @Nullable
        Duration exchangeDuration;

        Json() {
        }

        @JsonProperty
        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        @JsonProperty
        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        @JsonProperty
        public void setExchangeDuration(Duration exchangeDuration) {
            this.exchangeDuration = exchangeDuration;
        }

        @Override
        public HttpRequest getRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HttpResponse getResponse() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getExchangeDuration() {
            throw new UnsupportedOperationException();
        }
    }
}

