/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.interceptors.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hubspot.slack.client.jackson.ObjectMapperUtils;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public final class HttpRequestHelper {
    private HttpRequestHelper() {
    }

    public static ImmutableMultimap<String, String> objectToQueryParams(@Nonnull Object object) {
        Preconditions.checkNotNull((Object)object);
        JsonNode root = ObjectMapperUtils.mapper().valueToTree(object);
        if (!root.isObject()) {
            throw new IllegalArgumentException("Expected OBJECT node type but was " + root.getNodeType());
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        Iterator properties = root.fields();
        while (properties.hasNext()) {
            Map.Entry property = (Map.Entry)properties.next();
            String name = (String)property.getKey();
            JsonNode value = (JsonNode)property.getValue();
            if (value.isArray()) {
                for (JsonNode element : value) {
                    if (element.isNull()) {
                        throw new IllegalArgumentException("Encountered null element inside collection " + name);
                    }
                    builder.putAll(HttpRequestHelper.valueNodeToQueryParam(name, element));
                }
                continue;
            }
            builder.putAll(HttpRequestHelper.valueNodeToQueryParam(name, value));
        }
        return builder.build();
    }

    private static Multimap<String, String> valueNodeToQueryParam(String name, JsonNode value) {
        if (value.isNull()) {
            return ImmutableMultimap.of();
        }
        if (value.isValueNode()) {
            return ImmutableMultimap.of((Object)name, (Object)value.asText());
        }
        throw new IllegalArgumentException(String.format("Cannot convert property %s to query parameter, %s is not a valid type", name, value.getNodeType()));
    }
}

