/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.util;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.beetl.core.util.ArrayUtils;
import org.beetl.core.util.EmptyArray;
import org.beetl.core.util.GetChars;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class TextUtils {
    private static final int LINE_FEED_CODE_POINT = 10;
    private static final int NBSP_CODE_POINT = 160;
    private static Object sLock = new Object();
    private static char[] sTemp = null;
    private static String[] EMPTY_STRING_ARRAY = EmptyArray.STRING;

    private TextUtils() {
    }

    public static void getChars(CharSequence s, int start, int end, char[] dest, int destoff) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            ((String)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuffer.class) {
            ((StringBuffer)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuilder.class) {
            ((StringBuilder)s).getChars(start, end, dest, destoff);
        } else if (s instanceof GetChars) {
            ((GetChars)s).getChars(start, end, dest, destoff);
        } else {
            for (int i = start; i < end; ++i) {
                dest[destoff++] = s.charAt(i);
            }
        }
    }

    public static int indexOf(CharSequence s, char ch) {
        return TextUtils.indexOf(s, ch, 0);
    }

    public static int indexOf(CharSequence s, char ch, int start) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            return ((String)s).indexOf(ch, start);
        }
        return TextUtils.indexOf(s, ch, start, s.length());
    }

    public static int indexOf(CharSequence s, char ch, int start, int end) {
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class) {
            int INDEX_INCREMENT = 500;
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segend = start + 500;
                if (segend > end) {
                    segend = end;
                }
                TextUtils.getChars(s, start, segend, temp, 0);
                int count = segend - start;
                for (int i = 0; i < count; ++i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + start;
                }
                start = segend;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence s, char ch) {
        return TextUtils.lastIndexOf(s, ch, s.length() - 1);
    }

    public static int lastIndexOf(CharSequence s, char ch, int last) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            return ((String)s).lastIndexOf(ch, last);
        }
        return TextUtils.lastIndexOf(s, ch, 0, last);
    }

    public static int lastIndexOf(CharSequence s, char ch, int start, int last) {
        if (last < 0) {
            return -1;
        }
        if (last >= s.length()) {
            last = s.length() - 1;
        }
        int end = last + 1;
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class) {
            int INDEX_INCREMENT = 500;
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segstart = end - 500;
                if (segstart < start) {
                    segstart = start;
                }
                TextUtils.getChars(s, segstart, end, temp, 0);
                int count = end - segstart;
                for (int i = count - 1; i >= 0; --i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + segstart;
                }
                end = segstart;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence s, CharSequence needle) {
        return TextUtils.indexOf(s, needle, 0, s.length());
    }

    public static int indexOf(CharSequence s, CharSequence needle, int start) {
        return TextUtils.indexOf(s, needle, start, s.length());
    }

    public static int indexOf(CharSequence s, CharSequence needle, int start, int end) {
        int nlen = needle.length();
        if (nlen == 0) {
            return start;
        }
        char c = needle.charAt(0);
        while ((start = TextUtils.indexOf(s, c, start)) <= end - nlen) {
            if (start < 0) {
                return -1;
            }
            if (TextUtils.regionMatches(s, start, needle, 0, nlen)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static boolean regionMatches(CharSequence one, int toffset, CharSequence two, int ooffset, int len) {
        int tempLen = 2 * len;
        if (tempLen < len) {
            throw new IndexOutOfBoundsException();
        }
        char[] temp = TextUtils.obtain(tempLen);
        TextUtils.getChars(one, toffset, toffset + len, temp, 0);
        TextUtils.getChars(two, ooffset, ooffset + len, temp, len);
        boolean match = true;
        for (int i = 0; i < len; ++i) {
            if (temp[i] == temp[i + len]) continue;
            match = false;
            break;
        }
        TextUtils.recycle(temp);
        return match;
    }

    public static String substring(CharSequence source, int start, int end) {
        if (source instanceof String) {
            return ((String)source).substring(start, end);
        }
        if (source instanceof StringBuilder) {
            return ((StringBuilder)source).substring(start, end);
        }
        if (source instanceof StringBuffer) {
            return ((StringBuffer)source).substring(start, end);
        }
        char[] temp = TextUtils.obtain(end - start);
        TextUtils.getChars(source, start, end, temp, 0);
        String ret = new String(temp, 0, end - start);
        TextUtils.recycle(temp);
        return ret;
    }

    public static String join(@NotNull CharSequence delimiter, @NotNull Object[] tokens) {
        int length = tokens.length;
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tokens[0]);
        for (int i = 1; i < length; ++i) {
            sb.append(delimiter);
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(@NotNull CharSequence delimiter, @NotNull Iterable tokens) {
        Iterator it = tokens.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter);
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String[] split(String text, String expression) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return text.split(expression, -1);
    }

    public static String[] split(String text, Pattern pattern) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return pattern.split(text, -1);
    }

    public static boolean isEmpty(@Nullable CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String nullIfEmpty(@Nullable String str) {
        return TextUtils.isEmpty(str) ? null : str;
    }

    public static String emptyIfNull(@Nullable String str) {
        return str == null ? "" : str;
    }

    @NotNull
    public static String firstNotEmpty(@Nullable String a, @NotNull String b) {
        return !TextUtils.isEmpty(a) ? a : TextUtils.checkStringNotEmpty(b);
    }

    @NotNull
    private static String checkStringNotEmpty(String b) {
        return b == null ? "" : b;
    }

    public static int length(@Nullable String s) {
        return s != null ? s.length() : 0;
    }

    public static String safeIntern(String s) {
        return s != null ? s.intern() : null;
    }

    public static int getTrimmedLength(CharSequence s) {
        int end;
        int start;
        int len = s.length();
        for (start = 0; start < len && s.charAt(start) <= ' '; ++start) {
        }
        for (end = len; end > start && s.charAt(end - 1) <= ' '; --end) {
        }
        return end - start;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int getOffsetBefore(CharSequence text, int offset) {
        char c1;
        if (offset == 0) {
            return 0;
        }
        if (offset == 1) {
            return 0;
        }
        char c = text.charAt(offset - 1);
        offset = c >= '\udc00' && c <= '\udfff' ? ((c1 = text.charAt(offset - 2)) >= '\ud800' && c1 <= '\udbff' ? (offset -= 2) : --offset) : --offset;
        return offset;
    }

    public static int getOffsetAfter(CharSequence text, int offset) {
        char c1;
        int len = text.length();
        if (offset == len) {
            return len;
        }
        if (offset == len - 1) {
            return len;
        }
        char c = text.charAt(offset);
        offset = c >= '\ud800' && c <= '\udbff' ? ((c1 = text.charAt(offset + 1)) >= '\udc00' && c1 <= '\udfff' ? (offset += 2) : ++offset) : ++offset;
        return offset;
    }

    static boolean couldAffectRtl(char c) {
        return '\u0590' <= c && c <= '\u08ff' || c == '\u200e' || c == '\u200f' || '\u202a' <= c && c <= '\u202e' || '\u2066' <= c && c <= '\u2069' || '\ud800' <= c && c <= '\udfff' || '\ufb1d' <= c && c <= '\ufdff' || '\ufe70' <= c && c <= '\ufefe';
    }

    static boolean doesNotNeedBidi(char[] text, int start, int len) {
        int end = start + len;
        for (int i = start; i < end; ++i) {
            if (!TextUtils.couldAffectRtl(text[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] obtain(int len) {
        char[] buf;
        Object object = sLock;
        synchronized (object) {
            buf = sTemp;
            sTemp = null;
        }
        if (buf == null || buf.length < len) {
            buf = ArrayUtils.newUnpaddedCharArray(len);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recycle(char[] temp) {
        if (temp.length > 1000) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sTemp = temp;
        }
    }

    public static String htmlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @NotNull
    public static CharSequence concat(CharSequence ... text) {
        if (text.length == 0) {
            return "";
        }
        if (text.length == 1) {
            return text[0];
        }
        StringBuilder sb = new StringBuilder();
        for (CharSequence piece : text) {
            sb.append(piece);
        }
        return sb.toString();
    }

    public static boolean isGraphic(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            int gc = Character.getType(cp);
            if (gc == 15 || gc == 16 || gc == 19 || gc == 0 || gc == 13 || gc == 14 || gc == 12) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigitsOnly(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isDigit(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintableAscii(char c) {
        int asciiFirst = 32;
        int asciiLast = 126;
        return ' ' <= c && c <= '~' || c == '\r' || c == '\n';
    }

    public static boolean isPrintableAsciiOnly(CharSequence str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (TextUtils.isPrintableAscii(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean delimitedStringContains(String delimitedString, char delimiter, String item) {
        if (TextUtils.isEmpty(delimitedString) || TextUtils.isEmpty(item)) {
            return false;
        }
        int pos = -1;
        int length = delimitedString.length();
        while ((pos = delimitedString.indexOf(item, pos + 1)) != -1) {
            if (pos > 0 && delimitedString.charAt(pos - 1) != delimiter) continue;
            int expectedDelimiterPos = pos + item.length();
            if (expectedDelimiterPos == length) {
                return true;
            }
            if (delimitedString.charAt(expectedDelimiterPos) != delimiter) continue;
            return true;
        }
        return false;
    }

    public static long packRangeInLong(int start, int end) {
        return (long)start << 32 | (long)end;
    }

    public static int unpackRangeStartFromLong(long range) {
        return (int)(range >>> 32);
    }

    public static int unpackRangeEndFromLong(long range) {
        return (int)(range & 0xFFFFFFFFL);
    }

    public static void wrap(StringBuilder builder, String start, String end) {
        builder.insert(0, start);
        builder.append(end);
    }

    @Nullable
    public static <T extends CharSequence> T trimToSize(@Nullable T text, @Range(from=1L, to=0x7FFFFFFFL) int size) {
        if (TextUtils.isEmpty(text) || text.length() <= size) {
            return text;
        }
        if (Character.isHighSurrogate(text.charAt(size - 1)) && Character.isLowSurrogate(text.charAt(size))) {
            --size;
        }
        return (T)text.subSequence(0, size);
    }

    private static boolean isNewline(int codePoint) {
        int type = Character.getType(codePoint);
        return type == 14 || type == 13 || codePoint == 10;
    }

    private static boolean isWhiteSpace(int codePoint) {
        return Character.isWhitespace(codePoint) || codePoint == 160;
    }

    @Nullable
    public static String withoutPrefix(@Nullable String prefix, @Nullable String str) {
        if (prefix == null || str == null) {
            return str;
        }
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static enum TruncateAt {
        START,
        MIDDLE,
        END,
        MARQUEE,
        END_SMALL;

    }

    public static interface StringSplitter
    extends Iterable<String> {
        public void setString(String var1);
    }
}

