/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.beetl.core.BlockEnvContext;
import org.beetl.core.Context;
import org.beetl.core.GroupTemplate;
import org.beetl.core.cache.ContextBuffer;
import org.beetl.core.debug.DebugBlockEnvContext;
import org.beetl.core.debug.DebugLock;
import org.beetl.core.debug.DebugLockListener;
import org.beetl.core.debug.DebugProgramMetaData;

public class DebugContext
extends Context {
    DebugLock debugLock = new DebugLock(this);
    int lockTime = 60000;
    DebugProgramMetaData debugProgramMetaData = null;
    private DebugLockListener debugLockListener = null;
    private Set<Integer> breakLines = new TreeSet<Integer>();
    private int debugStatus = 0;

    public Map<String, Object> currentVars(int line) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        DebugBlockEnvContext rootDebugBlockEnvContext = (DebugBlockEnvContext)this.debugProgramMetaData.getBlockEnvContext();
        ArrayList<DebugBlockEnvContext> paths = new ArrayList<DebugBlockEnvContext>();
        paths.add(rootDebugBlockEnvContext);
        this.findBlockPaths(rootDebugBlockEnvContext, paths, line);
        for (DebugBlockEnvContext debugBlockEnvContext : paths) {
            debugBlockEnvContext.getSet().stream().filter(varPoint -> varPoint.getDeclareLine() < line).forEach(varPoint -> map.put(varPoint.getVarName(), this.vars[varPoint.getIndex()]));
        }
        for (Map.Entry entry : this.globalVar.entrySet()) {
            String name = (String)entry.getKey();
            if (map.containsKey(name)) continue;
            map.put(name, entry.getValue());
        }
        return map;
    }

    public int stepOnLine() {
        this.debugStatus = 0;
        this.debugLock.continueRun();
        return this.debugLock.getCurrentLine();
    }

    public int stepNextToBreakLine() {
        this.debugStatus = 1;
        this.debugLock.continueRun();
        return this.debugLock.getCurrentLine();
    }

    public int stepToFinish() {
        this.debugStatus = 2;
        this.debugLock.continueRun();
        return this.debugLock.getCurrentLine();
    }

    public int currentBreakLine() {
        return this.debugLock.getCurrentLine();
    }

    public void addBreakLine(int line) {
        this.breakLines.add(line);
    }

    public void removeBreakLine(int line) {
        this.breakLines.remove(line);
    }

    public Set<Integer> getBreakLines() {
        return this.breakLines;
    }

    public void setBreakLines(Set<Integer> breakLines) {
        this.breakLines = breakLines;
    }

    protected void findBlockPaths(DebugBlockEnvContext block, List<DebugBlockEnvContext> paths, int line) {
        int end;
        int start = block.getBlockStartLine();
        if (start == (end = block.getBlockEndLine())) {
            paths.remove(block);
            return;
        }
        if (start < line && end >= line || start <= line && end > line) {
            for (BlockEnvContext childBlock : block.getBlockList()) {
                DebugBlockEnvContext childDebugBlock = (DebugBlockEnvContext)childBlock;
                paths.add(childDebugBlock);
                this.findBlockPaths(childDebugBlock, paths, line);
            }
        }
    }

    protected DebugContext(GroupTemplate gt, DebugProgramMetaData debugProgramMetaData) {
        super(gt);
        this.debugProgramMetaData = debugProgramMetaData;
    }

    protected DebugContext(GroupTemplate gt, DebugProgramMetaData debugProgramMetaData, ContextBuffer buffer) {
        super(gt, buffer);
        this.debugProgramMetaData = debugProgramMetaData;
    }

    public DebugLock getDebugLock() {
        return this.debugLock;
    }

    public void setDebugLock(DebugLock debugLock) {
        this.debugLock = debugLock;
    }

    public DebugProgramMetaData getDebugProgramMetaData() {
        return this.debugProgramMetaData;
    }

    public void setDebugProgramMetaData(DebugProgramMetaData debugProgramMetaData) {
        this.debugProgramMetaData = debugProgramMetaData;
    }

    public DebugLockListener getDebugLockListener() {
        return this.debugLockListener;
    }

    public void setDebugLockListener(DebugLockListener debugLockListener) {
        this.debugLockListener = debugLockListener;
    }

    public int getDebugStatus() {
        return this.debugStatus;
    }

    public void setDebugStatus(int debugStatus) {
        this.debugStatus = debugStatus;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(int lockTime) {
        this.lockTime = lockTime;
    }
}

