/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.debug;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.beetl.core.debug.DebugContext;
import org.beetl.core.statement.Statement;

public class DebugLock {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    protected DebugContext debugContext;
    protected int currentLine;

    public DebugLock(DebugContext debugContext) {
        this.debugContext = debugContext;
    }

    public void waitRun(long time, Statement nextStatement, int line) {
        if (this.debugContext.getDebugStatus() == 0) {
            this.doLock(time, line);
            return;
        }
        if (this.debugContext.getDebugStatus() == 1) {
            Set<Integer> breaklines = this.debugContext.getBreakLines();
            if (breaklines.isEmpty()) {
                this.doLock(time, line);
                return;
            }
            if (breaklines.contains(line)) {
                this.doLock(time, line);
                return;
            }
        } else if (this.debugContext.getDebugStatus() == 2) {
            // empty if block
        }
    }

    protected void doLock(long time, int line) {
        this.lock.lock();
        try {
            this.currentLine = line;
            if (this.debugContext.getDebugLockListener() != null) {
                this.debugContext.getDebugLockListener().notifyHoldon(this.debugContext, line);
            }
            this.condition.await(time, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void continueRun() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setCurrentLine(int currentLine) {
        this.currentLine = currentLine;
    }

    protected void finalize() throws Throwable {
    }
}

