/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.security;

import com.google.gson.JsonObject;
import com.ibm.cloud.cloudant.common.SdkCommon;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ServiceCookieJar;
import com.ibm.cloud.sdk.core.security.AbstractToken;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.security.TokenServerResponse;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class CouchDbSessionAuthenticator
extends TokenRequestBasedAuthenticator<CouchDbSessionToken, CouchDbSessionToken> {
    public static final String AUTH_TYPE = "COUCHDB_SESSION";
    private final String user;
    private final String pass;
    private final ServiceCookieJar cookieJar;
    private HttpUrl sessionUrl = null;
    private Headers sessionHeaders = null;

    public static Authenticator newAuthenticator(String username, String password) {
        return new CouchDbSessionAuthenticator(username, password);
    }

    private CouchDbSessionAuthenticator(String username, String password) {
        this.user = username;
        this.pass = password;
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        this.cookieJar = new ServiceCookieJar((CookieHandler)cookieManager);
    }

    public ServiceCookieJar getCookieJar() {
        return this.cookieJar;
    }

    public void setSessionUrl(String serviceUrl) {
        this.sessionUrl = RequestBuilder.constructHttpUrl((String)serviceUrl, (String[])new String[]{"_session"});
    }

    public void setHeaders(Map<String, String> headers) {
        HashMap<String, String> mergedHeaders = new HashMap<String, String>();
        mergedHeaders.putAll(SdkCommon.getSdkHeaders("authenticatorPostSession"));
        mergedHeaders.putAll(headers);
        super.setHeaders(mergedHeaders);
        this.sessionHeaders = Headers.of(mergedHeaders);
    }

    public void validate() {
        if (this.user == null || this.user.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "username"));
        }
        if (this.pass == null || this.pass.isEmpty()) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "password"));
        }
    }

    public String authenticationType() {
        return AUTH_TYPE;
    }

    public void authenticate(Request.Builder requestBuilder) {
        super.getToken();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CouchDbSessionToken requestToken() {
        JsonObject creds = new JsonObject();
        creds.addProperty("username", this.user);
        creds.addProperty("password", this.pass);
        RequestBuilder postSessionbuilder = RequestBuilder.post((HttpUrl)this.sessionUrl).bodyJson(creds);
        if (this.sessionHeaders != null) {
            for (String key : this.sessionHeaders.names()) {
                postSessionbuilder.header(new Object[]{key, this.sessionHeaders.get(key)});
            }
        }
        try (Response response = this.getClient().newCall(postSessionbuilder.build()).execute();){
            Cookie cookie;
            if (!response.isSuccessful()) throw new ServiceResponseException(response.code(), response);
            List cookies = Cookie.parseAll((HttpUrl)this.sessionUrl, (Headers)response.headers());
            Iterator iterator = cookies.iterator();
            do {
                if (!iterator.hasNext()) throw new ServiceResponseException(response.code(), response);
            } while (!"AuthSession".equals((cookie = (Cookie)iterator.next()).name()));
            CouchDbSessionToken couchDbSessionToken = new CouchDbSessionToken(cookie.expiresAt());
            return couchDbSessionToken;
        }
        catch (IOException | RuntimeException t) {
            return new CouchDbSessionToken(t);
        }
    }

    public void invalidateToken() {
        this.tokenData = null;
    }

    public static class CouchDbSessionToken
    extends AbstractToken
    implements TokenServerResponse {
        public final long expiryTime;
        public final long refreshTime;

        public CouchDbSessionToken(long expiryTime) {
            this.expiryTime = expiryTime;
            this.refreshTime = expiryTime - (expiryTime - System.currentTimeMillis()) / 5L;
        }

        CouchDbSessionToken(Throwable throwable) {
            super(throwable);
            this.expiryTime = Long.MIN_VALUE;
            this.refreshTime = Long.MIN_VALUE;
        }

        public boolean isTokenValid() {
            return System.currentTimeMillis() < this.expiryTime;
        }

        public boolean needsRefresh() {
            return System.currentTimeMillis() > this.refreshTime;
        }

        public String getAccessToken() {
            return null;
        }
    }
}

