/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class UserContext
extends GenericModel {
    protected String db;
    protected String name;
    protected List<String> roles;

    protected UserContext() {
    }

    protected UserContext(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.roles, (String)"roles cannot be null");
        this.db = builder.db;
        this.name = builder.name;
        this.roles = builder.roles;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    public List<String> roles() {
        return this.roles;
    }

    public static class Builder {
        private String db;
        private String name;
        private List<String> roles;

        private Builder(UserContext userContext) {
            this.db = userContext.db;
            this.name = userContext.name;
            this.roles = userContext.roles;
        }

        public Builder() {
        }

        public Builder(String name, List<String> roles) {
            this.name = name;
            this.roles = roles;
        }

        public UserContext build() {
            return new UserContext(this);
        }

        public Builder addRoles(String roles) {
            Validator.notNull((Object)roles, (String)"roles cannot be null");
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            this.roles.add(roles);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }
    }

    public static interface Roles {
        public static final String READER = "_reader";
        public static final String WRITER = "_writer";
        public static final String ADMIN = "_admin";
        public static final String REPLICATOR = "_replicator";
        public static final String DB_UPDATES = "_db_updates";
        public static final String DESIGN = "_design";
        public static final String SHARDS = "_shards";
        public static final String SECURITY = "_security";
    }
}

