/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ArbitrarySecretPrototype
extends SecretPrototype {
    protected ArbitrarySecretPrototype() {
    }

    protected ArbitrarySecretPrototype(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.secretType, (String)"secretType cannot be null");
        Validator.notNull((Object)builder.payload, (String)"payload cannot be null");
        this.customMetadata = builder.customMetadata;
        this.description = builder.description;
        this.expirationDate = builder.expirationDate;
        this.labels = builder.labels;
        this.name = builder.name;
        this.secretGroupId = builder.secretGroupId;
        this.secretType = builder.secretType;
        this.payload = builder.payload;
        this.versionCustomMetadata = builder.versionCustomMetadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Map<String, Object> customMetadata;
        private String description;
        private Date expirationDate;
        private List<String> labels;
        private String name;
        private String secretGroupId;
        private String secretType;
        private String payload;
        private Map<String, Object> versionCustomMetadata;

        public Builder(SecretPrototype arbitrarySecretPrototype) {
            this.customMetadata = arbitrarySecretPrototype.customMetadata;
            this.description = arbitrarySecretPrototype.description;
            this.expirationDate = arbitrarySecretPrototype.expirationDate;
            this.labels = arbitrarySecretPrototype.labels;
            this.name = arbitrarySecretPrototype.name;
            this.secretGroupId = arbitrarySecretPrototype.secretGroupId;
            this.secretType = arbitrarySecretPrototype.secretType;
            this.payload = arbitrarySecretPrototype.payload;
            this.versionCustomMetadata = arbitrarySecretPrototype.versionCustomMetadata;
        }

        public Builder() {
        }

        public Builder(String name, String secretType, String payload) {
            this.name = name;
            this.secretType = secretType;
            this.payload = payload;
        }

        public ArbitrarySecretPrototype build() {
            return new ArbitrarySecretPrototype(this);
        }

        public Builder addLabels(String labels) {
            Validator.notNull((Object)labels, (String)"labels cannot be null");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(labels);
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder expirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder secretGroupId(String secretGroupId) {
            this.secretGroupId = secretGroupId;
            return this;
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public Builder versionCustomMetadata(Map<String, Object> versionCustomMetadata) {
            this.versionCustomMetadata = versionCustomMetadata;
            return this;
        }
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

