/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretLockPrototype;
import java.util.ArrayList;
import java.util.List;

public class CreateSecretLocksBulkOptions
extends GenericModel {
    protected String id;
    protected List<SecretLockPrototype> locks;
    protected String mode;

    protected CreateSecretLocksBulkOptions() {
    }

    protected CreateSecretLocksBulkOptions(Builder builder) {
        Validator.notEmpty((String)builder.id, (String)"id cannot be empty");
        Validator.notNull((Object)builder.locks, (String)"locks cannot be null");
        this.id = builder.id;
        this.locks = builder.locks;
        this.mode = builder.mode;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String id() {
        return this.id;
    }

    public List<SecretLockPrototype> locks() {
        return this.locks;
    }

    public String mode() {
        return this.mode;
    }

    public static class Builder {
        private String id;
        private List<SecretLockPrototype> locks;
        private String mode;

        private Builder(CreateSecretLocksBulkOptions createSecretLocksBulkOptions) {
            this.id = createSecretLocksBulkOptions.id;
            this.locks = createSecretLocksBulkOptions.locks;
            this.mode = createSecretLocksBulkOptions.mode;
        }

        public Builder() {
        }

        public Builder(String id, List<SecretLockPrototype> locks) {
            this.id = id;
            this.locks = locks;
        }

        public CreateSecretLocksBulkOptions build() {
            return new CreateSecretLocksBulkOptions(this);
        }

        public Builder addLocks(SecretLockPrototype locks) {
            Validator.notNull((Object)((Object)locks), (String)"locks cannot be null");
            if (this.locks == null) {
                this.locks = new ArrayList<SecretLockPrototype>();
            }
            this.locks.add(locks);
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locks(List<SecretLockPrototype> locks) {
            this.locks = locks;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }
    }

    public static interface Mode {
        public static final String REMOVE_PREVIOUS = "remove_previous";
        public static final String REMOVE_PREVIOUS_AND_DELETE = "remove_previous_and_delete";
    }
}

