/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetSecretByNameTypeOptions
extends GenericModel {
    protected String secretType;
    protected String name;
    protected String secretGroupName;

    protected GetSecretByNameTypeOptions() {
    }

    protected GetSecretByNameTypeOptions(Builder builder) {
        Validator.notEmpty((String)builder.secretType, (String)"secretType cannot be empty");
        Validator.notEmpty((String)builder.name, (String)"name cannot be empty");
        Validator.notEmpty((String)builder.secretGroupName, (String)"secretGroupName cannot be empty");
        this.secretType = builder.secretType;
        this.name = builder.name;
        this.secretGroupName = builder.secretGroupName;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String secretType() {
        return this.secretType;
    }

    public String name() {
        return this.name;
    }

    public String secretGroupName() {
        return this.secretGroupName;
    }

    public static class Builder {
        private String secretType;
        private String name;
        private String secretGroupName;

        private Builder(GetSecretByNameTypeOptions getSecretByNameTypeOptions) {
            this.secretType = getSecretByNameTypeOptions.secretType;
            this.name = getSecretByNameTypeOptions.name;
            this.secretGroupName = getSecretByNameTypeOptions.secretGroupName;
        }

        public Builder() {
        }

        public Builder(String secretType, String name, String secretGroupName) {
            this.secretType = secretType;
            this.name = name;
            this.secretGroupName = secretGroupName;
        }

        public GetSecretByNameTypeOptions build() {
            return new GetSecretByNameTypeOptions(this);
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder secretGroupName(String secretGroupName) {
            this.secretGroupName = secretGroupName;
            return this;
        }
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

