/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.RotationPolicy;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IAMCredentialsSecretPrototype
extends SecretPrototype {
    protected IAMCredentialsSecretPrototype() {
    }

    protected IAMCredentialsSecretPrototype(Builder builder) {
        Validator.notNull((Object)builder.secretType, (String)"secretType cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.ttl, (String)"ttl cannot be null");
        Validator.notNull((Object)builder.reuseApiKey, (String)"reuseApiKey cannot be null");
        this.secretType = builder.secretType;
        this.name = builder.name;
        this.description = builder.description;
        this.secretGroupId = builder.secretGroupId;
        this.labels = builder.labels;
        this.ttl = builder.ttl;
        this.accessGroups = builder.accessGroups;
        this.serviceId = builder.serviceId;
        this.accountId = builder.accountId;
        this.reuseApiKey = builder.reuseApiKey;
        this.rotation = builder.rotation;
        this.customMetadata = builder.customMetadata;
        this.versionCustomMetadata = builder.versionCustomMetadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String secretType;
        private String name;
        private String description;
        private String secretGroupId;
        private List<String> labels;
        private String ttl;
        private List<String> accessGroups;
        private String serviceId;
        private String accountId;
        private Boolean reuseApiKey;
        private RotationPolicy rotation;
        private Map<String, Object> customMetadata;
        private Map<String, Object> versionCustomMetadata;

        public Builder(SecretPrototype iamCredentialsSecretPrototype) {
            this.secretType = iamCredentialsSecretPrototype.secretType;
            this.name = iamCredentialsSecretPrototype.name;
            this.description = iamCredentialsSecretPrototype.description;
            this.secretGroupId = iamCredentialsSecretPrototype.secretGroupId;
            this.labels = iamCredentialsSecretPrototype.labels;
            this.ttl = iamCredentialsSecretPrototype.ttl;
            this.accessGroups = iamCredentialsSecretPrototype.accessGroups;
            this.serviceId = iamCredentialsSecretPrototype.serviceId;
            this.accountId = iamCredentialsSecretPrototype.accountId;
            this.reuseApiKey = iamCredentialsSecretPrototype.reuseApiKey;
            this.rotation = iamCredentialsSecretPrototype.rotation;
            this.customMetadata = iamCredentialsSecretPrototype.customMetadata;
            this.versionCustomMetadata = iamCredentialsSecretPrototype.versionCustomMetadata;
        }

        public Builder() {
        }

        public Builder(String secretType, String name, String ttl, Boolean reuseApiKey) {
            this.secretType = secretType;
            this.name = name;
            this.ttl = ttl;
            this.reuseApiKey = reuseApiKey;
        }

        public IAMCredentialsSecretPrototype build() {
            return new IAMCredentialsSecretPrototype(this);
        }

        public Builder addLabels(String labels) {
            Validator.notNull((Object)labels, (String)"labels cannot be null");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(labels);
            return this;
        }

        public Builder addAccessGroups(String accessGroups) {
            Validator.notNull((Object)accessGroups, (String)"accessGroups cannot be null");
            if (this.accessGroups == null) {
                this.accessGroups = new ArrayList<String>();
            }
            this.accessGroups.add(accessGroups);
            return this;
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder secretGroupId(String secretGroupId) {
            this.secretGroupId = secretGroupId;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder accessGroups(List<String> accessGroups) {
            this.accessGroups = accessGroups;
            return this;
        }

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder reuseApiKey(Boolean reuseApiKey) {
            this.reuseApiKey = reuseApiKey;
            return this;
        }

        public Builder rotation(RotationPolicy rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder versionCustomMetadata(Map<String, Object> versionCustomMetadata) {
            this.versionCustomMetadata = versionCustomMetadata;
            return this;
        }
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

