/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KVSecretPrototype
extends SecretPrototype {
    protected KVSecretPrototype() {
    }

    protected KVSecretPrototype(Builder builder) {
        Validator.notNull((Object)builder.secretType, (String)"secretType cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.data, (String)"data cannot be null");
        this.secretType = builder.secretType;
        this.name = builder.name;
        this.description = builder.description;
        this.secretGroupId = builder.secretGroupId;
        this.labels = builder.labels;
        this.data = builder.data;
        this.customMetadata = builder.customMetadata;
        this.versionCustomMetadata = builder.versionCustomMetadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String secretType;
        private String name;
        private String description;
        private String secretGroupId;
        private List<String> labels;
        private Map<String, Object> data;
        private Map<String, Object> customMetadata;
        private Map<String, Object> versionCustomMetadata;

        public Builder(SecretPrototype kvSecretPrototype) {
            this.secretType = kvSecretPrototype.secretType;
            this.name = kvSecretPrototype.name;
            this.description = kvSecretPrototype.description;
            this.secretGroupId = kvSecretPrototype.secretGroupId;
            this.labels = kvSecretPrototype.labels;
            this.data = kvSecretPrototype.data;
            this.customMetadata = kvSecretPrototype.customMetadata;
            this.versionCustomMetadata = kvSecretPrototype.versionCustomMetadata;
        }

        public Builder() {
        }

        public Builder(String secretType, String name, Map<String, Object> data) {
            this.secretType = secretType;
            this.name = name;
            this.data = data;
        }

        public KVSecretPrototype build() {
            return new KVSecretPrototype(this);
        }

        public Builder addLabels(String labels) {
            Validator.notNull((Object)labels, (String)"labels cannot be null");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(labels);
            return this;
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder secretGroupId(String secretGroupId) {
            this.secretGroupId = secretGroupId;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder data(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder versionCustomMetadata(Map<String, Object> versionCustomMetadata) {
            this.versionCustomMetadata = versionCustomMetadata;
            return this;
        }
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

