/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model;

import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.PasswordGenerationPolicy;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.RotationPolicy;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class UsernamePasswordSecretPrototype
extends SecretPrototype {
    protected UsernamePasswordSecretPrototype() {
    }

    protected UsernamePasswordSecretPrototype(Builder builder) {
        Validator.notNull((Object)builder.secretType, (String)"secretType cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.username, (String)"username cannot be null");
        this.secretType = builder.secretType;
        this.name = builder.name;
        this.description = builder.description;
        this.secretGroupId = builder.secretGroupId;
        this.labels = builder.labels;
        this.username = builder.username;
        this.password = builder.password;
        this.expirationDate = builder.expirationDate;
        this.customMetadata = builder.customMetadata;
        this.versionCustomMetadata = builder.versionCustomMetadata;
        this.rotation = builder.rotation;
        this.passwordGenerationPolicy = builder.passwordGenerationPolicy;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String secretType;
        private String name;
        private String description;
        private String secretGroupId;
        private List<String> labels;
        private String username;
        private String password;
        private Date expirationDate;
        private Map<String, Object> customMetadata;
        private Map<String, Object> versionCustomMetadata;
        private RotationPolicy rotation;
        private PasswordGenerationPolicy passwordGenerationPolicy;

        public Builder(SecretPrototype usernamePasswordSecretPrototype) {
            this.secretType = usernamePasswordSecretPrototype.secretType;
            this.name = usernamePasswordSecretPrototype.name;
            this.description = usernamePasswordSecretPrototype.description;
            this.secretGroupId = usernamePasswordSecretPrototype.secretGroupId;
            this.labels = usernamePasswordSecretPrototype.labels;
            this.username = usernamePasswordSecretPrototype.username;
            this.password = usernamePasswordSecretPrototype.password;
            this.expirationDate = usernamePasswordSecretPrototype.expirationDate;
            this.customMetadata = usernamePasswordSecretPrototype.customMetadata;
            this.versionCustomMetadata = usernamePasswordSecretPrototype.versionCustomMetadata;
            this.rotation = usernamePasswordSecretPrototype.rotation;
            this.passwordGenerationPolicy = usernamePasswordSecretPrototype.passwordGenerationPolicy;
        }

        public Builder() {
        }

        public Builder(String secretType, String name, String username) {
            this.secretType = secretType;
            this.name = name;
            this.username = username;
        }

        public UsernamePasswordSecretPrototype build() {
            return new UsernamePasswordSecretPrototype(this);
        }

        public Builder addLabels(String labels) {
            Validator.notNull((Object)labels, (String)"labels cannot be null");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(labels);
            return this;
        }

        public Builder secretType(String secretType) {
            this.secretType = secretType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder secretGroupId(String secretGroupId) {
            this.secretGroupId = secretGroupId;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder expirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder versionCustomMetadata(Map<String, Object> versionCustomMetadata) {
            this.versionCustomMetadata = versionCustomMetadata;
            return this;
        }

        public Builder rotation(RotationPolicy rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder passwordGenerationPolicy(PasswordGenerationPolicy passwordGenerationPolicy) {
            this.passwordGenerationPolicy = passwordGenerationPolicy;
            return this;
        }
    }

    public static interface SecretType {
        public static final String ARBITRARY = "arbitrary";
        public static final String IAM_CREDENTIALS = "iam_credentials";
        public static final String IMPORTED_CERT = "imported_cert";
        public static final String KV = "kv";
        public static final String PRIVATE_CERT = "private_cert";
        public static final String PUBLIC_CERT = "public_cert";
        public static final String SERVICE_CREDENTIALS = "service_credentials";
        public static final String USERNAME_PASSWORD = "username_password";
        public static final String CUSTOM_CREDENTIALS = "custom_credentials";
    }
}

