/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.proxy.db2.ProxiedDB2StatementInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.JDBCDynamicExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.JDBCDynamicResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2PreparedStatementExecutionHandler;
import com.ibm.db2.jcc.DB2Statement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDBCDynamicExecutionHandlerPropertiesRefresh
extends StatementExecutionHandler
implements PreparedStatementExecutionHandler {
    private PreparedStatement physicalPreparedStmt_ = null;

    public JDBCDynamicExecutionHandlerPropertiesRefresh(ConnectionExecutionHandler connectionExecutionHandler, Statement statement, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, String string, Method method, Object ... objectArray) throws SQLException {
        super(connectionExecutionHandler, statement, n2, n3, n4, stringArray, nArray, n5, string, method, objectArray);
        if (statement instanceof PreparedStatement) {
            this.physicalPreparedStmt_ = (PreparedStatement)statement;
        }
        this.sqlStr_ = string.equals("prepareStatement") || string.equals("prepareCall") ? (String)objectArray[0] : "";
    }

    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        if (Configuration.isLicensed__ && (string.startsWith("set") || string.startsWith("closeOn"))) {
            this.modifiedStatementAttributes_.saveModifiedAttributeIfNeeded(string, method, objectArray);
        } else {
            char c10 = string.charAt(0);
            if (c10 == 'a') {
                if ("addDBBatch".equals(string)) {
                    this.addDBBatch_(method, objectArray);
                    return null;
                }
                if ("addBatch".equals(string) && objectArray != null && objectArray.length == 1 && Proxy.isProxyClass(objectArray[0].getClass())) {
                    return JDBCDynamicExecutionHandler.unwrapForSQLJBatch(this.physicalStatement_, method, objectArray);
                }
            }
        }
        return method.invoke((Object)this.physicalStatement_, objectArray);
    }

    protected void addDBBatch_(Method method, Object[] objectArray) throws Throwable {
        List list = (List)objectArray[0];
        int n2 = list.size();
        Object var5_5 = null;
        ProxiedDB2StatementInvocationHandler proxiedDB2StatementInvocationHandler = null;
        for (int i10 = 0; i10 < n2; ++i10) {
            var5_5 = list.get(i10);
            if (!(var5_5 instanceof Proxy)) continue;
            proxiedDB2StatementInvocationHandler = (ProxiedDB2StatementInvocationHandler)Proxy.getInvocationHandler(var5_5);
            list.set(i10, (DB2Statement)proxiedDB2StatementInvocationHandler.getExecutionHandler().getUnderlyingObject());
        }
        ((DB2Statement)this.physicalStatement_).addDBBatch(list);
    }

    @Override
    public Object[] pullData(int n2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionHandler getNewExecutionHandler() throws SQLException {
        ExecutionHandler executionHandler;
        try {
            this.physicalStatement_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.cachedConnectionAttributesForStatement_.equals(this.connExecutionHandler_.getCurrentConnectionAttributes())) {
            Connection connection;
            Connection connection2 = connection = this.connExecutionHandler_.physicalConnection_;
            synchronized (connection2) {
                try {
                    this.cachedConnectionAttributesForStatement_.transferCachedConnectionAttributes(connection);
                    executionHandler = (ExecutionHandler)this.connExecutionHandler_.invoke(this.methodName_, this.method_, this.args_);
                    executionHandler.setCachedConnectionAttributes(this.cachedConnectionAttributesForStatement_);
                }
                catch (Throwable throwable) {
                    throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11029);
                }
                finally {
                    try {
                        this.connExecutionHandler_.restoreConnectionAttributes();
                    }
                    catch (Throwable throwable) {
                        throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11098);
                    }
                }
            }
        }
        try {
            executionHandler = (ExecutionHandler)this.connExecutionHandler_.invoke(this.methodName_, this.method_, this.args_);
            executionHandler.setCachedConnectionAttributes(this.cachedConnectionAttributesForStatement_);
        }
        catch (Throwable throwable) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11099);
        }
        executionHandler.setAndTransferModifiedStatementAttributes(this.modifiedStatementAttributes_);
        return executionHandler;
    }

    @Override
    public ExecutionHandler checkAndReplaceExecutionHandler() throws SQLException {
        if (this.propertyRefreshEnabled_ && this.propertyRedirectedKey_.isModified()) {
            ExecutionHandler executionHandler = this.getNewExecutionHandler();
            if (this.logger_.isLoggable(Level.CONFIG)) {
                JDBCDynamicExecutionHandlerPropertiesRefresh.logNewExecutionHandler(this.logger_, this.connExecutionHandler_.driverTraceOn_, this.sqlStr_, this.physicalStatement_, this, executionHandler, this.connExecutionHandler_);
            }
            return executionHandler;
        }
        return this;
    }

    public static void logNewExecutionHandler(Logger logger, boolean bl2, String string, Statement statement, ExecutionHandler executionHandler, ExecutionHandler executionHandler2, ConnectionExecutionHandler connectionExecutionHandler) {
        Object object = executionHandler2.getUnderlyingObject();
        String string2 = executionHandler instanceof DB2PreparedStatementExecutionHandler ? (((DB2PreparedStatementExecutionHandler)executionHandler).isStaticStmt() ? " (Static)" : " (Dynamic)") : " (Dynamic)";
        String string3 = executionHandler2 instanceof DB2PreparedStatementExecutionHandler ? (((DB2PreparedStatementExecutionHandler)executionHandler2).isStaticStmt() ? " (Static)" : " (Dynamic)") : " (Dynamic)";
        String string4 = logger.isLoggable(Level.FINER) || bl2 ? "" : " Sql: " + string;
        String string5 = "[Thread:" + Thread.currentThread().getName() + "][" + DataLogger.getShortName(executionHandler) + "][checkAndReplaceExecutionHandler] ";
        logger.logp(Level.CONFIG, null, null, string5 + "Properties Refresh detected a change. The physical " + DataLogger.getShortName(statement) + string2 + " has been closed.\nA new " + DataLogger.getShortName(executionHandler2) + " with a new physical " + DataLogger.getShortName(object) + string3 + " has been created. " + string4 + "\nNew Resolved States: " + connectionExecutionHandler.getCurrentStates().toString());
    }

    @Override
    public PreparedStatement getUnderlyingPreparedStatement() {
        if (this.physicalPreparedStmt_ != null) {
            return this.physicalPreparedStmt_;
        }
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CO_STMT_TYPE", "getUnderlyingPreparedStatement ()"), null, 11757);
    }

    @Override
    public ResultSetExecutionHandler executeQuery() throws SQLException {
        ResultSet resultSet = null;
        if (this.physicalPreparedStmt_ != null && (resultSet = this.physicalPreparedStmt_.executeQuery()) != null) {
            return new JDBCDynamicResultSetExecutionHandler(this, resultSet);
        }
        throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_CO_STMT_TYPE", "getUnderlyingPreparedStatement ()"), "", null, 11756);
    }

    protected ResultSetExecutionHandler wrapResultSet(ResultSet resultSet) throws SQLException {
        return new JDBCDynamicResultSetExecutionHandler(this, resultSet);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return 0;
    }

    @Override
    public boolean execute() throws SQLException {
        return false;
    }

    @Override
    public ResultSetExecutionHandler getResultSet() throws SQLException {
        return null;
    }

    @Override
    protected int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordNonQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, long l8, long l9, int n2) throws SQLException {
        return null;
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement, ResultSet resultSet, long l8, long l9, int n2, int n3) throws SQLException {
        return null;
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordBatchedQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement) throws SQLException {
        return null;
    }
}

