/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.metadata;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlConnection;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDatabase;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDriver;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlOriginEnvironment;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.cmx.tools.internal.generator.GeneratorImpl;
import com.ibm.db2.cmx.tools.internal.generator.HandlerInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassInfo {
    private Set<String> listOfImportDeclaration_;
    private String typeName_;
    private boolean isInterface_;
    private String packageName_;
    private List<MethodInfo> listOfMethods_;
    private String modifier_;
    private boolean generateStaticArtifacts_;
    private byte[] conTokenBytes_ = null;
    private long timeStamp_;
    protected String packageVersion_ = null;
    protected boolean isPackageVersionAutoGenerated_;
    protected String rootPkgName_ = null;
    protected boolean longPkgName_ = false;
    protected String collectionName_ = null;
    protected String bindOptions_ = null;
    protected Map<String, TypeInfo> vtiMetadataMap_;
    protected Map<String, BeanInformation> qocBeanInfoMap_;
    protected boolean generateForQOC_;
    protected ArtifactOptionsSet artifactOptionsSet_;
    private String qualifiedImplName_;
    private String qualifiedInterfaceName_;
    private OriginInfo originInfo_ = new OriginInfo();
    private boolean forceSingleBindIsolation_ = false;
    private List<HandlerInfo> handlerInfoListToExtern_;
    private GeneratorImpl generatorImpl_;

    public boolean isForceSingleBindIsolation() {
        return this.forceSingleBindIsolation_;
    }

    public void setForceSingleBindIsolation(boolean bl2) {
        this.forceSingleBindIsolation_ = bl2;
    }

    public boolean isInterface() {
        return this.isInterface_;
    }

    public void setInterface(boolean bl2) {
        this.isInterface_ = bl2;
    }

    public Set<String> getListOfImportDeclaration() {
        return this.listOfImportDeclaration_;
    }

    public void addImportDeclaration(String string) {
        int n2 = string.indexOf(60);
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        if (this.listOfImportDeclaration_ == null) {
            this.listOfImportDeclaration_ = new HashSet<String>();
        }
        this.listOfImportDeclaration_.add(string);
    }

    public List<MethodInfo> getListOfMethods() {
        return this.listOfMethods_;
    }

    public void setListOfMethods(List<MethodInfo> list) {
        this.listOfMethods_ = list;
    }

    public void addMethodInfoToList(MethodInfo methodInfo) {
        if (this.listOfMethods_ == null) {
            this.listOfMethods_ = new ArrayList<MethodInfo>();
        }
        this.checkForSimilarMethods(methodInfo);
        this.listOfMethods_.add(methodInfo);
    }

    private void checkForSimilarMethods(MethodInfo methodInfo) {
        String string = methodInfo.getMethodName();
        List<TypeInfo> list = methodInfo.getParameterList();
        boolean bl2 = false;
        for (MethodInfo methodInfo2 : this.listOfMethods_) {
            if (string.equals(methodInfo2.getMethodName())) {
                List<TypeInfo> list2 = methodInfo2.getParameterList();
                if (null == list2 && null == list) {
                    bl2 = true;
                }
                if (null != list2 && null != list && list2.size() == list.size()) {
                    int n2 = 0;
                    boolean bl3 = true;
                    for (TypeInfo typeInfo : list2) {
                        if (typeInfo.getQualifiedName().equals(list.get(n2).getQualifiedName())) continue;
                        bl3 = false;
                    }
                    if (bl3) {
                        bl2 = true;
                    }
                }
            }
            if (!bl2) continue;
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_OVERRIDE", methodInfo.getMethodNameAndParameterTypesString()), null, 10329, null, methodInfo);
        }
    }

    public String getPackageName() {
        return this.packageName_;
    }

    public void setPackageName(String string) {
        this.packageName_ = string;
    }

    public String getTypeName() {
        return this.typeName_;
    }

    public void setTypeName(String string) {
        this.typeName_ = string;
    }

    public String getModifier() {
        return this.modifier_;
    }

    public void setModifier(String string) {
        this.modifier_ = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IMPORTS\n");
        if (this.listOfImportDeclaration_ != null) {
            for (String object : this.listOfImportDeclaration_) {
                stringBuffer.append("\t" + object + "\n");
            }
        }
        stringBuffer.append("PACKAGE NAME\n");
        stringBuffer.append("\t" + this.packageName_ + "\n");
        stringBuffer.append("TYPE Name\n");
        stringBuffer.append("\t" + this.typeName_ + "\n");
        stringBuffer.append("IS INTERFACE\n");
        stringBuffer.append("\t" + this.isInterface_ + "\n");
        stringBuffer.append("MODIFIERS\n");
        stringBuffer.append("\t" + this.modifier_ + "\n");
        stringBuffer.append("GENERATE Static Artifacts \n");
        stringBuffer.append("\t" + this.generateStaticArtifacts_ + "\n");
        if (this.listOfMethods_ != null) {
            for (MethodInfo methodInfo : this.listOfMethods_) {
                stringBuffer.append(methodInfo);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isGenerateStaticArtifacts() {
        return this.generateStaticArtifacts_;
    }

    public void setGenerateStaticArtifacts(boolean bl2) {
        this.generateStaticArtifacts_ = bl2;
    }

    public String getBindOptions() {
        return this.bindOptions_;
    }

    public void setBindOptions(String string) {
        this.bindOptions_ = string;
    }

    public String getCollectionName() {
        return this.collectionName_;
    }

    public void setCollectionName(String string) {
        this.collectionName_ = string;
    }

    public byte[] getConTokenBytes() {
        return this.conTokenBytes_;
    }

    public void setConTokenBytes(byte[] byArray) {
        this.conTokenBytes_ = byArray;
    }

    public boolean isLongPkgName() {
        return this.longPkgName_;
    }

    public void setLongPkgName(boolean bl2) {
        this.longPkgName_ = bl2;
    }

    public boolean isPackageVersionAutoGenerated() {
        return this.isPackageVersionAutoGenerated_;
    }

    public String getPackageVersion() {
        return this.packageVersion_;
    }

    public void setPackageVersion(String string, long l8) {
        this.isPackageVersionAutoGenerated_ = StatementUtilities.isPackageVersionAutoGenerated(string);
        this.packageVersion_ = StatementUtilities.getPackageVersion(string, l8);
    }

    public String getRootPkgName() {
        return this.rootPkgName_;
    }

    public void setRootPkgName(String string) {
        this.rootPkgName_ = string;
    }

    public Map<String, TypeInfo> getVtiMetadataMap() {
        return this.vtiMetadataMap_;
    }

    public void setVtiMetadataMap(Map<String, TypeInfo> map) {
        this.vtiMetadataMap_ = map;
    }

    public void addToVtoMetaDataMap(String string, TypeInfo typeInfo) {
        if (this.vtiMetadataMap_ == null) {
            this.vtiMetadataMap_ = new HashMap<String, TypeInfo>();
        }
        this.vtiMetadataMap_.put(string, typeInfo);
    }

    public Map<String, BeanInformation> getQocBeanInfoMap() {
        return this.qocBeanInfoMap_;
    }

    public void setQocBeanInfoMap(Map<String, BeanInformation> map) {
        this.qocBeanInfoMap_ = map;
    }

    public void addQocBeanInfoMap(String string, BeanInformation beanInformation) {
        if (this.qocBeanInfoMap_ == null) {
            this.qocBeanInfoMap_ = new HashMap<String, BeanInformation>();
        }
        this.qocBeanInfoMap_.put(string, beanInformation);
    }

    public boolean isGenerateForQOC() {
        return this.generateForQOC_;
    }

    public void setGenerateForQOC(boolean bl2) {
        this.generateForQOC_ = bl2;
    }

    public long getTimeStamp() {
        return this.timeStamp_;
    }

    public void setTimeStamp(long l8) {
        this.timeStamp_ = l8;
    }

    public ArtifactOptionsSet getArtifactOptionsSet() {
        return this.artifactOptionsSet_;
    }

    public void setArtifactOptionsSet(ArtifactOptionsSet artifactOptionsSet) {
        this.artifactOptionsSet_ = artifactOptionsSet;
    }

    public String getQualifiedImplName() {
        if (this.qualifiedImplName_ == null) {
            this.qualifiedImplName_ = (this.packageName_ != null ? this.packageName_ + "." : "") + this.typeName_ + "Impl";
        }
        return this.qualifiedImplName_;
    }

    public String getQualifiedInterfaceName() {
        if (this.qualifiedInterfaceName_ == null) {
            this.qualifiedInterfaceName_ = (this.packageName_ != null ? this.packageName_ + "." : "") + this.typeName_;
        }
        return this.qualifiedInterfaceName_;
    }

    public void setOriginInfo(OriginInfo originInfo) {
        this.originInfo_ = originInfo;
    }

    public OriginInfo getOriginInfo() {
        return this.originInfo_;
    }

    public String getImplTypeName() {
        return this.typeName_ + "Impl";
    }

    public List<HandlerInfo> getHandlerInfoListToExtern() {
        return this.handlerInfoListToExtern_;
    }

    public void setHandlerInfoListToExtern(List<HandlerInfo> list) {
        this.handlerInfoListToExtern_ = list;
    }

    public GeneratorImpl getGeneratorImpl() {
        return this.generatorImpl_;
    }

    public void setGeneratorImpl(GeneratorImpl generatorImpl) {
        this.generatorImpl_ = generatorImpl;
    }

    public class OriginInfo {
        private String absolutePathToXmlFile_ = null;
        private long lastModificationDateOfXmlFile_;
        private String generatorVersion_;
        private PDQXmlOriginEnvironment originEnv_ = new PDQXmlOriginEnvironment();
        private String outputFileRootLocation_ = null;
        private String ouputFileCompletePath_ = null;
        private String outputFileCompletePathAndRootName_ = null;

        public OriginInfo() {
            this.generatorVersion_ = DataVersion.getProductNameAndVersion();
        }

        public String getAbsolutePathToXmlFile() {
            return this.absolutePathToXmlFile_;
        }

        public void setAbsolutePathToXmlFile(String string) {
            this.absolutePathToXmlFile_ = string;
        }

        public long getLastModificationDateOfXmlFile() {
            return this.lastModificationDateOfXmlFile_;
        }

        public void setLastModificationDateOfXmlFile(long l8) {
            this.lastModificationDateOfXmlFile_ = l8;
        }

        public void setDatabaseConnectionInfo(Connection connection) {
            if (connection != null) {
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    PDQXmlConnection pDQXmlConnection = new PDQXmlConnection();
                    pDQXmlConnection.init(databaseMetaData, (short)21);
                    this.originEnv_.setPDQXmlConnection(pDQXmlConnection);
                    PDQXmlDriver pDQXmlDriver = new PDQXmlDriver();
                    pDQXmlDriver.init(databaseMetaData);
                    this.originEnv_.setPDQXmlDriver(pDQXmlDriver);
                    PDQXmlDatabase pDQXmlDatabase = new PDQXmlDatabase();
                    pDQXmlDatabase.init(databaseMetaData);
                    this.originEnv_.setPDQXmlDatabase(pDQXmlDatabase);
                }
                catch (SQLException sQLException) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GENERATOR_FAILED_TO_GET_DATABASE_METADATA", new Object[0]), sQLException, 10312, null, null);
                }
            }
        }

        public String getGeneratorVersion() {
            return this.generatorVersion_;
        }

        public void setGeneratorVersion(String string) {
            this.generatorVersion_ = string;
        }

        public void setOutputFileRootLocation(String string) {
            this.outputFileRootLocation_ = string;
        }

        public String getOutputFileRootLocation() {
            return this.outputFileRootLocation_;
        }

        public String getOutputFileCompletePath() {
            if (this.ouputFileCompletePath_ == null) {
                this.ouputFileCompletePath_ = this.outputFileRootLocation_;
                if (ClassInfo.this.packageName_ != null && !"".equals(ClassInfo.this.packageName_)) {
                    this.ouputFileCompletePath_ = this.ouputFileCompletePath_ + File.separator + ClassInfo.this.packageName_.replace('.', File.separatorChar);
                }
            }
            return this.ouputFileCompletePath_;
        }

        public String getOutputFileCompletePathAndRootName() {
            if (this.outputFileCompletePathAndRootName_ == null) {
                this.outputFileCompletePathAndRootName_ = this.getOutputFileCompletePath() + File.separator + ClassInfo.this.typeName_ + "Impl";
            }
            return this.outputFileCompletePathAndRootName_;
        }

        public PDQXmlOriginEnvironment getOriginEnv() {
            return this.originEnv_;
        }

        public void setOriginEnv(PDQXmlOriginEnvironment pDQXmlOriginEnvironment) {
            this.originEnv_ = pDQXmlOriginEnvironment;
        }

        public void setConnectionSchema(String string) {
            this.originEnv_.getPDQXmlConnection().setConnectionSchema(string);
        }
    }
}

