/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.am;

public class ProductLevel {
    public String databaseProductName_;
    public int serverType_;
    public int versionLevel_;
    public int releaseLevel_;
    public char modificationLevel_;
    public String functionalLevel_;
    public String databaseProductVersion_;
    private static final String db2ForMVSString = "DSN";
    private static final String db2ForSQLDSString = "ARI";
    private static final String db2ForAS400String = "QSQ";
    private static final String db2ForUWOString = "SQL";
    private static final String cloudscapeString = "CSS";
    private static final String informixString = "IFX";
    public static final int db2ForMVS = 1;
    public static final int db2ForSQLDS = 2;
    public static final int db2ForAS400 = 3;
    public static final int db2ForUWO = 4;
    public static final int cloudscape = 5;
    public static final int informix = 6;
    public static final int unknownDatabaseProductServerType = 0;

    public static final String serverName(int n2) {
        switch (n2) {
            case 1: {
                return "z/OS";
            }
            case 2: {
                return "SQLDS";
            }
            case 3: {
                return "iSeries";
            }
            case 4: {
                return "DB2 for Unix/Windows";
            }
            case 5: {
                return "Cloudscape";
            }
            case 6: {
                return "Informix";
            }
        }
        return "Unknown";
    }

    public ProductLevel(String string, String string2, String string3, String string4) {
        this.serverType_ = this.getServerType(string.substring(0, 3));
        this.versionLevel_ = Integer.parseInt(string.substring(3, 5));
        this.releaseLevel_ = Integer.parseInt(string.substring(5, 7));
        this.modificationLevel_ = string.substring(7, 8).charAt(0);
        this.databaseProductName_ = string2 == null ? ProductLevel.serverName(this.serverType_) : string2;
        this.functionalLevel_ = string4;
        int n2 = 0;
        if (this.serverType_ != 5) {
            this.databaseProductVersion_ = string;
        } else {
            if (string3 != null) {
                n2 = string3.indexOf(47) + 1;
                this.databaseProductVersion_ = string3.substring(n2);
            }
            if (this.databaseProductVersion_ == null) {
                this.databaseProductVersion_ = string;
            }
        }
    }

    public boolean greaterThanOrEqualTo(int n2, int n3, char c10) {
        if (this.versionLevel_ > n2) {
            return true;
        }
        if (this.versionLevel_ == n2) {
            if (this.releaseLevel_ > n3) {
                return true;
            }
            if (this.releaseLevel_ == n3 && this.modificationLevel_ >= c10) {
                return true;
            }
        }
        return false;
    }

    public boolean lessThan(int n2, int n3, char c10) {
        if (this.versionLevel_ < n2) {
            return true;
        }
        if (this.versionLevel_ == n2) {
            if (this.releaseLevel_ < n3) {
                return true;
            }
            if (this.releaseLevel_ == n3 && this.modificationLevel_ < c10) {
                return true;
            }
        }
        return false;
    }

    private int getServerType(String string) {
        if (string.equalsIgnoreCase(db2ForMVSString)) {
            return 1;
        }
        if (string.equalsIgnoreCase(db2ForSQLDSString)) {
            return 2;
        }
        if (string.equalsIgnoreCase(db2ForAS400String)) {
            return 3;
        }
        if (string.equalsIgnoreCase(db2ForUWOString)) {
            return 4;
        }
        if (string.equalsIgnoreCase(cloudscapeString)) {
            return 5;
        }
        if (string.equalsIgnoreCase(informixString)) {
            return 6;
        }
        return 0;
    }
}

