/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.CMXException;
import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.MonitorSettings;
import com.ibm.db2.cmx.MonitoredData;
import com.ibm.db2.cmx.MonitoredDataCache;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.RegistryInterface;
import com.ibm.db2.cmx.impl.DataSourceDescriptor;
import com.ibm.db2.cmx.impl.DriverDescriptor;
import com.ibm.db2.cmx.impl.MonitoredDataCacheImpl;
import com.ibm.db2.cmx.internal.controller.ControlDataSourcePool;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Registry
implements RegistryInterface {
    HashMap<String, DriverDescriptor> driverIdToDescriptorMap_;
    HashMap<String, Profile.Driver> driverIdToProfileMap_;
    HashMap<String, DataSourceDescriptor> datasourceIdToDescriptorMap_;
    HashMap<String, Profile.DataSource> datasourceIdToProfileMap_;
    HashMap<String, Database> databaseMap_;
    HashMap<String, Profile.Driver> driverProfileNameToProfileMap_;
    HashMap<String, Profile.DataSource> datasourceProfileNameToProfileMap_;
    HashMap<String, Long> timeOfDriverIdReferenceMap_;
    HashMap<String, Long> timeOfDataSourceIdReferenceMap_;
    HashMap<String, Set<String>> profileNameToRegisteredDriverIds_;
    HashMap<String, Set<String>> profileNameToRegisteredDataSourceIds_;
    HashMap<String, Set<String>> logicalDatabaseNameToRegisteredDataSourceIds_;
    private static Logger logger__ = Log.getCMXServerLogger();
    public HashMap<String, JSONArray> registryForEI_ = new HashMap();
    int cachingIntervalForMonitoredData_ = 300;
    long inMemoryCacheLimitForMonitoredData_ = 500000000L;
    MonitoredDataCacheImpl monitoredDataCache_ = null;
    CacheReaperTask cacheReaperTask_;
    Timer timer_;

    public Registry() {
        this.driverIdToDescriptorMap_ = new HashMap();
        this.driverIdToProfileMap_ = new HashMap();
        this.datasourceIdToDescriptorMap_ = new HashMap();
        this.datasourceIdToProfileMap_ = new HashMap();
        this.databaseMap_ = new HashMap();
        this.driverProfileNameToProfileMap_ = new HashMap();
        this.datasourceProfileNameToProfileMap_ = new HashMap();
        this.timeOfDriverIdReferenceMap_ = new HashMap();
        this.timeOfDataSourceIdReferenceMap_ = new HashMap();
        this.profileNameToRegisteredDriverIds_ = new HashMap();
        this.profileNameToRegisteredDataSourceIds_ = new HashMap();
        this.logicalDatabaseNameToRegisteredDataSourceIds_ = new HashMap();
        this.timer_ = new Timer("CMX Cache Reaper", true);
        this.initializeCacheReaperTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeCache() {
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.enter(logger__, this, "purgeCache");
            }
            HashMap<String, Object> hashMap = this.driverIdToDescriptorMap_;
            synchronized (hashMap) {
                this.driverIdToDescriptorMap_.clear();
            }
            hashMap = this.driverIdToProfileMap_;
            synchronized (hashMap) {
                this.driverIdToProfileMap_.clear();
            }
            hashMap = this.datasourceIdToDescriptorMap_;
            synchronized (hashMap) {
                this.datasourceIdToDescriptorMap_.clear();
            }
            hashMap = this.datasourceIdToProfileMap_;
            synchronized (hashMap) {
                this.datasourceIdToProfileMap_.clear();
            }
            hashMap = this.databaseMap_;
            synchronized (hashMap) {
                this.databaseMap_.clear();
            }
            hashMap = this.driverProfileNameToProfileMap_;
            synchronized (hashMap) {
                this.driverProfileNameToProfileMap_.clear();
            }
            hashMap = this.datasourceProfileNameToProfileMap_;
            synchronized (hashMap) {
                this.datasourceProfileNameToProfileMap_.clear();
            }
            hashMap = this.timeOfDriverIdReferenceMap_;
            synchronized (hashMap) {
                this.timeOfDriverIdReferenceMap_.clear();
            }
            hashMap = this.timeOfDataSourceIdReferenceMap_;
            synchronized (hashMap) {
                this.timeOfDataSourceIdReferenceMap_.clear();
            }
            hashMap = this.profileNameToRegisteredDriverIds_;
            synchronized (hashMap) {
                this.profileNameToRegisteredDriverIds_.clear();
            }
            hashMap = this.profileNameToRegisteredDataSourceIds_;
            synchronized (hashMap) {
                this.profileNameToRegisteredDataSourceIds_.clear();
            }
            hashMap = this.logicalDatabaseNameToRegisteredDataSourceIds_;
            synchronized (hashMap) {
                this.logicalDatabaseNameToRegisteredDataSourceIds_.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNewProfileForDataSourceId(String string, Profile.DataSource dataSource) {
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "registerNewProfileForDataSourceId", "ENTRY " + Arrays.deepToString(new Object[]{string, dataSource}));
            }
            this.removeDataSourceIdFromProfileDataSourceIds(string);
            this.removeDataSourceIdFromLogicalDatabaseDataSourceIds(string);
            if (dataSource != null) {
                this.registerNewDataSourceIdForProfileName(dataSource.getName(), string);
                if (dataSource.getTargetDatabase() != null) {
                    this.registerNewDataSourceIdForLogicalDatabaseName(dataSource.getTargetDatabase().getLogicalName(), string);
                }
            }
            HashMap<String, Profile.DataSource> hashMap = this.datasourceIdToProfileMap_;
            synchronized (hashMap) {
                this.datasourceIdToProfileMap_.put(string, dataSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNewDataSourceIdForLogicalDatabaseName(String string, String string2) {
        HashMap<String, Set<String>> hashMap = this.logicalDatabaseNameToRegisteredDataSourceIds_;
        synchronized (hashMap) {
            Set<String> set = this.logicalDatabaseNameToRegisteredDataSourceIds_.get(string);
            if (set == null) {
                set = new HashSet<String>();
                this.logicalDatabaseNameToRegisteredDataSourceIds_.put(string, set);
            }
            set.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNewDataSourceIdForProfileName(String string, String string2) {
        HashMap<String, Set<String>> hashMap = this.profileNameToRegisteredDataSourceIds_;
        synchronized (hashMap) {
            Set<String> set = this.profileNameToRegisteredDataSourceIds_.get(string);
            if (set == null) {
                set = new HashSet<String>();
                this.profileNameToRegisteredDataSourceIds_.put(string, set);
            }
            set.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterProfileForDataSourceId(String string) {
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "deregisterProfileForDataSourceId", "ENTRY " + Arrays.deepToString(new Object[]{string}));
            }
            this.removeDataSourceIdFromProfileDataSourceIds(string);
            this.removeDataSourceIdFromLogicalDatabaseDataSourceIds(string);
            HashMap<String, Profile.DataSource> hashMap = this.datasourceIdToProfileMap_;
            synchronized (hashMap) {
                this.datasourceIdToProfileMap_.put(string, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDataSourceIdFromLogicalDatabaseDataSourceIds(String string) {
        HashMap<String, Profile.DataSource> hashMap = this.datasourceIdToProfileMap_;
        synchronized (hashMap) {
            Profile.DataSource dataSource = this.datasourceIdToProfileMap_.get(string);
            if (dataSource != null && dataSource.getTargetDatabase() != null) {
                HashMap<String, Set<String>> hashMap2 = this.logicalDatabaseNameToRegisteredDataSourceIds_;
                synchronized (hashMap2) {
                    Set<String> set = this.logicalDatabaseNameToRegisteredDataSourceIds_.get(dataSource.getTargetDatabase().getLogicalName());
                    if (set != null) {
                        set.remove(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDataSourceIdFromProfileDataSourceIds(String string) {
        HashMap<String, Profile.DataSource> hashMap = this.datasourceIdToProfileMap_;
        synchronized (hashMap) {
            Profile.DataSource dataSource = this.datasourceIdToProfileMap_.get(string);
            if (dataSource != null) {
                HashMap<String, Set<String>> hashMap2 = this.profileNameToRegisteredDataSourceIds_;
                synchronized (hashMap2) {
                    Set<String> set = this.profileNameToRegisteredDataSourceIds_.get(dataSource.getName());
                    if (set != null) {
                        set.remove(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNewProfileForDriverId(String string, Profile.Driver driver) {
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "registerNewProfileForDriverId", "ENTRY " + Arrays.deepToString(new Object[]{string, driver}));
            }
            this.removeDriverIdFromProfileDriverIds(string);
            if (driver != null) {
                this.registerNewDriverIdForProfileName(driver.getName(), string);
            }
            HashMap<String, Profile.Driver> hashMap = this.driverIdToProfileMap_;
            synchronized (hashMap) {
                this.driverIdToProfileMap_.put(string, driver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNewDriverIdForProfileName(String string, String string2) {
        HashMap<String, Set<String>> hashMap = this.profileNameToRegisteredDriverIds_;
        synchronized (hashMap) {
            Set<String> set = this.profileNameToRegisteredDriverIds_.get(string);
            if (set == null) {
                set = new HashSet<String>();
                this.profileNameToRegisteredDriverIds_.put(string, set);
            }
            set.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterProfileForDriverId(String string) {
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "deregisterProfileForDriverId", "ENTRY " + Arrays.deepToString(new Object[]{string}));
            }
            this.removeDriverIdFromProfileDriverIds(string);
            HashMap<String, Profile.Driver> hashMap = this.driverIdToProfileMap_;
            synchronized (hashMap) {
                this.driverIdToProfileMap_.put(string, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDriverIdFromProfileDriverIds(String string) {
        HashMap<String, Profile.Driver> hashMap = this.driverIdToProfileMap_;
        synchronized (hashMap) {
            Profile.Driver driver = this.driverIdToProfileMap_.get(string);
            if (driver != null) {
                HashMap<String, Set<String>> hashMap2 = this.profileNameToRegisteredDriverIds_;
                synchronized (hashMap2) {
                    Set<String> set = this.profileNameToRegisteredDriverIds_.get(driver.getName());
                    if (set != null) {
                        set.remove(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDriverProfile(String string, Profile.Driver driver) throws CMXException {
        Profile.Driver driver2 = null;
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "updateDriverProfile", "ENTRY " + Arrays.deepToString(new Object[]{string, driver}));
            }
            HashMap<String, Profile.Driver> hashMap = this.driverProfileNameToProfileMap_;
            synchronized (hashMap) {
                driver2 = this.driverProfileNameToProfileMap_.get(string);
            }
            if (driver2 != null) {
                if (string == null && driver2.getName() != null || string != null && driver2.getName() == null || !string.equals(driver2.getName())) {
                    throw new CMXException(2);
                }
                driver2.updateToNewVersion(driver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDataSourceProfile(String string, Profile.DataSource dataSource) throws CMXException {
        Profile.DataSource dataSource2 = null;
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "updateDataSourceProfile", "ENTRY " + Arrays.deepToString(new Object[]{string, dataSource}));
            }
            HashMap<String, Profile.DataSource> hashMap = this.datasourceProfileNameToProfileMap_;
            synchronized (hashMap) {
                dataSource2 = this.datasourceProfileNameToProfileMap_.get(string);
            }
            if (dataSource2 != null) {
                if (string == null && dataSource2.getName() != null || string != null && dataSource2.getName() == null || !string.equals(dataSource2.getName())) {
                    throw new CMXException(2);
                }
                dataSource2.updateToNewVersion(dataSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDatabase(String string, Database database) throws CMXException {
        Database database2 = null;
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "updateDatabase", "ENTRY " + Arrays.deepToString(new Object[]{string, database}));
            }
            HashMap<String, Database> hashMap = this.databaseMap_;
            synchronized (hashMap) {
                database2 = this.databaseMap_.get(string);
            }
            if (database2 != null) {
                if (string == null && database2.getLogicalName() != null || string != null && database2.getLogicalName() == null || !string.equals(database2.getLogicalName())) {
                    throw new CMXException(2);
                }
                database2.updateToNewVersion(database);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDriverProfile(String string) {
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "deleteDriverProfile", "ENTRY " + Arrays.deepToString(new Object[]{string}));
            }
            HashMap<String, Object> hashMap = this.driverProfileNameToProfileMap_;
            synchronized (hashMap) {
                this.driverProfileNameToProfileMap_.remove(string);
            }
            hashMap = this.profileNameToRegisteredDriverIds_;
            synchronized (hashMap) {
                Set<String> set = this.profileNameToRegisteredDriverIds_.get(string);
                if (set != null) {
                    HashSet<String> hashSet = new HashSet<String>(set);
                    for (String string2 : hashSet) {
                        this.registerNewProfileForDriverId(string2, null);
                    }
                }
                this.profileNameToRegisteredDriverIds_.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataSourceProfile(String string) {
        Registry registry = this;
        synchronized (registry) {
            Serializable serializable;
            Object object;
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "deleteDataSourceProfile", "ENTRY " + Arrays.deepToString(new Object[]{string}));
            }
            String string2 = null;
            HashMap<String, Object> hashMap = this.datasourceProfileNameToProfileMap_;
            synchronized (hashMap) {
                object = this.datasourceProfileNameToProfileMap_.get(string);
                if (object != null && (serializable = ((Profile.DataSource)object).getTargetDatabase()) != null) {
                    string2 = ((Database)serializable).getLogicalName();
                }
                this.datasourceProfileNameToProfileMap_.remove(string);
            }
            hashMap = this.profileNameToRegisteredDataSourceIds_;
            synchronized (hashMap) {
                object = this.profileNameToRegisteredDataSourceIds_.get(string);
                if (object != null) {
                    serializable = new HashSet(object);
                    Iterator iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        if (string2 != null) {
                            this.removeDataSourceIdFromLogicalDatabaseDataSourceIds(string2, string3);
                        }
                        this.registerNewProfileForDataSourceId(string3, null);
                    }
                }
                this.profileNameToRegisteredDataSourceIds_.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDataSourceIdFromLogicalDatabaseDataSourceIds(String string, String string2) {
        HashMap<String, Set<String>> hashMap = this.logicalDatabaseNameToRegisteredDataSourceIds_;
        synchronized (hashMap) {
            Set<String> set = this.logicalDatabaseNameToRegisteredDataSourceIds_.get(string);
            if (set != null) {
                set.remove(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDatabase(String string) {
        Registry registry = this;
        synchronized (registry) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "deleteDatabase", "ENTRY " + Arrays.deepToString(new Object[]{string}));
            }
            HashMap<String, Object> hashMap = this.databaseMap_;
            synchronized (hashMap) {
                this.databaseMap_.remove(string);
            }
            hashMap = this.logicalDatabaseNameToRegisteredDataSourceIds_;
            synchronized (hashMap) {
                Set<String> set = this.logicalDatabaseNameToRegisteredDataSourceIds_.get(string);
                if (set != null) {
                    HashSet<String> hashSet = new HashSet<String>(set);
                    for (String string2 : hashSet) {
                        this.registerNewProfileForDataSourceId(string2, null);
                    }
                }
                this.logicalDatabaseNameToRegisteredDataSourceIds_.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveDriversUsingProfile(String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "getActiveDriversUsingProfile", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        HashMap<String, Set<String>> hashMap = this.profileNameToRegisteredDriverIds_;
        synchronized (hashMap) {
            Set<String> set = this.profileNameToRegisteredDriverIds_.get(string);
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.exit(logger__, this, "getActiveDriversUsingProfile", set);
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveDataSourcesUsingProfile(String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "getActiveDataSourcesUsingProfile", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        HashMap<String, Set<String>> hashMap = this.profileNameToRegisteredDataSourceIds_;
        synchronized (hashMap) {
            Set<String> set = this.profileNameToRegisteredDataSourceIds_.get(string);
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.exit(logger__, this, "getActiveDataSourcesUsingProfile", set);
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveDataSourcesUsingDatabase(String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "getActiveDataSourcesUsingDatabase", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        HashMap<String, Set<String>> hashMap = this.logicalDatabaseNameToRegisteredDataSourceIds_;
        synchronized (hashMap) {
            Set<String> set = this.logicalDatabaseNameToRegisteredDataSourceIds_.get(string);
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.exit(logger__, this, "getActiveDataSourcesUsingDatabase", set);
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriverDescriptor getDriverDescriptor(String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "getDriverDescriptor", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        HashMap<String, DriverDescriptor> hashMap = this.driverIdToDescriptorMap_;
        synchronized (hashMap) {
            DriverDescriptor driverDescriptor = this.driverIdToDescriptorMap_.get(string);
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.exit(logger__, this, "getDriverDescriptor", driverDescriptor);
            }
            return driverDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSourceDescriptor getDataSourceDescriptor(String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "getDataSourceDescriptor", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        HashMap<String, DataSourceDescriptor> hashMap = this.datasourceIdToDescriptorMap_;
        synchronized (hashMap) {
            DataSourceDescriptor dataSourceDescriptor = this.datasourceIdToDescriptorMap_.get(string);
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.exit(logger__, this, "getDataSourceDescriptor", dataSourceDescriptor);
            }
            return dataSourceDescriptor;
        }
    }

    @Override
    public void registerMonitoredLogicalDataSource(String string, MonitorSettings monitorSettings) {
        String string2 = null;
        if (string != null) {
            string2 = ControlDataSourcePool.createKey(string);
            this.cacheMonitorSettings(string2, monitorSettings);
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerMonitoredLogicalDataSource", "Registered monitored database for KEY: " + string2);
        }
    }

    @Override
    public void registerMonitoredDatabaseURL_NoResolve(String string, int n2, String string2, MonitorSettings monitorSettings) {
        String string3 = null;
        if (string != null) {
            string3 = ControlDataSourcePool.createKey(string, String.valueOf(n2), string2, null, false);
            this.cacheMonitorSettings(string3, monitorSettings);
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerMonitoredDatabaseURL_NoResolve", "Registered monitored database for KEY: " + string3);
        }
    }

    @Override
    public void registerMonitoredDatabaseURL_Resolve(String string, int n2, String string2, MonitorSettings monitorSettings) {
        String string3 = null;
        if (string != null) {
            string3 = ControlDataSourcePool.createKey(string, String.valueOf(n2), string2, null, true);
            this.cacheMonitorSettings(string3, monitorSettings);
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerMonitoredDatabaseURL_Resolve", "Registered monitored database for KEY: " + string3);
        }
    }

    @Override
    public void registerMonitoredLocation(String string, MonitorSettings monitorSettings) {
        String string2 = null;
        if (string != null) {
            string2 = ControlDataSourcePool.createKey(null, null, null, string, false);
            this.cacheMonitorSettings(string2, monitorSettings);
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerMonitoredLocation", "Registered monitored database for KEY: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONArray lookupInMemoryForEI(String string, int n2) {
        JSONArray jSONArray = null;
        HashMap<String, JSONArray> hashMap = this.registryForEI_;
        synchronized (hashMap) {
            int n3;
            JSONObject jSONObject;
            jSONArray = this.registryForEI_.get(string);
            if (jSONArray != null && n2 >= 4 && (jSONObject = (JSONObject)jSONArray.get(1)) != null && jSONObject.containsKey("deregisterAction") && (n3 = ((Number)jSONObject.get("deregisterAction")).intValue()) == 1) {
                jSONArray = null;
            }
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "lookupInMemory", "performing lookup for KEY: " + string + "returned RESULT: " + jSONArray);
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONArray cacheMonitorSettings(String string, MonitorSettings monitorSettings) {
        JSONArray jSONArray = null;
        if (monitorSettings == null) {
            HashMap<String, JSONArray> hashMap = this.registryForEI_;
            synchronized (hashMap) {
                this.registryForEI_.remove(string);
            }
            return null;
        }
        if (monitorSettings != null) {
            String[] stringArray;
            Object object;
            jSONArray = new JSONArray();
            JSONObject jSONObject = new JSONObject();
            String[] stringArray2 = monitorSettings.getMonitorServerIPs();
            if (stringArray2 != null) {
                object = new StringBuilder();
                for (int i10 = 0; i10 < stringArray2.length; ++i10) {
                    if (i10 > 0) {
                        ((StringBuilder)object).append(";");
                    }
                    ((StringBuilder)object).append(stringArray2[i10]);
                }
                jSONObject.put("monitorServerName", ((StringBuilder)object).toString());
            }
            jSONObject.put("disableOCMDynamicControl", (Object)(monitorSettings.isOCMDynamicControlDisabled() ? 1 : 0));
            jSONObject.put("monitorPort", (Object)monitorSettings.getMonitorServerPort());
            jSONObject.put("monitorEnabled", (Object)(monitorSettings.isMonitorEnabled() ? 1 : 2));
            jSONObject.put("monitorLevel", (Object)monitorSettings.getMonitorLevel());
            jSONObject.put("monitorCollectionInterval", (Object)monitorSettings.getMonitorCollectionInterval());
            jSONObject.put("monitorIdRequired", (Object)false);
            jSONObject.put("dispatchToken", (Object)monitorSettings.getDispatchToken());
            jSONObject.put("disableOCMDynamicControl", (Object)(monitorSettings.isOCMDynamicControlDisabled() ? 1 : 0));
            object = monitorSettings.getSupportedKeyTypes();
            if (object != null && ((Object)object).length > 0) {
                JSONArray jSONArray2 = new JSONArray();
                for (int i11 = 0; i11 < ((Object)object).length; ++i11) {
                    jSONArray2.add((Object)((int)object[i11]));
                }
                jSONObject.put("supportedKeyTypes", jSONArray2);
            }
            if ((stringArray = monitorSettings.getClientInfoMasks()) != null && stringArray.length == 4) {
                if (stringArray[0] != null) {
                    jSONObject.put("clientUserMask", stringArray[0]);
                }
                if (stringArray[1] != null) {
                    jSONObject.put("clientHostnameMask", stringArray[1]);
                }
                if (stringArray[2] != null) {
                    jSONObject.put("applicationNameMask", stringArray[2]);
                }
                if (stringArray[3] != null) {
                    jSONObject.put("clientAccountingInformationMask", stringArray[3]);
                }
            }
            jSONArray.add((Object)null);
            jSONArray.add(jSONObject);
            HashMap<String, JSONArray> hashMap = this.registryForEI_;
            synchronized (hashMap) {
                this.registryForEI_.put(string, jSONArray);
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoredDataCache getMonitoredDataCache() {
        if (this.monitoredDataCache_ == null) {
            return null;
        }
        MonitoredDataCacheImpl monitoredDataCacheImpl = this.monitoredDataCache_;
        synchronized (monitoredDataCacheImpl) {
            MonitoredDataCacheImpl monitoredDataCacheImpl2 = this.monitoredDataCache_;
            this.monitoredDataCache_ = null;
            return monitoredDataCacheImpl2;
        }
    }

    public void cacheMonitoredData(MonitoredData monitoredData) {
        if (this.monitoredDataCache_ == null) {
            this.monitoredDataCache_ = new MonitoredDataCacheImpl();
        }
        this.monitoredDataCache_.add(monitoredData);
    }

    private void initializeCacheReaperTask() {
        if (this.cacheReaperTask_ == null) {
            this.cacheReaperTask_ = new CacheReaperTask();
            this.timer_.schedule((TimerTask)this.cacheReaperTask_, this.cachingIntervalForMonitoredData_ * 1000, (long)(this.cachingIntervalForMonitoredData_ * 1000));
        }
    }

    @Override
    public void setCachingIntervalForMonitoredData(int n2) {
        if (n2 > 0 && n2 != this.cachingIntervalForMonitoredData_) {
            if (this.cachingIntervalForMonitoredData_ > 0 && this.cacheReaperTask_ != null) {
                this.cacheReaperTask_.cancel();
                this.cacheReaperTask_ = null;
            }
            this.cachingIntervalForMonitoredData_ = n2;
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "setCachingIntervalForMonitoredData", "Setting new caching interval for monitored data: " + n2 + " seconds");
            }
            this.initializeCacheReaperTask();
        }
    }

    @Override
    public void setInMemoryCacheLimitForMonitoredData(long l10) {
        this.inMemoryCacheLimitForMonitoredData_ = l10;
    }

    private class CacheReaperTask
    extends TimerTask
    implements Runnable {
        private CacheReaperTask() {
        }

        @Override
        public void run() {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.enter(logger__, this, "run");
            }
            if (Registry.this.monitoredDataCache_ == null) {
                return;
            }
            Registry.this.monitoredDataCache_.reap(Registry.this.inMemoryCacheLimitForMonitoredData_);
        }
    }
}

