/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.FileLoader;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.DB2StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.BindLexer;
import com.ibm.db2.cmx.tools.internal.binder.BindMetaDataInfo;
import com.ibm.db2.cmx.tools.internal.binder.BindUtils;
import com.ibm.db2.cmx.tools.internal.binder.SRInfoAboutStatementSet;
import com.ibm.db2.cmx.tools.internal.binder.StaticBinderImpl;
import com.ibm.db2.cmx.tools.internal.binder.parser.ISQLParser;
import com.ibm.db2.cmx.tools.internal.binder.parser.SQLParserFactory;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.jcc.DB2Connection;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProfilerBinderHelper {
    private static final String SELECT_END_CLAUSES = "((((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((READ)|(FETCH))((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+OPTIMIZE((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ROWS?)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+WITH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((CS)|(UR)|(RR)|(RS)))|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+QUERYNO((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+SKIP((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+LOCKED((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+DATA)).*";
    private static final Pattern regExPatternSelectEndClauses = Pattern.compile("((((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((READ)|(FETCH))((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+OPTIMIZE((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ROWS?)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+WITH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((CS)|(UR)|(RR)|(RS)))|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+QUERYNO((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+SKIP((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+LOCKED((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+DATA)).*", 98);
    private NodeList statementSetList_ = null;
    private String pureQueryXmlFilePath_ = null;
    private XmlFileHelper xmlHelper_;
    private ArrayList<Integer> bindablePkgIndex_ = new ArrayList();
    private ArrayList<String> originalSqlStmtList_;
    private ArrayList<String> bindStatementsIncludesReservedSections_;
    private ArrayList<Integer> bindSectionNum_;
    private ArrayList<SQLJColumnMetaData> hostVariableInfo_;
    private DB2Connection bindConn_;
    private String storedBindOptions_;
    private boolean prepareOptionReadOnly_;
    private ArrayList<String> sqlId_;
    private CentralStoreKey xmlKey_;
    private ISQLParser sqlParser_;
    private BindMetaDataInfo bindMetaDataInfo_;

    public void saveData() throws Exception {
        if (this.xmlHelper_ != null) {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.pureQueryXmlFilePath_), "UTF-8"));
            this.xmlHelper_.printToFile(this.xmlHelper_.getXmlDocument(), this.xmlKey_, bufferedWriter);
        }
    }

    public boolean loadData(ArtifactOptionsSet artifactOptionsSet, BindMetaDataInfo bindMetaDataInfo) {
        this.pureQueryXmlFilePath_ = artifactOptionsSet.getArtifactName();
        try {
            Object object;
            this.xmlHelper_ = new XmlFileHelper(null);
            this.xmlKey_ = new CentralStoreKey(this.pureQueryXmlFilePath_, null, false, null);
            if (this.xmlKey_ == null || !this.xmlKey_.isInputXmlExists()) {
                try {
                    object = null;
                    object = DataProperties.runningUnderSecurityManager_ ? AccessController.doPrivileged(ProfilerBinderHelper.getResourceAsInputStreamUseBinderClassLoaderPriv(this.pureQueryXmlFilePath_)) : ProfilerBinderHelper.getResourceAsInputStreamUseBinderClassLoader(this.pureQueryXmlFilePath_);
                    this.xmlKey_.setTempInputStreamHold((InputStream)object);
                }
                catch (Exception exception) {
                    throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_CAPTURE_FILE_NOT_FOUND", this.xmlKey_), null, exception, 10505);
                }
            }
            this.xmlHelper_.initRootElementForXmlDocument(this.xmlKey_);
            bindMetaDataInfo.userCaresAboutSpecialRegistersInThisFile_ = this.xmlHelper_.userCaresAboutSpecialRegistersInThisFile(false);
            object = this.xmlHelper_.getRootElement();
            if (null == object) {
                bindMetaDataInfo.setUtilityResultType(PureQueryUtility.UtilityResultType.FAILURE, Messages.getText("ERR_PUREQUERYXML_INVALID_NAME", this.pureQueryXmlFilePath_));
            } else {
                Configuration.checkCompatibilityOfXmlForClientOptmizer((Element)object);
                if (object.getElementsByTagName("baseIncrements").getLength() != 0) {
                    bindMetaDataInfo.setUtilityResultType(PureQueryUtility.UtilityResultType.FAILURE, Messages.getText("ERR_BASEINCREMENT_ELEMENT_PRESENT", this.pureQueryXmlFilePath_, "baseIncrements"));
                } else if (this.xmlHelper_.checkIfAnyStatementSetNeedsToBeConfigured()) {
                    bindMetaDataInfo.setUtilityResultType(PureQueryUtility.UtilityResultType.FAILURE, Messages.getText("ERR_BINDER_PUREQUERYXML_NEEDS_TO_BE_CONFIGURED", this.pureQueryXmlFilePath_));
                } else {
                    String string = artifactOptionsSet.getArtifactStatementSet();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    this.statementSetList_ = object.getElementsByTagName("statementSet");
                    if (this.statementSetList_ != null) {
                        Element element = null;
                        Element element2 = null;
                        int n2 = this.statementSetList_.getLength();
                        bindMetaDataInfo.setNumStatementSets(n2);
                        for (int i10 = 0; i10 < n2; ++i10) {
                            element = (Element)((Element)this.statementSetList_.item(i10)).getElementsByTagName("package").item(0);
                            element2 = (Element)((Element)this.statementSetList_.item(i10)).getElementsByTagName("statements").item(0);
                            String string2 = element.getAttribute("name");
                            if (null != string && !string.equals(string2)) continue;
                            bindMetaDataInfo.foundRequestedBasePackageName(null != string);
                            bl2 = true;
                            if (XmlFileHelper.isBindable(element)) {
                                bl3 = true;
                                Element element3 = null;
                                String string3 = null;
                                int n3 = 0;
                                NodeList nodeList = element2.getElementsByTagName("statement");
                                int n4 = 0;
                                if (nodeList != null) {
                                    n4 = nodeList.getLength();
                                }
                                for (int i11 = 0; i11 < n4; ++i11) {
                                    element3 = (Element)nodeList.item(i11);
                                    string3 = ((Element)element3.getElementsByTagName("statementAttributes").item(0)).getAttribute("isBindable");
                                    if (!string3.equalsIgnoreCase("true")) continue;
                                    ++n3;
                                    break;
                                }
                                if (n3 > 0) {
                                    this.bindablePkgIndex_.add(i10);
                                    continue;
                                }
                                bindMetaDataInfo.addBindableStatementSetWithNoBindableStatements(string2);
                                continue;
                            }
                            bindMetaDataInfo.addBindableFalseStatementSet(string2);
                        }
                    }
                    StaticBinderImpl.addErrorsAndWarningsFromBind(bindMetaDataInfo, this.pureQueryXmlFilePath_, string, bl3, bl2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_IO_XML", this.pureQueryXmlFilePath_), sQLException, 10491);
        }
        return PureQueryUtility.UtilityResultType.FAILURE != bindMetaDataInfo.getUtilityResult().utilityResultType;
    }

    protected void loadDataForNextPackage(BindMetaDataInfo bindMetaDataInfo, int n2) throws SQLException {
        Element element = (Element)this.statementSetList_.item(n2);
        Element element2 = (Element)element.getElementsByTagName("package").item(0);
        String string = element2.getAttribute("collection");
        String string2 = element2.getAttribute("name");
        bindMetaDataInfo.addBindableStatementSetWithBindableStatements(string2);
        String string3 = element2.getAttribute("version");
        String string4 = element2.getAttribute("consistencyToken");
        String string5 = element2.getAttribute("isDDLPackage");
        this.storedBindOptions_ = element2.getAttribute("bindOptions");
        NodeList nodeList = element.getElementsByTagName("statement");
        String string6 = element2.getAttribute("forceSingleBindIsolation");
        try {
            bindMetaDataInfo.programSetVersion_ = this.xmlHelper_.getPureQueryXmlVersion();
        }
        catch (Exception exception) {
            ToolsLogger.getLogger().log(Level.FINE, "Error getting programSet version: " + exception.getMessage());
        }
        if (nodeList != null && nodeList.getLength() > 0) {
            this.populateData(bindMetaDataInfo, element);
            bindMetaDataInfo.setCollectionNameFromPdqxmlOrImpl(string);
            bindMetaDataInfo.setRootPkgName(string2);
            bindMetaDataInfo.setForceSingleBindIsolation(Boolean.valueOf(string6));
            bindMetaDataInfo.validateCollectionAndPackageNameLength(string, string2);
            bindMetaDataInfo.setBindStatementsIncludesReservedSections(this.bindStatementsIncludesReservedSections_.toArray(new String[this.bindStatementsIncludesReservedSections_.size()]));
            bindMetaDataInfo.setPkgVersion(string3);
            bindMetaDataInfo.setIsDDLPackage(Boolean.valueOf(string5));
            if (bindMetaDataInfo.userCaresAboutSpecialRegistersInThisFile_) {
                bindMetaDataInfo.setSRInfoAboutStatementSet(SRInfoAboutStatementSet.getNewSRInfoAboutStatementSet(element, element2, this.pureQueryXmlFilePath_, this.xmlHelper_));
            }
            int[] nArray = new int[this.bindSectionNum_.size()];
            for (int i10 = 0; i10 < nArray.length; ++i10) {
                nArray[i10] = this.bindSectionNum_.get(i10);
            }
            bindMetaDataInfo.setSectionNumber(nArray);
            bindMetaDataInfo.setHostVariableInfo(this.hostVariableInfo_.toArray(new SQLJColumnMetaData[this.hostVariableInfo_.size()]));
            bindMetaDataInfo.setConsistencyToken(XmlFileHelper.getConsistencyTokenAsByteArray(string4));
            if (this.storedBindOptions_ != null && this.storedBindOptions_.length() > 0) {
                bindMetaDataInfo.setBindOptionsStringFromPureQueryXml(this.storedBindOptions_);
            }
            bindMetaDataInfo.setOriginalSQLStmtArray_(this.originalSqlStmtList_.toArray(new String[this.originalSqlStmtList_.size()]));
            bindMetaDataInfo.setSqlIdArray(this.sqlId_.toArray(new String[this.sqlId_.size()]));
        }
    }

    public ArrayList<Integer> getBindablePkgList() {
        return this.bindablePkgIndex_;
    }

    private String getBindableSQL(Element element) {
        String string = null;
        String string2 = element.getElementsByTagName("prepareSql").item(0).getTextContent();
        NodeList nodeList = element.getElementsByTagName("processedSql");
        if (nodeList != null && nodeList.getLength() > 0 && !nodeList.item(0).getTextContent().trim().equals("")) {
            string = nodeList.item(0).getTextContent();
        }
        this.originalSqlStmtList_.add(string2);
        if (string != null) {
            return EscapeLexer.filterComments(string, true);
        }
        return EscapeLexer.filterComments(string2, true);
    }

    private SqlStatementType getStatementType(Element element) {
        return XmlTags.getStatementTypeFromXmlTag(element.getElementsByTagName("statementType").item(0).getTextContent());
    }

    private boolean isBindableStmt(Element element) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        String string = element2.getAttribute("isBindable");
        return string.equalsIgnoreCase("true");
    }

    private boolean isValidStmt(Element element) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        String string = element2.getAttribute("isValid");
        return !string.equalsIgnoreCase("false");
    }

    public static void setValidStmt(Element element, boolean bl2) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        element2.setAttribute("isValid", String.valueOf(bl2));
    }

    public static void setBindableStmt(Element element, boolean bl2) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        element2.setAttribute("isBindable", String.valueOf(bl2));
    }

    private Integer getSectionNumber(Element element) {
        int n2 = Integer.parseInt(element.getAttribute("sectionNumber"));
        return n2;
    }

    private int getReservedSectionCount(Element element, SqlStatementType sqlStatementType, boolean bl2, String string) {
        Integer n2 = XmlFileHelper.getAttributeValueInteger(element, "numReservedSections", false, null);
        if (null == n2) {
            n2 = bl2 && SqlStatementType.INSERT == sqlStatementType && 1 == this.xmlHelper_.getPureQueryXmlVersion() && StaticProfileConstants.isCandidateForStaticMRI_configureTimeCheck(string, StaticProfileConstants.isAutoGeneratedKeysJDBCMethodUsed(element)) ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        return n2;
    }

    private String getSqlID(Element element) {
        return element.getAttribute("id");
    }

    private String getValuefromStatementAttributes(Element element, String string) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        if (element2.hasAttribute(string)) {
            return element2.getAttribute(string);
        }
        return null;
    }

    private void setValueInStatementAttributes(Element element, String string, String string2) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        element2.setAttribute(string, string2);
    }

    private void populateData(BindMetaDataInfo bindMetaDataInfo, Element element) throws SQLException {
        Object object;
        int n2;
        Object object2;
        Object object3;
        int n3;
        boolean bl2;
        this.bindMetaDataInfo_ = bindMetaDataInfo;
        if (this.sqlParser_ != null) {
            this.sqlParser_.resetParser();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = 0;
        boolean[] blArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        long[] lArray = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        String[] stringArray = null;
        short[] sArray = null;
        SQLJColumnMetaData sQLJColumnMetaData = null;
        String string = null;
        NodeList nodeList = element.getElementsByTagName("statement");
        NodeList nodeList2 = element.getElementsByTagName("package");
        Element element2 = null != nodeList2 && 0 < nodeList2.getLength() ? (Element)nodeList2.item(0) : null;
        String string2 = null != element2 ? element2.getAttribute("name") : null;
        StaticProfileConstants.DBInfo dBInfo = this.bindMetaDataInfo_.getDBInfo();
        boolean bl3 = bl2 = StaticProfileConstants.DatabaseType.DB2forZOS == dBInfo.databaseType_;
        if (nodeList != null) {
            n3 = nodeList.getLength();
            this.bindMetaDataInfo_.setNumInputStatements(n3);
            this.bindMetaDataInfo_.setNumDDLStatements(0);
            for (int i10 = 0; i10 < n3; ++i10) {
                Element element3 = (Element)nodeList.item(i10);
                if (this.isBindableStmt(element3) && this.isValidStmt(element3)) {
                    String string3 = element3.hasAttribute("id") ? element3.getAttribute("id") : null;
                    object3 = this.getStatementType(element3);
                    boolean bl4 = StaticProfileConstants.areAutoGeneratedKeysRequested(element3);
                    object2 = XmlFileHelper.getProcessedSql(element3);
                    n2 = null != object2 && StaticProfileConstants.isValueSet((String)object2) ? 1 : 0;
                    String string4 = XmlFileHelper.getElementTextValue(element3, "prepareSql", null);
                    object = StaticProfileConstants.canSQLExecuteStatically(this.bindMetaDataInfo_.getDBInfo(), string2, string3, (SqlStatementType)((Object)object3), bl4, n2 != 0, string4);
                    if (null == object) {
                        arrayList.add(i10);
                    } else {
                        this.bindMetaDataInfo_.addBindableTrueStatementsNotBound((String)object);
                    }
                } else {
                    this.bindMetaDataInfo_.incrementNumBindableFalseStatements();
                }
                if (!this.isDDLStmt((Element)nodeList.item(i10))) continue;
                this.bindMetaDataInfo_.incrementNumDDLStatements();
            }
        }
        this.bindMetaDataInfo_.setNumberOfBindableTrueStatementsToBind(arrayList.size());
        if (!arrayList.isEmpty()) {
            n3 = 0;
            this.initialize();
            Iterator iterator = arrayList.iterator();
            int n5 = 0;
            int n6 = 0;
            object3 = new BindUtils();
            ArrayList<Element> arrayList2 = new ArrayList<Element>();
            while (iterator.hasNext()) {
                Element element4;
                int n7;
                Element element5;
                NodeList nodeList3;
                n5 = (Integer)iterator.next();
                object2 = (Element)nodeList.item(n5);
                arrayList2.add((Element)object2);
                string = this.getBindableSQL((Element)object2);
                string = BindLexer.removeFinalSemicolon(this.bindConn_.nativeSQL(string));
                this.bindSectionNum_.add(this.getSectionNumber((Element)object2));
                this.sqlId_.add(this.getSqlID((Element)object2));
                n4 = 0;
                n2 = 0;
                int n8 = XmlTags.getConcurrencyNumber(this.getValuefromStatementAttributes((Element)object2, "resultSetConcurrency"));
                if ("SINGLE_ROW_RESULT".equals(this.getValuefromStatementAttributes((Element)object2, "rowType")) && n8 == 1008) {
                    object = object2.getAttribute("id");
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_STMT_ATTR_MISMATCH", object), null, 10898);
                }
                NodeList nodeList4 = object2.getElementsByTagName("parameterMetadata");
                if (nodeList4 != null && nodeList4.getLength() > 0 && (nodeList3 = (element5 = (Element)nodeList4.item(0)).getElementsByTagName("parameter")) != null) {
                    n4 = nodeList3.getLength();
                    blArray = new boolean[n4];
                    nArray = new int[n4];
                    nArray2 = new int[n4];
                    lArray = new long[n4];
                    nArray3 = new int[n4];
                    nArray4 = new int[n4];
                    stringArray = new String[n4];
                    sArray = new short[n4];
                }
                if (SqlStatementType.QUERY == (object = this.getStatementType((Element)object2)) && !"SINGLE_ROW_RESULT".equals(this.getValuefromStatementAttributes((Element)object2, "rowType")) && n8 != 1008 && this.bindMetaDataInfo_.isDetectSingleton() && this.canOptimizeSingletonSelect((Element)object2, string, dBInfo)) {
                    this.bindMetaDataInfo_.setModifiedDom(true);
                }
                if (SqlStatementType.QUERY == object && "SINGLE_ROW_RESULT".equals(this.getValuefromStatementAttributes((Element)object2, "rowType")) && n8 != 1008 && (nodeList4 = object2.getElementsByTagName("resultSetMetadata")) != null && nodeList4.getLength() > 0 && (nodeList3 = (element5 = (Element)nodeList4.item(0)).getElementsByTagName("column")) != null && nodeList3.getLength() > 0) {
                    n2 = nodeList3.getLength();
                    blArray = new boolean[n4 += n2];
                    nArray = new int[n4];
                    nArray2 = new int[n4];
                    lArray = new long[n4];
                    nArray3 = new int[n4];
                    nArray4 = new int[n4];
                    stringArray = new String[n4];
                    sArray = new short[n4];
                    for (n7 = 0; n7 < n2; ++n7) {
                        element4 = (Element)nodeList3.item(n7);
                        blArray[n7] = element4.hasAttribute("nullable") ? Boolean.valueOf(element4.getAttribute("nullable")) : true;
                        if (element4.hasAttribute("precision")) {
                            nArray[n7] = Integer.valueOf(element4.getAttribute("precision"));
                        }
                        if (element4.hasAttribute("scale")) {
                            nArray2[n7] = Integer.valueOf(element4.getAttribute("scale"));
                        }
                        if (element4.hasAttribute("length")) {
                            lArray[n7] = Integer.valueOf(element4.getAttribute("length")).intValue();
                        }
                        if (element4.hasAttribute("db2type")) {
                            nArray3[n7] = Integer.valueOf(element4.getAttribute("db2type"));
                        }
                        if (element4.hasAttribute("ccsid")) {
                            nArray4[n7] = Integer.valueOf(element4.getAttribute("ccsid"));
                        }
                        if (element4.hasAttribute("columnName")) {
                            stringArray[n7] = element4.getAttribute("columnName");
                        }
                        if (!element4.hasAttribute("maxStringUnitBits")) continue;
                        sArray[n7] = Short.valueOf(element4.getAttribute("maxStringUnitBits"));
                    }
                }
                if ((nodeList4 = object2.getElementsByTagName("parameterMetadata")) != null && nodeList4.getLength() > 0 && (nodeList3 = (element5 = (Element)nodeList4.item(0)).getElementsByTagName("parameter")) != null && nodeList3.getLength() > 0) {
                    n7 = 0;
                    int n9 = n2;
                    while (n9 < n4) {
                        element4 = (Element)nodeList3.item(n7);
                        blArray[n9] = element4.hasAttribute("nullable") ? Boolean.valueOf(element4.getAttribute("nullable")) : true;
                        if (element4.hasAttribute("precision")) {
                            nArray[n9] = Integer.valueOf(element4.getAttribute("precision"));
                        }
                        if (element4.hasAttribute("scale")) {
                            nArray2[n9] = Integer.valueOf(element4.getAttribute("scale"));
                        }
                        if (element4.hasAttribute("length")) {
                            lArray[n9] = Integer.valueOf(element4.getAttribute("length")).intValue();
                        }
                        if (element4.hasAttribute("db2type")) {
                            nArray3[n9] = Integer.valueOf(element4.getAttribute("db2type"));
                        }
                        if (bl2 && object == SqlStatementType.CALL) {
                            lArray[n9] = StaticProfileCaptureHelper.correctDateTimeLength(nArray3[n9], lArray[n9]);
                        }
                        if (element4.hasAttribute("ccsid")) {
                            nArray4[n9] = Integer.valueOf(element4.getAttribute("ccsid"));
                        }
                        if (element4.hasAttribute("columnName")) {
                            stringArray[n9] = element4.getAttribute("columnName");
                        }
                        if (element4.hasAttribute("maxStringUnitBits")) {
                            sArray[n9] = Short.valueOf(element4.getAttribute("maxStringUnitBits"));
                        }
                        ++n9;
                        ++n7;
                    }
                }
                if (n4 > 0) {
                    sQLJColumnMetaData = new SQLJColumnMetaData(n4, blArray, nArray, nArray2, lArray, nArray3, nArray4, stringArray);
                    if (DB2StaticProfileCaptureHelper.maxStringUnitsPresent_) {
                        sQLJColumnMetaData.maxStringUnitBits = sArray;
                    }
                    n3 = sQLJColumnMetaData.columns * 2;
                }
                this.processHostVariables(sQLJColumnMetaData, n3);
                sQLJColumnMetaData = null;
                n3 = 0;
                if (SqlStatementType.QUERY == object || StaticProfileConstants.userSQLIsNestedInASELECTForAGKs((Element)object2)) {
                    this.buildCursorEntry(this.bindMetaDataInfo_, (Element)object2, (BindUtils)object3, string, (SqlStatementType)((Object)object));
                } else {
                    this.buildNonCursorEntry(this.bindMetaDataInfo_, (Element)object2, (BindUtils)object3, string, (SqlStatementType)((Object)object));
                }
                this.bindSectionNum_.trimToSize();
                this.bindStatementsIncludesReservedSections_.trimToSize();
                this.hostVariableInfo_.trimToSize();
                ++n6;
            }
            this.bindMetaDataInfo_.setStmtElementList(arrayList2);
        }
        n3 = this.bindSectionNum_.size();
        assert (this.bindStatementsIncludesReservedSections_.size() == n3) : "size of bindStatements_ array differs from that of bindSectionNum_ array";
        assert (this.hostVariableInfo_.size() == n3) : "size of hostVariableInfo_ array differs from that of bindSectionNum_ array";
        assert (this.sqlId_.size() == n3) : "size of sqlId_ array differs from that of bindSectionNum_ array";
        assert (this.originalSqlStmtList_.size() == n3) : "size of originalSqlStmtList_ array differs from that of bindSectionNum_ array";
    }

    private boolean canOptimizeSingletonSelect(Element element, String string, StaticProfileConstants.DBInfo dBInfo) {
        if (!BindLexer.isSingleRowEligible(string)) {
            return false;
        }
        if (BindLexer.outerFetchFirstExists(string)) {
            this.setValueInStatementAttributes(element, "rowType", "SINGLE_ROW_RESULT");
            return true;
        }
        if (this.isStatementWithMaxRowsSetToOne(element)) {
            this.setValueInStatementAttributes(element, "rowType", "SINGLE_ROW_RESULT");
            return true;
        }
        if (this.isSingletonSelectUsingParser(string, dBInfo)) {
            this.setValueInStatementAttributes(element, "rowType", "SINGLE_ROW_RESULT");
            return true;
        }
        return false;
    }

    private boolean isStatementWithMaxRowsSetToOne(Element element) {
        String string = this.getValuefromStatementAttributes(element, "maxRows");
        if (null != string) {
            int n2 = 0;
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (1 == n2) {
                return true;
            }
        }
        return false;
    }

    private boolean isSingletonSelectUsingParser(String string, StaticProfileConstants.DBInfo dBInfo) {
        try {
            if (this.sqlParser_ == null) {
                this.sqlParser_ = SQLParserFactory.createSQLParser();
                this.sqlParser_.initDatabase(this.bindConn_);
            }
            if (!this.sqlParser_.isSqlParserInitialized()) {
                this.sqlParser_.initParser(dBInfo);
                ToolsLogger.getLogger().log(Level.FINE, "Done initializing parser for singleton optimization.");
            }
            String string2 = this.getTableQualifier();
            boolean bl2 = this.sqlParser_.isSingletonSelect(string, string2);
            ToolsLogger.getLogger().log(Level.FINE, "Can optimize " + string + " ? " + bl2);
            return bl2;
        }
        catch (Throwable throwable) {
            System.out.println("Could not optimize single row queries due to an error: " + throwable.getMessage());
            throwable.printStackTrace();
            return false;
        }
    }

    private String getTableQualifier() throws SQLException {
        Object object;
        Matcher matcher;
        String string = this.bindMetaDataInfo_.getQualifierFromBindOptionsString();
        if (string != null && string.length() > 0) {
            return string;
        }
        if (this.storedBindOptions_ != null && (matcher = ((Pattern)(object = Pattern.compile("(?i)QUALIFIER\\(([^\\)]+)\\)"))).matcher(this.storedBindOptions_)).find()) {
            String string2 = matcher.group(1);
            return string2;
        }
        object = this.bindConn_.getMetaData().getUserName();
        return object != null ? ((String)object).toUpperCase() : null;
    }

    private void initialize() {
        this.originalSqlStmtList_ = new ArrayList();
        this.hostVariableInfo_ = new ArrayList();
        this.bindStatementsIncludesReservedSections_ = new ArrayList();
        this.bindSectionNum_ = new ArrayList();
        this.sqlId_ = new ArrayList();
    }

    private void processHostVariables(SQLJColumnMetaData sQLJColumnMetaData, int n2) {
        SQLJColumnMetaData sQLJColumnMetaData2 = new SQLJColumnMetaData(n2);
        int n3 = 0;
        for (int i10 = 0; i10 < n2 / 2; ++i10) {
            n3 = i10 * 2;
            sQLJColumnMetaData2.sqlTypes[n3] = sQLJColumnMetaData.sqlTypes[i10];
            sQLJColumnMetaData2.nullables[n3] = sQLJColumnMetaData.nullables[i10];
            if (sQLJColumnMetaData2.sqlTypes[n3] == 484 || sQLJColumnMetaData2.sqlTypes[n3] == 485) {
                sQLJColumnMetaData2.sqlPrecisions[n3] = sQLJColumnMetaData.sqlPrecisions[i10];
                sQLJColumnMetaData2.sqlScales[n3] = sQLJColumnMetaData.sqlScales[i10];
                sQLJColumnMetaData2.sqlLengths[n3] = 0L;
            } else {
                sQLJColumnMetaData2.sqlPrecisions[n3] = 0;
                sQLJColumnMetaData2.sqlScales[n3] = 0;
                sQLJColumnMetaData2.sqlLengths[n3] = sQLJColumnMetaData.sqlLengths[i10];
            }
            sQLJColumnMetaData2.sqlCcsids[n3] = sQLJColumnMetaData.sqlCcsids[i10];
            sQLJColumnMetaData2.sqlNames[n3] = sQLJColumnMetaData.sqlNames[i10] == null || sQLJColumnMetaData.sqlNames[i10].equals("") ? "p" + i10 : sQLJColumnMetaData.sqlNames[i10];
            sQLJColumnMetaData2.nullables[n3 + 1] = false;
            sQLJColumnMetaData2.sqlLengths[n3 + 1] = 2L;
            sQLJColumnMetaData2.sqlPrecisions[n3 + 1] = 0;
            sQLJColumnMetaData2.sqlScales[n3 + 1] = 0;
            sQLJColumnMetaData2.sqlTypes[n3 + 1] = 501;
            sQLJColumnMetaData2.sqlNames[n3 + 1] = "ind@" + (i10 + 1);
        }
        this.hostVariableInfo_.add(sQLJColumnMetaData2);
    }

    private void buildNonCursorEntry(BindMetaDataInfo bindMetaDataInfo, Element element, BindUtils bindUtils, String string, SqlStatementType sqlStatementType) {
        CharSequence charSequence;
        Object object;
        String string2 = string;
        if (this.hostVariableInfo_.get((int)(this.hostVariableInfo_.size() - 1)).columns > 0) {
            string2 = bindUtils.parseSQLTextForDB2(string2);
            object = " NOT ATOMIC CONTINUE ON SQLEXCEPTION ";
            charSequence = " FOR :H ROWS ";
            String string3 = " ATOMIC ";
            StaticProfileConstants.DBInfo dBInfo = bindMetaDataInfo.getDBInfo();
            String string4 = this.getValuefromStatementAttributes(element, "parameterType");
            if (SqlStatementType.INSERT == sqlStatementType && "MULTI_ROW_PARAMETERS".equals(string4) && dBInfo.supportsMRI_) {
                Matcher matcher;
                String string5;
                int n2;
                this.bindStatementsIncludesReservedSections_.add(string2);
                int n3 = this.getSectionNumber(element);
                int n4 = this.getReservedSectionCount(element, sqlStatementType, dBInfo.supportsMRI_, string4);
                if (n4 == 1) {
                    n2 = n3 + n4;
                    string5 = string2 + (String)charSequence;
                    matcher = StaticProfileConstants.notAtomicCont.matcher(string5);
                    if (!matcher.find()) {
                        string5 = string5 + (String)object;
                    }
                    this.createReservedSection(element, n2, string5, string2, this.hostVariableInfo_.get(this.hostVariableInfo_.size() - 1), false);
                }
                if (n4 == 2) {
                    n2 = n3 + n4 - 1;
                    string5 = string2 + (String)charSequence;
                    matcher = StaticProfileConstants.notAtomicCont.matcher(string5);
                    if (!matcher.find()) {
                        string5 = string5 + (String)object;
                    }
                    this.createReservedSection(element, n2, string5, string2, this.hostVariableInfo_.get(this.hostVariableInfo_.size() - 1), false);
                    int n5 = n3 + n4;
                    String string6 = string2;
                    string6 = string2.trim().toUpperCase().endsWith("ATOMIC") ? string6 + (String)charSequence : string6 + (String)charSequence + string3;
                    this.createReservedSection(element, n5, string6, string2, this.hostVariableInfo_.get(this.hostVariableInfo_.size() - 2), false);
                }
                return;
            }
            if (SqlStatementType.MERGE == sqlStatementType && (null == string4 || "MULTI_ROW_PARAMETERS".equals(string4)) && dBInfo.supportsMRI_) {
                int n6 = this.getSectionNumber(element);
                int n7 = this.getReservedSectionCount(element, sqlStatementType, dBInfo.supportsMRI_, string4);
                if (n7 != 0) {
                    this.bindStatementsIncludesReservedSections_.add(string2);
                }
                int n8 = n6 + n7;
                String string7 = BindLexer.getMergeWithMultiRowClause(string2);
                if (n7 == 0) {
                    this.createReservedSection(element, n8, string7, string2, this.hostVariableInfo_.get(this.hostVariableInfo_.size() - 1), true);
                } else {
                    this.createReservedSection(element, n8, string7, string2, this.hostVariableInfo_.get(this.hostVariableInfo_.size() - 1), false);
                }
                return;
            }
        }
        object = StaticProfileConstants.forRowNOfRowsetPat.matcher(string2);
        charSequence = new StringBuffer();
        if (((Matcher)object).find()) {
            ((Matcher)object).appendReplacement((StringBuffer)charSequence, " ");
            ((Matcher)object).appendTail((StringBuffer)charSequence);
            string2 = ((StringBuffer)charSequence).toString();
            ToolsLogger.getLogger().log(Level.FINER, Messages.getText("MSG_PROFILER_UPDATABLE_ROWSET_NOT_SUPPORTED_NOARGS", new Object[0]));
        }
        this.bindStatementsIncludesReservedSections_.add(string2);
    }

    private void createReservedSection(Element element, int n2, String string, String string2, SQLJColumnMetaData sQLJColumnMetaData, boolean bl2) {
        if (!bl2) {
            this.bindSectionNum_.add(n2);
            this.sqlId_.add(this.getSqlID(element));
            this.originalSqlStmtList_.add(string2);
        }
        this.addHostVariableForMRI(sQLJColumnMetaData, bl2);
        this.bindStatementsIncludesReservedSections_.add(string);
    }

    private void addHostVariableForMRI(SQLJColumnMetaData sQLJColumnMetaData, boolean bl2) {
        SQLJColumnMetaData sQLJColumnMetaData2 = new SQLJColumnMetaData(sQLJColumnMetaData.columns + 1);
        sQLJColumnMetaData2.isDescribed = sQLJColumnMetaData.isDescribed;
        int n2 = 0;
        if (sQLJColumnMetaData.nullables != null) {
            System.arraycopy(sQLJColumnMetaData.nullables, 0, sQLJColumnMetaData2.nullables, n2, sQLJColumnMetaData.nullables.length);
        }
        if (sQLJColumnMetaData.sqlCcsids != null) {
            System.arraycopy(sQLJColumnMetaData.sqlCcsids, 0, sQLJColumnMetaData2.sqlCcsids, n2, sQLJColumnMetaData.sqlCcsids.length);
        }
        if (sQLJColumnMetaData.sqlLabels != null) {
            System.arraycopy(sQLJColumnMetaData.sqlLabels, 0, sQLJColumnMetaData2.sqlLabels, n2, sQLJColumnMetaData.sqlLabels.length);
        }
        if (sQLJColumnMetaData.sqlLengths != null) {
            System.arraycopy(sQLJColumnMetaData.sqlLengths, 0, sQLJColumnMetaData2.sqlLengths, n2, sQLJColumnMetaData.sqlLengths.length);
        }
        if (sQLJColumnMetaData.sqlNames != null) {
            System.arraycopy(sQLJColumnMetaData.sqlNames, 0, sQLJColumnMetaData2.sqlNames, n2, sQLJColumnMetaData.sqlNames.length);
        }
        if (sQLJColumnMetaData.sqlPrecisions != null) {
            System.arraycopy(sQLJColumnMetaData.sqlPrecisions, 0, sQLJColumnMetaData2.sqlPrecisions, n2, sQLJColumnMetaData.sqlPrecisions.length);
        }
        if (sQLJColumnMetaData.sqlScales != null) {
            System.arraycopy(sQLJColumnMetaData.sqlScales, 0, sQLJColumnMetaData2.sqlScales, n2, sQLJColumnMetaData.sqlScales.length);
        }
        if (sQLJColumnMetaData.sqlTypes != null) {
            System.arraycopy(sQLJColumnMetaData.sqlTypes, 0, sQLJColumnMetaData2.sqlTypes, n2, sQLJColumnMetaData.sqlTypes.length);
        }
        int n3 = sQLJColumnMetaData.columns;
        sQLJColumnMetaData2.nullables[n3] = false;
        sQLJColumnMetaData2.sqlLengths[n3] = 4L;
        sQLJColumnMetaData2.sqlPrecisions[n3] = 0;
        sQLJColumnMetaData2.sqlScales[n3] = 0;
        sQLJColumnMetaData2.sqlTypes[n3] = 496;
        sQLJColumnMetaData2.sqlNames[n3] = "numRows";
        if (bl2) {
            this.hostVariableInfo_.set(this.hostVariableInfo_.size() - 1, sQLJColumnMetaData2);
        } else {
            this.hostVariableInfo_.add(sQLJColumnMetaData2);
        }
    }

    private String buildMaxRowsEntry(Element element, String string) {
        String string2 = string;
        String string3 = this.getValuefromStatementAttributes(element, "incrementalMaxRows");
        if (string3 != null) {
            String string4 = element.getAttribute("id");
            WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("ERR_INCR_MAX_ROWS_INFO_FOUND", string4, "maxRows", "incrementalMaxRows", "configureStatus"), 11266, this.getClass(), "buildMaxRowsEntry");
        }
        string2 = string2 + this.getFetchFirstClause(element);
        return string2;
    }

    private String getFetchFirstClause(Element element) {
        String string = "";
        String string2 = this.getValuefromStatementAttributes(element, "maxRows");
        if (string2 != null) {
            int n2 = Integer.parseInt(string2);
            if (n2 == 1) {
                string = " FETCH FIRST 1 ROW ONLY ";
            } else if (n2 > 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" FETCH FIRST ");
                stringBuffer.append(n2);
                stringBuffer.append(" ROWS ONLY ");
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private void buildCursorEntry(BindMetaDataInfo bindMetaDataInfo, Element element, BindUtils bindUtils, String string, SqlStatementType sqlStatementType) {
        Object object;
        CharSequence charSequence;
        int n2;
        Iterable<int[]> iterable;
        String string2;
        int n3 = XmlTags.getConcurrencyNumber(this.getValuefromStatementAttributes(element, "resultSetConcurrency"));
        String string3 = this.getValuefromStatementAttributes(element, "resultSetHoldability");
        String string4 = this.getValuefromStatementAttributes(element, "prepareOptions");
        String string5 = this.getValuefromStatementAttributes(element, "cursorName");
        Boolean bl2 = Boolean.parseBoolean(this.getValuefromStatementAttributes(element, "forceHoldCursor"));
        if (string5 == null || string5.trim().length() == 0) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_NULL_CURSORNAME", string, this.getSqlID(element)), null, 10773);
        }
        boolean bl3 = XmlTags.getValueOfBoolean(this.getValuefromStatementAttributes(element, "allowStaticRowsetCursors"), false);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl4 = StatementUtilities.checkIfShouldUseRowsetCursorInBindAndStaticExecution(bl3, StatementUtilities.doesDatabaseSupportRowsetCursors(bindMetaDataInfo.getDatabaseMetaData()), true);
        if (!string5.startsWith("DB_PDQ_SPC")) {
            string5 = "\"" + string5 + "\"";
        }
        stringBuffer.append("DECLARE " + string5);
        this.appendCursorAttributes(stringBuffer, string4, string3, bl2, bl4);
        if (this.hostVariableInfo_.get((int)(this.hostVariableInfo_.size() - 1)).columns > 0) {
            string = bindUtils.parseSQLTextForDB2(string);
        }
        if (!(BindLexer.regExPatternFetchFirstOne.matcher(string2 = BindLexer.getStrippedStringForFromSearch(string, iterable = BindLexer.getIgnoreRanges(string))).find() || BindLexer.regExPatternFetchFirstOneMissing.matcher(string2).find() || BindLexer.regExPatternFetchFirst.matcher(string2).find())) {
            if (BindLexer.regExPatternOptimizeFor.matcher(string2).find() || BindLexer.regExPatternIsolation.matcher(string2).find() || BindLexer.regExPatternReadOnly.matcher(string2).find() || BindLexer.regExPatternUpdate.matcher(string2).find()) {
                n2 = this.getStartingPosition(string2);
                charSequence = new StringBuffer(string);
                object = this.getFetchFirstClause(element);
                ((StringBuffer)charSequence).insert(n2, (String)object);
                string = ((StringBuffer)charSequence).toString();
            } else {
                string = this.buildMaxRowsEntry(element, string);
            }
        }
        n2 = 1;
        if (!(StaticProfileConstants.forReadOnlyPat.matcher(string).find() || StaticProfileConstants.forUpdateOfPat.matcher(string).find() || StaticProfileConstants.forFetchOnlyPat.matcher(string).find())) {
            n2 = 0;
        }
        charSequence = stringBuffer.toString() + " FOR " + string;
        if (1008 == n3 && !this.prepareOptionReadOnly_ && n2 == 0) {
            if (!StaticProfileConstants.forUpdateOfPat.matcher(charSequence).find()) {
                charSequence = (String)charSequence + " FOR UPDATE ";
            }
        } else if ("SINGLE_ROW_RESULT".equals(this.getValuefromStatementAttributes(element, "rowType"))) {
            Element element2;
            NodeList nodeList;
            object = element.getElementsByTagName("resultSetMetadata");
            if (object != null && object.getLength() > 0 && (nodeList = (element2 = (Element)object.item(0)).getElementsByTagName("column")) != null && nodeList.getLength() > 0) {
                int n4;
                int n5 = nodeList.getLength();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("SELECT * INTO ?");
                for (n4 = 2; n4 <= n5; ++n4) {
                    stringBuffer2.append(", ?");
                }
                stringBuffer2.append(" FROM TABLE ( ");
                n4 = -1;
                Matcher matcher = regExPatternSelectEndClauses.matcher(string);
                if (matcher.find()) {
                    n4 = matcher.start();
                }
                if (n4 == -1) {
                    stringBuffer2.append(string);
                    stringBuffer2.append(" ) AS pdqSingleton");
                } else {
                    stringBuffer2.append(string.substring(0, n4));
                    stringBuffer2.append(" ) AS pdqSingleton ");
                    stringBuffer2.append(string.substring(n4));
                }
                charSequence = stringBuffer2.toString();
                charSequence = bindUtils.parseSQLTextForDB2((String)charSequence);
            }
        } else if ((1007 == n3 || this.prepareOptionReadOnly_) && n2 == 0) {
            charSequence = (String)charSequence + " FOR READ ONLY ";
        }
        this.bindStatementsIncludesReservedSections_.add((String)charSequence);
    }

    private int getStartingPosition(String string) {
        Matcher matcher = BindLexer.regExPatternOptimizeFor.matcher(string);
        Matcher matcher2 = BindLexer.regExPatternIsolation.matcher(string);
        Matcher matcher3 = BindLexer.regExPatternReadOnly.matcher(string);
        Matcher matcher4 = BindLexer.regExPatternUpdate.matcher(string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (matcher.find()) {
            n2 = matcher.start();
        }
        if (matcher2.find()) {
            n3 = matcher2.start();
        }
        if (matcher3.find()) {
            n4 = matcher3.start();
        }
        if (matcher4.find()) {
            n5 = matcher4.start();
        }
        int n6 = n2;
        if (n3 != 0 && n6 > n3) {
            n6 = n3;
        } else if (n6 == 0 && n3 != 0) {
            n6 = n3;
        }
        if (n4 != 0 && n6 > n4) {
            n6 = n4;
        } else if (n6 == 0 && n4 != 0) {
            n6 = n4;
        }
        if (n5 != 0 && n6 > n5) {
            n6 = n5;
        } else if (n6 == 0 && n5 != 0) {
            n6 = n5;
        }
        return n6;
    }

    private void appendCursorAttributes(StringBuffer stringBuffer, String string, String string2, Boolean bl2, boolean bl3) {
        String string3 = "";
        if (string != null) {
            String string4 = string;
            Matcher matcher = StaticProfileConstants.withRowsetPositioningPat.matcher(string);
            StringBuffer stringBuffer2 = new StringBuffer();
            if (matcher.find()) {
                matcher.appendReplacement(stringBuffer2, " ");
                matcher.appendTail(stringBuffer2);
                string4 = stringBuffer2.toString();
            }
            stringBuffer2 = new StringBuffer();
            Matcher matcher2 = StaticProfileConstants.forUpdateOfPat.matcher(string4);
            if (matcher2.find()) {
                matcher2.appendReplacement(stringBuffer2, " ");
                matcher2.appendTail(stringBuffer2);
                string4 = stringBuffer2.toString();
            }
            stringBuffer2 = new StringBuffer();
            Matcher matcher3 = StaticProfileConstants.forReadOnlyPat.matcher(string4);
            this.prepareOptionReadOnly_ = matcher3.find();
            Matcher matcher4 = StaticProfileConstants.scrollPat.matcher(string4);
            if (matcher4.find()) {
                string3 = matcher4.group(1);
            }
            stringBuffer.append(" " + stringBuffer2.toString() + " " + string3);
        }
        stringBuffer.append(" CURSOR ");
        if (bl3) {
            stringBuffer.append(" WITH ROWSET POSITIONING ");
        }
        if (string2.equalsIgnoreCase("HOLD_CURSORS_OVER_COMMIT") || bl2.booleanValue()) {
            stringBuffer.append(" WITH HOLD ");
        }
    }

    public void setBindConnection(DB2Connection dB2Connection) {
        this.bindConn_ = dB2Connection;
    }

    private static InputStream getResourceAsInputStreamUseBinderClassLoader(String string) {
        if (FileLoader.binderClassLoader.get() != null) {
            return FileLoader.binderClassLoader.get().getResourceAsStream(string);
        }
        ClassLoader classLoader = ProfilerBinderHelper.class.getClassLoader();
        return classLoader.getResourceAsStream(string);
    }

    private static final PrivilegedAction<InputStream> getResourceAsInputStreamUseBinderClassLoaderPriv(final String string) {
        return new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return ProfilerBinderHelper.getResourceAsInputStreamUseBinderClassLoader(string);
            }
        };
    }

    public XmlFileHelper getXmlHelper() {
        return this.xmlHelper_;
    }

    private boolean isDDLStmt(Element element) {
        Element element2 = (Element)element.getElementsByTagName("statementType").item(0);
        String string = element2.getTextContent();
        return StaticProfileCaptureHelper.isDDLStatementTag(string);
    }
}

