/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementJDBCBase;

public class RTStatementJDBCCallable
extends RTStatementJDBCBase
implements RTCallableStatement {
    protected CallableStatement callableStmt;

    public RTStatementJDBCCallable(CallableStatement callableStatement) {
        super(callableStatement);
        this.callableStmt = callableStatement;
    }

    @Override
    public CallableStatement getJDBCCallableStatement() {
        return this.callableStmt;
    }

    @Override
    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.callableStmt.registerOutParameter(n2, n3);
    }

    @Override
    public String getString(int n2) throws SQLException {
        return this.callableStmt.getString(n2);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        return this.callableStmt.getBytes(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.callableStmt.getDate(n2);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        return this.callableStmt.getArray(n2);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        return this.callableStmt.getSQLXML(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.callableStmt.getRowId(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.callableStmt.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.callableStmt.getTimestamp(n2);
    }

    @Override
    public boolean getBooleanNoNull(int n2) throws SQLException {
        boolean bl2 = this.callableStmt.getBoolean(n2);
        if (this.isIndicatorSet(n2)) {
            return bl2;
        }
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return bl2;
    }

    @Override
    public byte getByteNoNull(int n2) throws SQLException {
        byte by2 = this.callableStmt.getByte(n2);
        if (this.isIndicatorSet(n2)) {
            return by2;
        }
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return by2;
    }

    @Override
    public short getShortNoNull(int n2) throws SQLException {
        short s2 = this.callableStmt.getShort(n2);
        if (this.isIndicatorSet(n2)) {
            return s2;
        }
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return s2;
    }

    @Override
    public int getIntNoNull(int n2) throws SQLException {
        int n3 = this.callableStmt.getInt(n2);
        if (this.isIndicatorSet(n2)) {
            return n3;
        }
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return n3;
    }

    @Override
    public long getLongNoNull(int n2) throws SQLException {
        long l10 = this.callableStmt.getLong(n2);
        if (this.isIndicatorSet(n2)) {
            return l10;
        }
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return l10;
    }

    @Override
    public float getFloatNoNull(int n2) throws SQLException {
        float f10 = this.callableStmt.getFloat(n2);
        if (this.isIndicatorSet(n2)) {
            return f10;
        }
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return f10;
    }

    @Override
    public double getDoubleNoNull(int n2) throws SQLException {
        double d10 = this.callableStmt.getDouble(n2);
        if (this.isIndicatorSet(n2)) {
            return d10;
        }
        if (this.callableStmt.wasNull()) {
            throw new SQLNullException();
        }
        return d10;
    }

    @Override
    public Boolean getBooleanWrapper(int n2) throws SQLException {
        boolean bl2 = this.callableStmt.getBoolean(n2);
        return this.callableStmt.wasNull() ? null : Boolean.valueOf(bl2);
    }

    @Override
    public Byte getByteWrapper(int n2) throws SQLException {
        byte by2 = this.callableStmt.getByte(n2);
        return this.callableStmt.wasNull() ? null : Byte.valueOf(by2);
    }

    @Override
    public Short getShortWrapper(int n2) throws SQLException {
        short s2 = this.callableStmt.getShort(n2);
        return this.callableStmt.wasNull() ? null : Short.valueOf(s2);
    }

    @Override
    public Integer getIntWrapper(int n2) throws SQLException {
        int n3 = this.callableStmt.getInt(n2);
        return this.callableStmt.wasNull() ? null : Integer.valueOf(n3);
    }

    @Override
    public Long getLongWrapper(int n2) throws SQLException {
        long l10 = this.callableStmt.getLong(n2);
        return this.callableStmt.wasNull() ? null : Long.valueOf(l10);
    }

    @Override
    public Float getFloatWrapper(int n2) throws SQLException {
        float f10 = this.callableStmt.getFloat(n2);
        return this.callableStmt.wasNull() ? null : Float.valueOf(f10);
    }

    @Override
    public Double getDoubleWrapper(int n2) throws SQLException {
        double d10 = this.callableStmt.getDouble(n2);
        return this.callableStmt.wasNull() ? null : Double.valueOf(d10);
    }

    @Override
    public Object getObject(int n2, Class clazz) throws SQLException {
        Object object = this.callableStmt.getObject(n2);
        RTStatementJDBCCallable.checkObjectClass(object, clazz);
        return object;
    }

    public static void checkObjectClass(Object object, Class clazz) throws SQLException {
        if (object == null) {
            return;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, object.getClass());
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.callableStmt.getBigDecimal(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.callableStmt.getBlob(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.callableStmt.getClob(n2);
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.callableStmt.getRef(n2);
    }

    @Override
    public short getIndicator(int n2) throws SQLException {
        short s2 = 0;
        if (this.isIndicatorSet(n2)) {
            if (this.callableStmt.wasNull()) {
                s2 = -1;
            }
        } else {
            ProfileRefErrors.raise_UNEXPECTED_CALL("getIndicator(" + n2 + ")");
        }
        return s2;
    }

    @Override
    public void setOutputIndicators(int[] nArray) {
        this.m_indicatorArray = nArray;
    }

    private boolean isIndicatorSet(int n2) {
        return this.m_indicatorArray != null && Arrays.binarySearch(this.m_indicatorArray, n2) >= 0;
    }
}

