/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.nio.ByteOrder;
import net.jpountz.util.Utils;

public enum SafeUtils {


    public static void checkRange(byte[] byArray, int n2) {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
    }

    public static void checkRange(byte[] byArray, int n2, int n3) {
        SafeUtils.checkLength(n3);
        if (n3 > 0) {
            SafeUtils.checkRange(byArray, n2);
            SafeUtils.checkRange(byArray, n2 + n3 - 1);
        }
    }

    public static void checkLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
    }

    public static byte readByte(byte[] byArray, int n2) {
        return byArray[n2];
    }

    public static int readIntBE(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public static int readIntLE(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    public static int readInt(byte[] byArray, int n2) {
        if (Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            return SafeUtils.readIntBE(byArray, n2);
        }
        return SafeUtils.readIntLE(byArray, n2);
    }

    public static long readLongLE(byte[] byArray, int n2) {
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
    }

    public static void writeShortLE(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)n3;
        byArray[n2++] = (byte)(n3 >>> 8);
    }

    public static void writeInt(int[] nArray, int n2, int n3) {
        nArray[n2] = n3;
    }

    public static int readInt(int[] nArray, int n2) {
        return nArray[n2];
    }

    public static void writeByte(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)n3;
    }

    public static void writeShort(short[] sArray, int n2, int n3) {
        sArray[n2] = (short)n3;
    }

    public static int readShortLE(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    public static int readShort(short[] sArray, int n2) {
        return sArray[n2] & 0xFFFF;
    }
}

