/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.xxhash;

import java.nio.ByteBuffer;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import net.jpountz.xxhash.XXHashJNI;

final class XXHash64JNI
extends XXHash64 {
    public static final XXHash64 INSTANCE = new XXHash64JNI();
    private static XXHash64 SAFE_INSTANCE;

    XXHash64JNI() {
    }

    @Override
    public long hash(byte[] byArray, int n2, int n3, long l7) {
        SafeUtils.checkRange(byArray, n2, n3);
        return XXHashJNI.XXH64(byArray, n2, n3, l7);
    }

    @Override
    public long hash(ByteBuffer byteBuffer, int n2, int n3, long l7) {
        if (byteBuffer.isDirect()) {
            ByteBufferUtils.checkRange(byteBuffer, n2, n3);
            return XXHashJNI.XXH64BB(byteBuffer, n2, n3, l7);
        }
        if (byteBuffer.hasArray()) {
            return this.hash(byteBuffer.array(), n2 + byteBuffer.arrayOffset(), n3, l7);
        }
        XXHash64 xXHash64 = SAFE_INSTANCE;
        if (xXHash64 == null) {
            xXHash64 = SAFE_INSTANCE = XXHashFactory.safeInstance().hash64();
        }
        return xXHash64.hash(byteBuffer, n2, n3, l7);
    }
}

