/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.io.IOException;
import sqlj.codegen.CodeGenerator;
import sqlj.codegen.CodeGeneratorFactory;
import sqlj.codegen.ContextJSClass;
import sqlj.codegen.CursorJSClass;
import sqlj.codegen.UnitInfo;
import sqlj.framework.JSClass;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.options.HasOptions;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.OptionGroup;
import sqlj.framework.options.PropertyList;
import sqlj.semantics.SemanticAnalyzer;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.syntax.ContextElem;
import sqlj.syntax.CursorElem;
import sqlj.syntax.Elem;
import sqlj.syntax.ExecElem;
import sqlj.syntax.IntoBindExpr;
import sqlj.util.BlockDescriptor;
import sqlj.util.ClassDescriptor;
import sqlj.util.DefaultParselet;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;
import sqlj.util.TranslationContext;
import sqlj.util.TypeDescriptor;

public class ParseletFactory
implements HasOptions {
    private SemanticAnalyzerFactory semanticsFactory = null;
    private CodeGeneratorFactory codegenFactory = null;
    private OptionGroup m_options = new OptionGroup();

    public ParseletFactory(TranslationContext translationContext) {
        this.semanticsFactory = new SemanticAnalyzerFactory(translationContext, this);
        this.codegenFactory = new CodeGeneratorFactory(translationContext);
        this.m_options.addElement(this.semanticsFactory);
        this.m_options.addElement(this.codegenFactory);
    }

    public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
        this.m_options.setOptions(propertyList, errorLog);
    }

    public String[][] getOptionInfo() {
        return this.m_options.getOptionInfo();
    }

    public JSClass newIteratorClass(IntoBindExpr intoBindExpr) throws ClassNotFoundException {
        return new CursorJSClass(intoBindExpr);
    }

    public Parselet newParselet(Elem elem) {
        if (elem instanceof CursorElem) {
            return this.newParselet((CursorElem)elem);
        }
        if (elem instanceof ExecElem) {
            return this.newParselet((ExecElem)elem);
        }
        if (elem instanceof ContextElem) {
            return this.newParselet((ContextElem)elem);
        }
        throw new IllegalArgumentException("unrecognized elem type :" + elem);
    }

    public Parselet newParselet(CursorElem cursorElem) {
        return new CursorParseletImpl(cursorElem);
    }

    public Parselet newParselet(ExecElem execElem) {
        return new ExecParseletImpl(execElem);
    }

    public Parselet newParselet(ContextElem contextElem) {
        return new ContextParseletImpl(contextElem);
    }

    private class ExecParseletImpl
    extends ParseletImpl {
        private ExecElem m_exec;
        private TypeDescriptor m_desc = new BlockDescriptor();

        public ExecParseletImpl(ExecElem execElem) {
            super(execElem);
            this.m_exec = execElem;
        }

        SemanticAnalyzer newAnalyzer() {
            return ParseletFactory.this.semanticsFactory.newSemanticAnalyzer(this.m_exec);
        }

        CodeGenerator newCodeGenerator() {
            return ParseletFactory.this.codegenFactory.newCodeGenerator(this.m_exec);
        }

        public TypeDescriptor getDescriptor() {
            return this.m_desc;
        }
    }

    private class ContextParseletImpl
    extends ParseletImpl {
        private ContextElem m_context;
        private TypeDescriptor m_desc = null;

        public ContextParseletImpl(ContextElem contextElem) {
            super(contextElem);
            this.m_context = contextElem;
        }

        public Parselet getEnclosingClass() {
            return this;
        }

        SemanticAnalyzer newAnalyzer() {
            return ParseletFactory.this.semanticsFactory.newSemanticAnalyzer(this.m_context);
        }

        CodeGenerator newCodeGenerator() {
            return ParseletFactory.this.codegenFactory.newCodeGenerator(this.m_context);
        }

        public TypeDescriptor getDescriptor() {
            if (this.m_desc == null) {
                this.m_desc = new ClassDescriptor(new ContextJSClass.Base(this.m_context));
            }
            return this.m_desc;
        }
    }

    private class CursorParseletImpl
    extends ParseletImpl {
        private CursorElem m_cursor;
        private TypeDescriptor m_desc = null;

        public CursorParseletImpl(CursorElem cursorElem) {
            super(cursorElem);
            this.m_cursor = cursorElem;
        }

        SemanticAnalyzer newAnalyzer() {
            return ParseletFactory.this.semanticsFactory.newSemanticAnalyzer(this.m_cursor);
        }

        CodeGenerator newCodeGenerator() {
            return ParseletFactory.this.codegenFactory.newCodeGenerator(this.m_cursor);
        }

        public Parselet getEnclosingClass() {
            return this;
        }

        public TypeDescriptor getDescriptor() {
            if (this.m_desc == null) {
                this.m_desc = new ClassDescriptor(new CursorJSClass.Base(this.m_cursor));
            }
            return this.m_desc;
        }
    }

    private static abstract class ParseletImpl
    extends DefaultParselet {
        Elem m_elem;

        public ParseletImpl(Elem elem) {
            this.m_elem = elem;
            elem.setScope(this);
        }

        public boolean generate(OutputContext outputContext) throws IOException {
            UnitInfo unitInfo = UnitInfo.getInfoFor(this);
            SemanticAnalyzer semanticAnalyzer = this.newAnalyzer();
            boolean bl = semanticAnalyzer.prepare();
            if (bl) {
                semanticAnalyzer = null;
                CodeGenerator codeGenerator = this.newCodeGenerator();
                try {
                    bl = codeGenerator.generate(outputContext);
                }
                catch (IOException iOException) {
                    unitInfo.addError();
                    throw iOException;
                }
            }
            if (!bl) {
                unitInfo.addError();
            }
            return bl;
        }

        abstract SemanticAnalyzer newAnalyzer();

        abstract CodeGenerator newCodeGenerator();
    }
}

