/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework.ide;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sqlj.framework.ClassResolver;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.framework.ide.TranslationByteInput;
import sqlj.framework.ide.TranslationCharInput;
import sqlj.framework.ide.TranslationInput;
import sqlj.framework.ide.TranslationLog;
import sqlj.framework.ide.TranslationOutput;
import sqlj.framework.ide.TranslationUnit;
import sqlj.mesg.TranslatorErrors;
import sqlj.util.OutputContext;
import sqlj.util.ParseContext;
import sqlj.util.io.CharStream;
import sqlj.util.io.ErrorLogger;
import sqlj.util.io.UCode_CharStream;

class IDETranslationUnit
implements sqlj.translator.TranslationUnit,
ParseContext,
OutputContext {
    private static final String TMP_PREFIX = "sqlj";
    private static final String JAVA_SUFFIX = ".java";
    private static final String SQLJ_SUFFIX = ".sqlj";
    private static final int SQLJ_SUFFIX_LEN = ".sqlj".length();
    private Reader m_reader = null;
    private UCode_CharStream m_charStream = null;
    private ErrorLogger m_elog = null;
    private TranslationLog m_jslog = null;
    private String m_package = "";
    private String m_name;
    private int m_type;
    private TranslationInput m_in;
    private TranslationOutput m_out;
    private TranslationUnit m_unit;
    private ClassResolver m_defaultCr = null;
    private Writer m_writer = null;

    public IDETranslationUnit(TranslationUnit translationUnit, ClassResolver classResolver) throws IOException {
        this.m_unit = translationUnit;
        this.m_in = translationUnit.getInput();
        this.m_out = translationUnit.getOutput();
        this.m_jslog = translationUnit.getErrorLog();
        this.m_elog = new ErrorLogger();
        this.m_name = this.m_in.getName();
        this.m_defaultCr = classResolver;
        if (this.m_name.endsWith(JAVA_SUFFIX)) {
            this.m_type = 2;
        } else if (this.m_name.endsWith(SQLJ_SUFFIX)) {
            this.m_type = 1;
        } else {
            this.m_elog.addEntry(new JSError(TranslatorErrors.illegal_input_extension(this.m_name)));
            this.m_elog.printLog(this.m_jslog);
            throw new IOException();
        }
    }

    public String getFileName() {
        String string = this.m_in.getName();
        if (string.endsWith(JAVA_SUFFIX)) {
            string = string.substring(0, string.length() - JAVA_SUFFIX.length());
        } else if (string.endsWith(SQLJ_SUFFIX)) {
            string = string.substring(0, string.length() - SQLJ_SUFFIX.length());
        }
        return string;
    }

    public ParseContext getInput() throws IOException {
        if (this.m_reader == null) {
            this.createInput();
        }
        return this;
    }

    public Reader getReader() {
        return this.m_reader;
    }

    public CharStream getCharStream() {
        return this.m_charStream;
    }

    public ErrorLogger getErrorLogger() {
        return this.m_elog;
    }

    private void createInput() throws IOException {
        try {
            this.m_charStream = this.m_in instanceof TranslationCharInput ? new UCode_CharStream(((TranslationCharInput)this.m_in).getReader(), (ErrorLog)this.m_elog) : (this.m_in instanceof TranslationByteInput ? new UCode_CharStream(((TranslationByteInput)this.m_in).getInputStream(), (ErrorLog)this.m_elog) : new UCode_CharStream(this.m_in.getInStream(), (ErrorLog)this.m_elog));
            this.m_reader = this.m_charStream.getReader();
            this.m_elog = this.m_elog.createChild(this.m_name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_elog.addEntry(new JSError(TranslatorErrors.unsupported_file_encoding()));
            this.m_elog.printLog(this.m_jslog);
            throw new IOException(unsupportedEncodingException.getMessage());
        }
        catch (Exception exception) {
            this.m_elog.addEntry(new JSError(TranslatorErrors.input_file_not_found(this.m_in.getPath())));
            this.m_elog.printLog(this.m_jslog);
            throw new IOException(exception.getMessage());
        }
    }

    public String getName() {
        System.out.println("file name is " + this.m_name);
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public ClassResolver getClassResolver() {
        ClassResolver classResolver = this.m_unit.getClassResolver();
        if (classResolver == null) {
            classResolver = this.m_defaultCr;
        }
        return classResolver;
    }

    public void setPackageName(String string) {
        this.m_package = string;
        this.m_unit.setPackageName(string);
    }

    public OutputContext getOutput() throws IOException {
        if (this.m_writer == null) {
            this.createOutput();
        }
        return this;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public Writer createWriter(String string) throws IOException {
        return this.m_out.createWriter(string);
    }

    public OutputStream createOutputStream(String string) throws IOException {
        return this.m_out.createOutputStream(string);
    }

    private void createOutput() throws IOException {
        this.m_writer = this.m_out.getWriter();
    }

    public void translationComplete(boolean bl) throws IOException {
        this.m_elog.printLog(this.m_jslog);
        this.m_unit.translationComplete(bl);
    }
}

