/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import sqlj.framework.JSClass;
import sqlj.javac.ExpressionNode;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.Token;

public class CastOperatorNode
extends ExpressionNode {
    String typename;
    String text;
    ExpressionNode operand;
    int row;
    int col;

    CastOperatorNode(JavaParserImpl javaParserImpl, Token token, String string, Token token2, ExpressionNode expressionNode) {
        super(javaParserImpl);
        this.typename = string;
        this.text = token.getText() + string + token2.getText();
        this.operand = expressionNode;
        this.row = token.beginLine;
        this.col = token.beginColumn;
    }

    int getRow() {
        return this.row;
    }

    int getColumn() {
        return this.col;
    }

    public final void getTextTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.text);
        this.operand.getTextTo(stringBuffer);
    }

    void scopeChanged() {
        this.operand.setScope(this.getScope());
    }

    JSClass getType() {
        if (this.operand.getType() == JSClass.void_TYPE) {
            this.Error(16);
            return null;
        }
        try {
            JSClass jSClass = this.getClassResolver().getClass(this.typename).getJSClass();
            if (this.operand.isNumericType() && this.isNumericType(jSClass)) {
                return jSClass;
            }
            if (jSClass != null && jSClass.isAssignableFrom(this.operand.getType())) {
                return jSClass;
            }
            if (this.operand.getType() != null && this.operand.getType().isAssignableFrom(jSClass)) {
                return jSClass;
            }
            this.Error(28);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.Error(38);
        }
        return null;
    }

    private boolean isNumericType(JSClass jSClass) {
        return jSClass == JSClass.int_TYPE || jSClass == JSClass.long_TYPE || jSClass == JSClass.byte_TYPE || jSClass == JSClass.short_TYPE || jSClass == JSClass.char_TYPE || jSClass == JSClass.float_TYPE || jSClass == JSClass.double_TYPE;
    }
}

