/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.javac.CopyOut;
import sqlj.javac.JavaParserImplTokenManager;
import sqlj.javac.JavaParserSub;
import sqlj.javac.LinefeedFilter;
import sqlj.javac.PrefixFilter;
import sqlj.javac.Token;
import sqlj.util.ClassNameResolver;
import sqlj.util.DefaultParselet;
import sqlj.util.OutputContext;
import sqlj.util.ParseContext;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;
import sqlj.util.io.CharStream;

class JavaParserSubTokenManager
extends JavaParserImplTokenManager {
    JavaParserSub parser;
    private Copying m_copy;
    private ParseContext m_ctx;
    String[] tokenImage = new String[16];
    int addTokenImage = 0;

    JavaParserSubTokenManager(CharStream charStream, JavaParserSub javaParserSub) {
        super(charStream);
        this.m_copy = new Copying();
        this.parser = javaParserSub;
    }

    public void ReInit(CharStream charStream) {
        super.ReInit(charStream);
        this.m_copy = new Copying();
    }

    public CopyOut getCopyOut() {
        return this.m_copy;
    }

    void setParseContext(ParseContext parseContext) {
        this.m_ctx = parseContext;
    }

    void compactTokenImage(Token token) {
        if (token.kind == 0) {
            this.tokenImage = new String[16];
            this.addTokenImage = 0;
            return;
        }
        if (token.specialToken != null) {
            this.compactTokenImage(token.specialToken);
        }
        String string = token.image;
        for (int i = 0; i < this.addTokenImage; ++i) {
            if (!this.tokenImage[i].equals(string)) continue;
            token.image = this.tokenImage[i];
            return;
        }
        if (this.addTokenImage >= this.tokenImage.length) {
            String[] stringArray = new String[2 * this.tokenImage.length];
            System.arraycopy(this.tokenImage, 0, stringArray, 0, this.tokenImage.length);
            this.tokenImage = stringArray;
        }
        this.tokenImage[this.addTokenImage++] = string;
        token.image = string;
    }

    public Token getNextToken() {
        Token token = super.getNextToken();
        if (token.kind != 132) {
            this.compactTokenImage(token);
            this.m_copy.addToken(token);
        }
        return token;
    }

    private void Error(String string, Token token) {
        this.parser.Error(string, token);
    }

    class TokenManagerParselet
    extends DefaultParselet {
        private Vector m_children = new Vector();

        TokenManagerParselet(Vector vector) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Parselet parselet = (Parselet)enumeration.nextElement();
                this.m_children.addElement(parselet);
            }
        }

        public boolean generate(OutputContext outputContext) throws IOException {
            boolean bl = true;
            for (int i = 0; i < this.m_children.size(); ++i) {
                Parselet parselet = (Parselet)this.m_children.elementAt(i);
                bl = parselet.generate(outputContext) && bl;
            }
            return bl;
        }
    }

    class StringParselet
    extends DefaultParselet {
        private Vector m_string;
        private int m_startline;
        private int m_startcol;
        private int m_endline;
        private int m_endcol;

        StringParselet(Vector vector, int n, int n2, int n3, int n4) {
            this.m_string = vector;
            this.m_startline = n;
            this.m_startcol = n2;
            this.m_endline = n3;
            this.m_endcol = n4;
        }

        public boolean generate(OutputContext outputContext) throws IOException {
            boolean bl;
            LinefeedFilter linefeedFilter = new LinefeedFilter(outputContext.getWriter());
            boolean bl2 = bl = this.m_startline >= 0 && (this.m_startline != this.m_endline || this.m_startcol != this.m_endcol);
            if (bl) {
                linefeedFilter.write("/*@lineinfo:user-code*/");
                linefeedFilter.write("/*@lineinfo:" + this.m_startline + "^" + this.m_startcol + "*/");
            }
            Enumeration enumeration = this.m_string.elements();
            while (enumeration.hasMoreElements()) {
                linefeedFilter.write(enumeration.nextElement().toString());
            }
            if (bl) {
                linefeedFilter.write("/*@lineinfo:generated-code*/");
            }
            return true;
        }
    }

    class PositionedParselet
    implements Parselet {
        private Parselet m_p;
        private String m_prefix;

        PositionedParselet(Parselet parselet, int n, int n2) {
            this.m_p = parselet;
            this.m_prefix = "/*@lineinfo:" + n + "^" + n2 + "*/";
        }

        public boolean generate(OutputContext outputContext) throws IOException {
            return this.m_p.generate(new ModifiedContext(outputContext));
        }

        public void setScope(Parselet parselet) {
            this.m_p.setScope(parselet);
        }

        public Parselet getScope() {
            return this.m_p.getScope();
        }

        public Parselet getEnclosingClass() {
            return this.m_p.getEnclosingClass();
        }

        public Parselet getDefiningUnit() {
            return this.m_p.getDefiningUnit();
        }

        public void setInfo(Object object) {
            this.m_p.setInfo(object);
        }

        public Object getInfo() {
            return this.m_p.getInfo();
        }

        public TypeDescriptor getDescriptor() {
            return this.m_p.getDescriptor();
        }

        public ClassNameResolver getClassResolver() {
            return this.m_p.getClassResolver();
        }

        class ModifiedContext
        implements OutputContext {
            OutputContext m_ctx;
            Writer m_w;

            ModifiedContext(OutputContext outputContext) {
                this.m_ctx = outputContext;
                this.m_w = new PrefixFilter(outputContext.getWriter(), PositionedParselet.this.m_prefix);
            }

            public Writer getWriter() {
                return this.m_w;
            }

            public Writer createWriter(String string) throws IOException {
                return this.m_ctx.createWriter(string);
            }

            public OutputStream createOutputStream(String string) throws IOException {
                return this.m_ctx.createOutputStream(string);
            }
        }
    }

    class Copying
    implements CopyOut {
        private Vector m_parselets;
        private Vector m_tokenbuff = new Vector();
        private boolean m_copying = true;
        private int m_startline = 1;
        private int m_startcol = 1;
        private boolean seenSQL = false;

        Copying() {
            this.m_parselets = new Vector();
        }

        public void addParselet(Parselet parselet, int n, int n2) {
            this.m_parselets.addElement(new PositionedParselet(parselet, n, n2));
        }

        public void startCopying() {
            this.m_copying = true;
            this.m_startline = JavaParserSubTokenManager.this.m_ctx.getCharStream().getEndLine();
            this.m_startcol = JavaParserSubTokenManager.this.m_ctx.getCharStream().getEndColumn();
        }

        public void endCopying() {
            this.m_copying = false;
            this.m_parselets.addElement(new StringParselet(this.m_tokenbuff, this.m_startline, this.m_startcol, JavaParserSubTokenManager.this.m_ctx.getCharStream().getBeginLine(), JavaParserSubTokenManager.this.m_ctx.getCharStream().getBeginColumn()));
            this.m_tokenbuff = new Vector();
        }

        void addToken(Token token) {
            Token token2 = token.specialToken;
            if (token2 != null) {
                while (token2.specialToken != null) {
                    token2 = token2.specialToken;
                }
            }
            while (token2 != null) {
                if (token.kind != 0) {
                    this.m_tokenbuff.addElement(token2.image);
                }
                token2 = token2.next;
            }
            if (!token.image.equals("#sql")) {
                if (!this.seenSQL || !token.image.equals(";")) {
                    this.m_tokenbuff.addElement(token.image);
                }
                this.seenSQL = false;
            } else {
                this.seenSQL = true;
            }
        }

        public Parselet getParselet() {
            if (this.m_copying) {
                this.endCopying();
            }
            return new TokenManagerParselet(this.m_parselets);
        }
    }
}

