/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.SQLException;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.DynamicProfileWrapper;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementWrapper;
import sqlj.runtime.ref.ResultSetIterImpl;

public class UntypedSelectProfile
extends DynamicProfileWrapper {
    public UntypedSelectProfile(DynamicProfile dynamicProfile) {
        super(dynamicProfile);
    }

    public RTStatement getStatement(int n) throws SQLException {
        RTStatement rTStatement = super.getStatement(n);
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n);
        if (entryInfo.getRole() == 19) {
            if (entryInfo.getStatementType() != 4) {
                ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entryInfo.getSQLString());
            }
            if (entryInfo.getExecuteType() != 8) {
                ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
            }
            rTStatement = new UntypedSelectStatement((RTCallableStatement)rTStatement, entryInfo);
        }
        return rTStatement;
    }

    public static class UntypedSelectStatement
    extends RTStatementWrapper
    implements RTCallableStatement {
        private RTResultSet m_rs = null;
        private int m_resultParam;
        private RTCallableStatement m_cstmt;

        public UntypedSelectStatement(RTCallableStatement rTCallableStatement, EntryInfo entryInfo) {
            super(rTCallableStatement);
            this.m_resultParam = entryInfo.getParamCount();
            this.m_cstmt = rTCallableStatement;
        }

        public void registerOutParameter(int n, int n2) throws SQLException {
            if (n != this.m_resultParam) {
                this.m_cstmt.registerOutParameter(n, n2);
            }
        }

        public Object getObject(int n, Class clazz) throws SQLException {
            if (n == this.m_resultParam) {
                return UntypedSelectStatement.newUntypedIterator(this.getQueryResult());
            }
            return super.getObject(n, clazz);
        }

        private RTResultSet getQueryResult() throws SQLException {
            if (this.m_rs == null) {
                ProfileRefErrors.raise_UNEXPECTED_CALL("getQueryResult");
            }
            return this.m_rs;
        }

        public int executeUpdate() throws SQLException {
            this.m_rs = this.stmt.executeRTQuery();
            return -1;
        }

        public static ResultSetIterator newUntypedIterator(RTResultSet rTResultSet) throws SQLException {
            return new ResultSetIterImpl(rTResultSet);
        }
    }
}

