/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.mesg.ProfilePrinterErrors;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.TypeInfo;
import sqlj.runtime.profile.util.CustomizerHarness;
import sqlj.runtime.profile.util.ProfileCustomizer;

public class ProfilePrinter
implements ProfileCustomizer {
    private PrintWriter m_out;
    private static final String m_banner = ProfilePrinterErrors.banner();

    public static void main(String[] stringArray) {
        System.exit(ProfilePrinter.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "-customizer=sqlj.runtime.profile.util.ProfilePrinter";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return CustomizerHarness.mainStatus(stringArray2);
    }

    public boolean acceptsConnection(Connection connection) {
        return connection == null;
    }

    public boolean customize(Profile profile, Connection connection, ErrorLog errorLog) {
        String string = errorLog.getFileName();
        errorLog.setFileName(null);
        PrintWriter printWriter = this.m_out;
        this.setOutput(new PrintLog(errorLog));
        this.print(profile);
        this.setOutput(printWriter);
        errorLog.setFileName(string);
        return false;
    }

    public ProfilePrinter() {
        this(new PrintWriter(System.out));
    }

    public ProfilePrinter(PrintWriter printWriter) {
        this.setOutput(printWriter);
    }

    private void banner() {
        this.m_out.println(m_banner);
    }

    public void setOutput(PrintWriter printWriter) {
        this.m_out = printWriter;
    }

    public void print(Profile profile) {
        this.banner();
        this.m_out.println(ProfilePrinterErrors.printing_profile(profile.getProfileName()));
        this.m_out.println(ProfilePrinterErrors.creation_time(profile.getTimestamp(), new Date(profile.getTimestamp())));
        this.m_out.println(ProfilePrinterErrors.context(profile.getContextName()));
        this.m_out.println(ProfilePrinterErrors.loader(profile.getLoader() + ""));
        int n = 0;
        Enumeration enumeration = profile.getCustomizations();
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        this.m_out.println(ProfilePrinterErrors.customization_count(n));
        enumeration = profile.getCustomizations();
        while (enumeration.hasMoreElements()) {
            this.m_out.println(enumeration.nextElement());
        }
        this.print(profile.getProfileData());
    }

    public void print(ProfileData profileData) {
        int n = profileData.size();
        this.m_out.println(ProfilePrinterErrors.source_file(profileData.getSourceFile() + ""));
        this.m_out.println(ProfilePrinterErrors.entry_count(n));
        this.banner();
        for (int i = 0; i < n; ++i) {
            this.print(profileData, i);
            this.banner();
        }
        this.m_out.flush();
    }

    public void print(ProfileData profileData, int n) {
        EntryInfo entryInfo = profileData.getEntryInfo(n);
        this.m_out.println(ProfilePrinterErrors.profile_entry(profileData.getProfile().getProfileName(), n));
        this.print(profileData, entryInfo);
    }

    public void print(ProfileData profileData, EntryInfo entryInfo) {
        int n;
        this.m_out.println("#sql { " + entryInfo.getSQLString() + " };");
        this.m_out.println(ProfilePrinterErrors.line_number(entryInfo.getLineNumber()));
        this.m_out.println(ProfilePrinterErrors.stmt_and_exec_type(EntryInfo.statementTypeToString(entryInfo.getStatementType()), EntryInfo.executeTypeToString(entryInfo.getExecuteType())));
        this.m_out.println(ProfilePrinterErrors.role(EntryInfo.roleToString(entryInfo.getRole())));
        this.printDescriptor(entryInfo.getDescriptor());
        int n2 = entryInfo.getParamCount();
        this.m_out.println(ProfilePrinterErrors.param_count(n2));
        for (n = 1; n <= n2; ++n) {
            this.print(profileData, entryInfo.getParamInfo(n), n);
        }
        this.m_out.println(ProfilePrinterErrors.result_type(EntryInfo.resultSetTypeToString(entryInfo.getResultSetType())));
        this.m_out.println(ProfilePrinterErrors.result_name(entryInfo.getResultSetName() + ""));
        n = entryInfo.getResultSetCount();
        this.m_out.println(ProfilePrinterErrors.result_count(n));
        for (int i = 1; i <= n; ++i) {
            this.print(profileData, entryInfo.getResultSetInfo(i), i);
        }
    }

    private void printDescriptor(Object object) {
        this.m_out.println(ProfilePrinterErrors.descriptor(object + ""));
    }

    public void print(ProfileData profileData, TypeInfo typeInfo, int n) {
        Profile profile = profileData.getProfile();
        this.m_out.println(ProfilePrinterErrors.type_info(n, TypeInfo.modeToString(typeInfo.getMode()), typeInfo.getJavaTypeName(), profile.getJavaType(typeInfo).getName()));
        this.m_out.println(ProfilePrinterErrors.type_info(TypeInfo.SQLTypeToString(typeInfo.getSQLType()), typeInfo.getName() + "", typeInfo.getMarkerIndex()));
        this.m_out.flush();
    }

    private static class PrintLog
    extends PrintWriter {
        private StringLog m_log;

        PrintLog(ErrorLog errorLog) {
            this(new StringLog(errorLog));
        }

        private PrintLog(StringLog stringLog) {
            super(stringLog);
            this.m_log = stringLog;
        }

        public void println(String string) {
            super.print(string);
            this.m_log.addLogEntry();
        }
    }

    private static class StringLog
    extends StringWriter {
        private ErrorLog m_log;

        StringLog(ErrorLog errorLog) {
            this.m_log = errorLog;
        }

        public void addLogEntry() {
            this.m_log.addEntry(new SilentInfo(this.toString()));
            this.getBuffer().setLength(0);
        }
    }

    private static class SilentInfo
    extends Info {
        SilentInfo(Object object) {
            super(object);
            this.prefix = null;
        }
    }
}

