/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.RTResultSet;

public class ResultSetIterImpl
implements ResultSetIterator {
    protected RTResultSet resultSet;

    public ResultSetIterImpl(RTResultSet rTResultSet) {
        this.resultSet = rTResultSet;
    }

    public ResultSetIterImpl(RTResultSet rTResultSet, int n) throws SQLException {
        this(rTResultSet);
        try {
            ResultSetIterImpl.checkColumns(rTResultSet, n);
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    public static void checkColumns(RTResultSet rTResultSet, int n) throws SQLException {
        int n2 = rTResultSet.getColumnCount();
        if (n2 != n) {
            RuntimeRefErrors.raise_WRONG_NUM_COLS(n, n2);
        }
    }

    protected int findColumn(String string) throws SQLException {
        try {
            return this.resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return this.resultSet.getJDBCResultSet();
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public boolean endFetch() throws SQLException {
        return !this.resultSet.isValidRow();
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (!this.isClosed()) {
                this.close();
            }
        }
    }
}

