/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.util.Enumeration;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.ClassAnalysis;
import sqlj.semantics.SemanticAnalyzer;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.syntax.ContextElem;
import sqlj.syntax.Elem;
import sqlj.util.ClassNameResolver;

class ContextAnalysis
extends ClassAnalysis
implements SemanticAnalyzer {
    private ContextElem context_elem;

    ContextAnalysis(Elem elem, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        super(elem, semanticAnalyzerFactory);
        if (!(elem instanceof ContextElem)) {
            throw new IllegalArgumentException("ContextAnalysis(elem): not a ContextElem");
        }
        this.context_elem = (ContextElem)elem;
    }

    public boolean prepare() {
        super.prepare();
        this.checkWithClause();
        this.checkInterfaces();
        return !this.unpreparable;
    }

    private void checkWithClause() {
        Enumeration enumeration = this.context_elem.getWithKeywords();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.saf.getPortable()) continue;
            this.logWarning(SemanticErrors.nonStandardContextAttribute(string));
        }
    }

    private void checkInterfaces() {
        Enumeration enumeration = this.context_elem.getInterfaces();
        ClassNameResolver classNameResolver = this.context_elem.getScope().getClassResolver();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                string = classNameResolver.getClass(string).getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!string.equals("sqlj.runtime.ForUpdate")) continue;
            this.logError(SemanticErrors.notConnectionContextInterface(string));
            break;
        }
    }
}

