/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import sqlj.framework.JSClass;
import sqlj.framework.JSMethod;
import sqlj.framework.checker.SQLChecker;
import sqlj.framework.checker.SQLOperation;
import sqlj.framework.checker.SQLToken;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.AnalysisCache;
import sqlj.semantics.BaseAnalysis;
import sqlj.semantics.OfflineCheckerBuilder;
import sqlj.semantics.SQLOperationImpl;
import sqlj.semantics.SemanticAnalyzer;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.semantics.TypeProperties;
import sqlj.syntax.Elem;
import sqlj.syntax.ExecElem;
import sqlj.syntax.IntoBindExpr;
import sqlj.syntax.ReturnBindExpr;
import sqlj.util.ClassDescriptor;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.LValueDescriptor;
import sqlj.util.Parselet;

class ExecAnalysis
extends BaseAnalysis
implements SemanticAnalyzer {
    private SQLOperation m_so;
    private ErrorLog m_el;
    private ExecElem exec_elem;
    private static final String[] dml_tokens = new String[]{"alter", "create", "delete", "drop", "grant", "insert", "modify", "rename", "revoke", "set", "update"};
    private static final Boolean yes = new Boolean(true);
    private static final Hashtable dml = new Hashtable();

    ExecAnalysis(Elem elem, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        super(elem, semanticAnalyzerFactory);
        if (!(elem instanceof ExecElem)) {
            throw new IllegalArgumentException("ExecAnalysis(el): el not ExecElem");
        }
        this.exec_elem = (ExecElem)elem;
        this.m_el = this.exec_elem.getErrorLog();
        this.m_so = null;
    }

    static SQLToken nextToken(Enumeration enumeration) {
        SQLToken sQLToken = null;
        while (enumeration.hasMoreElements() && (sQLToken = (SQLToken)enumeration.nextElement()) != null && sQLToken.tokenType() == 1) {
        }
        return sQLToken;
    }

    private void checkHostItemType(JSClass jSClass, TypeProperties typeProperties, int n, int n2, String string, boolean bl) {
        if (jSClass == null) {
            return;
        }
        if (bl) {
            if (!typeProperties.isCursorColumnType(jSClass)) {
                if (jSClass.isPrimitive()) {
                    this.logError(SemanticErrors.invalidJavaTypeForINTOItem(n2, typeProperties.printJavaType(jSClass)));
                } else if (typeProperties.errorOnUnsupportedTypes()) {
                    this.logError(SemanticErrors.unsupportedJavaTypeForINTOItem(n2, typeProperties.printJavaType(jSClass)));
                } else {
                    this.logWarning(SemanticErrors.unsupportedJavaTypeForINTOItem(n2, typeProperties.printJavaType(jSClass)));
                }
            } else if (this.saf.getPortable() && !this.saf.m_tp.isCursorColumnType(jSClass)) {
                this.logWarning(SemanticErrors.notJdbcHostItem(typeProperties.printJavaType(jSClass), n2, null));
            }
        } else {
            boolean bl2 = typeProperties.isHostItemInType(jSClass);
            boolean bl3 = typeProperties.isHostItemOutType(jSClass);
            if (n == 1 && !bl2 || n == 4 && !bl3 || (n == 2 || n == 0) && (!bl3 || !bl2)) {
                if (jSClass.isPrimitive()) {
                    this.logError(SemanticErrors.invalidJavaTypeForHostItem(n2, typeProperties.printJavaType(jSClass), string));
                } else {
                    String string2 = SemanticErrors.unsupportedJavaTypeForHostItem(n2, typeProperties.printJavaType(jSClass), string);
                    if (bl2 && !bl3) {
                        string2 = string2 + " " + SemanticErrors.notLegalAsOut();
                    } else if (!bl2 && bl3) {
                        string2 = string2 + " " + SemanticErrors.notLegalAsIn();
                    }
                    if (typeProperties.errorOnUnsupportedTypes()) {
                        this.logError(string2);
                    } else {
                        this.logWarning(string2);
                    }
                }
            } else if (this.saf.getPortable()) {
                bl2 = this.saf.m_tp.isHostItemInType(jSClass);
                bl3 = this.saf.m_tp.isHostItemOutType(jSClass);
                if (n == 1 && !bl2 || n == 4 && !bl3 || (n == 2 || n == 0) && (!bl3 || !bl2)) {
                    String string3 = SemanticErrors.notJdbcHostItem(typeProperties.printJavaType(jSClass), n2, string);
                    if (bl2 && !bl3) {
                        string3 = string3 + " " + SemanticErrors.notLegalAsOut();
                    } else if (!bl2 && bl3) {
                        string3 = string3 + " " + SemanticErrors.notLegalAsIn();
                    }
                    this.logWarning(string3);
                }
            }
        }
    }

    public boolean prepare() {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        JSClass jSClass;
        super.prepare();
        String string = "";
        String string2 = "";
        Enumeration enumeration = this.exec_elem.getContextExprList();
        Parselet parselet = null;
        Parselet parselet2 = null;
        if (enumeration.hasMoreElements()) {
            parselet = (Parselet)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                parselet2 = (Parselet)enumeration.nextElement();
                if (enumeration.hasMoreElements()) {
                    this.logError(SemanticErrors.tooManyContexts());
                }
            }
        }
        try {
            if (parselet != null && parselet2 == null && (jSClass = ((ExpressionDescriptor)parselet.getDescriptor()).getReflection()) != JSClass.null_TYPE && JSClass.ExecutionContext_TYPE.isAssignableFrom(jSClass)) {
                parselet2 = parselet;
                parselet = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parselet != null) {
            try {
                jSClass = ((ExpressionDescriptor)parselet.getDescriptor()).getReflection();
                string = jSClass.getName();
                if (JSClass.ConnectionContext_TYPE.isAssignableFrom(jSClass) && jSClass != JSClass.null_TYPE) {
                    if (jSClass == JSClass.ConnectionContext_TYPE) {
                        this.logError(SemanticErrors.notContextSubtype(string));
                    }
                } else {
                    this.logError(SemanticErrors.notContextType(string));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logError(SemanticErrors.notContextType());
            }
        }
        if (parselet2 != null) {
            try {
                jSClass = ((ExpressionDescriptor)parselet2.getDescriptor()).getReflection();
                string2 = jSClass.getName();
                if (!JSClass.ExecutionContext_TYPE.isAssignableFrom(jSClass) || jSClass == JSClass.null_TYPE) {
                    this.logError(SemanticErrors.notExecutorType(string2));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logError(SemanticErrors.notExecutorType());
            }
        }
        jSClass = null;
        if (this.m_so == null && this.exec_elem.getResultExpr() != null) {
            try {
                ExpressionDescriptor expressionDescriptor = (ExpressionDescriptor)this.exec_elem.getResultExpr().getDescriptor();
                jSClass = expressionDescriptor.getReflection();
                if (!(expressionDescriptor instanceof LValueDescriptor)) {
                    this.logError(SemanticErrors.resultMustBeLvalue());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logError(SemanticErrors.lhsNotJavaType());
                jSClass = TypeProperties.Invalid_TYPE;
            }
        }
        if (this.m_so == null) {
            this.m_so = new SQLOperationImpl(this.m_el, this.exec_elem.getSQL(), jSClass, this.saf);
        }
        if (this.m_so == null) {
            throw new IllegalArgumentException("ExecAnalysis.prepare(): SQLOperation is null");
        }
        boolean bl = false;
        for (int i = 1; i <= this.m_so.hostItemCount(); ++i) {
            object6 = this.m_so.hostItem(i).getHostItemType();
            if (object6 != null) continue;
            this.logError(SemanticErrors.invalidJavaTypeForHostItem(i, this.m_so.hostItem(i).getHostItemName()));
            bl = true;
        }
        Enumeration enumeration2 = this.m_so.tokens();
        object6 = ExecAnalysis.nextToken(enumeration2);
        AnalysisCache analysisCache = null;
        String string3 = null;
        String string4 = null;
        int[] nArray = null;
        boolean bl2 = false;
        int n2 = this.m_el.warningCount();
        String string5 = null;
        if (this.saf.getCacheing()) {
            String string6;
            if (this.saf.cachedAnalyses == null) {
                this.saf.readCache();
            }
            if ((string5 = this.saf.getURL(string)) == null && (string5 = this.saf.getURL()) == null) {
                string5 = "";
            }
            if ((string6 = this.saf.getUser(string)) == null && (string6 = this.saf.getUser()) == null) {
                string6 = "";
            }
            string5 = string6 + "@" + string5;
            if (!bl) {
                string3 = AnalysisCache.key(this.m_so, string5, this.saf);
                string4 = this.m_so.getSQLString();
                nArray = new int[this.m_so.hostItemCount()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.m_so.hostItem(i + 1).getHostItemMode();
                }
            }
        }
        SQLChecker sQLChecker = null;
        if (object6 != null && object6.tokenText().equalsIgnoreCase("FETCH")) {
            this.m_so.setOperationCode(1022);
            object6 = ExecAnalysis.nextToken(enumeration2);
            if (object6 == null) {
                this.logError(SemanticErrors.expectCursorHostItem());
            } else if (object6.tokenType() != 3) {
                this.logError(SemanticErrors.expectCursorHostItem(object6.tokenText()));
            } else {
                object6 = ExecAnalysis.nextToken(enumeration2);
                if (object6 != null && object6.tokenText().equals(";")) {
                    object6 = ExecAnalysis.nextToken(enumeration2);
                }
                if (object6 != null) {
                    this.logError(SemanticErrors.expectEndOfFetch(object6.tokenText()));
                } else if (this.m_so.hostItemCount() != 1) {
                    this.logError(SemanticErrors.internalError("ExecAnalysis-1"));
                } else {
                    object5 = this.m_so.hostItem(1).getHostItemType();
                    this.m_so.hostItem(1).setHostItemMode(1);
                    if (object5 == null) {
                        this.logError(SemanticErrors.invalidFetchCursor());
                    } else if (JSClass.PositionedIterator_TYPE.isAssignableFrom((JSClass)object5)) {
                        Object object7;
                        JSClass jSClass2;
                        object4 = null;
                        int n3 = 0;
                        object3 = ((JSClass)object5).getDeclaredMethods();
                        object4 = new JSClass[((JSMethod[])object3).length];
                        for (int i = 0; i < ((JSMethod[])object3).length; ++i) {
                            String string7 = object3[i].getName();
                            int n4 = object3[i].getParameterTypes().length;
                            jSClass2 = object3[i].getReturnType();
                            if (n4 > 0 || !string7.startsWith("getCol")) break;
                            object7 = Integer.valueOf(string7.substring(6));
                            n = 0;
                            if (object7 != null) {
                                n = (Integer)object7;
                            }
                            if (n < 1 || n > ((Object)object3).length) {
                                this.logError(SemanticErrors.internalError("ExecAnalysis-2"));
                            }
                            if (n > n3) {
                                n3 = n;
                            }
                            object4[n - 1] = jSClass2;
                        }
                        object3 = this.exec_elem.getSQL().getBindExprs();
                        try {
                            object3.nextElement();
                        }
                        catch (Exception exception) {
                            this.logError(SemanticErrors.noIntoAfterFetch());
                        }
                        object2 = null;
                        int n5 = 0;
                        try {
                            object2 = (IntoBindExpr)object3.nextElement();
                            object3 = ((IntoBindExpr)object2).getParselets();
                            object = new TypeProperties();
                            ((TypeProperties)object).setErrorLog(this.elem.getErrorLog());
                            while (object3.hasMoreElements()) {
                                ++n5;
                                jSClass2 = null;
                                try {
                                    object7 = ((Parselet)object3.nextElement()).getDescriptor();
                                    if (object7 != null && object7 instanceof ExpressionDescriptor) {
                                        jSClass2 = ((ExpressionDescriptor)object7).getReflection();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (object4 != null && n5 > n3) {
                                    this.logError(SemanticErrors.tooManyINTOItems(n5, n3));
                                }
                                if (jSClass2 == null) {
                                    this.logError(SemanticErrors.invalidJavaTypeForINTOItem(n5));
                                } else if (!JSClass.ResultSet_TYPE.hasAccessTo(jSClass2)) {
                                    this.logError(SemanticErrors.inaccessibleJavaTypeForINTOItem(n5, ((TypeProperties)object).printJavaType(jSClass2)));
                                }
                                if (object4 == null || n5 > n3 || jSClass2 == null || object4[n5 - 1] == jSClass2) continue;
                                this.logError(SemanticErrors.intoTypeMismatch(n5, object4[n5 - 1].getName(), jSClass2.getName()));
                            }
                        }
                        catch (Exception exception) {
                            this.logError(SemanticErrors.expectINTOBindExpression());
                        }
                        if (object4 != null && n3 > n5) {
                            object = new StringBuffer();
                            for (int i = n5; i < n3; ++i) {
                                ((StringBuffer)object).append(object4[i].getName());
                                if (i >= n3 - 1) continue;
                                ((StringBuffer)object).append(", ");
                            }
                            if (n3 - n5 == 1) {
                                this.logError(SemanticErrors.missingIntoElements(((StringBuffer)object).toString()));
                            } else {
                                this.logError(SemanticErrors.missingIntoElements(n3 - n5, ((StringBuffer)object).toString()));
                            }
                        }
                    } else {
                        this.logError(SemanticErrors.invalidFetchCursor(((JSClass)object5).getName()));
                    }
                    if (string != null && !string.equals("")) {
                        this.logWarning(SemanticErrors.contextIgnored(string));
                    }
                }
            }
        } else if (object6 != null && object6.tokenText().equalsIgnoreCase("CAST")) {
            this.m_so.setOperationCode(18);
            this.m_so.setResultParamIndex(1);
            object6 = ExecAnalysis.nextToken(enumeration2);
            if (object6 == null) {
                this.logError(SemanticErrors.expectCastResultSet(null));
            } else if (object6.tokenType() != 3) {
                this.logError(SemanticErrors.expectCastResultSet(object6.tokenText()));
            } else {
                this.m_so.hostItem(1).setHostItemMode(1);
                object5 = this.m_so.hostItem(1).getHostItemType();
                if (object5 == null) {
                    this.logError(SemanticErrors.invalidCastType(null));
                } else if (!JSClass.ResultSet_TYPE.isAssignableFrom((JSClass)object5)) {
                    this.logError(SemanticErrors.invalidCastType(((JSClass)object5).getName()));
                }
                object6 = ExecAnalysis.nextToken(enumeration2);
                if (object6 != null) {
                    this.logError(SemanticErrors.expectEndOfCast(object6.tokenText()));
                }
            }
            object5 = this.m_so.getResultType();
            if (object5 == null) {
                this.logError(SemanticErrors.expectCastAssignmentToIterator(null));
            } else if (object5 != TypeProperties.Invalid_TYPE) {
                if (!this.saf.m_tp.isCursorType((JSClass)object5)) {
                    this.logError(SemanticErrors.expectCastAssignmentToIterator(((JSClass)object5).getName()));
                } else if (!JSClass.ResultSet_TYPE.hasAccessTo((JSClass)object5)) {
                    this.logError(SemanticErrors.returnTypeNotVisible(this.saf.m_tp.printJavaType((JSClass)object5)));
                }
            }
        } else if (string3 != null && (analysisCache = (AnalysisCache)this.saf.cachedAnalyses.get(string3)) != null) {
            this.logInfo(SemanticErrors.reusingCache());
            analysisCache.replay(this.m_so, this.exec_elem.getSQL());
        } else if (!bl) {
            object5 = this.saf.m_cm.getConnection(string, this.m_el);
            sQLChecker = this.saf.m_cm.getSQLChecker(string, this.m_el);
            if (sQLChecker != null) {
                sQLChecker.describeSQLOperation(this.m_el, (Connection)object5, this.m_so);
            }
        }
        if (analysisCache == null) {
            if (jSClass != null && this.m_so.getOperationCode() == 2 && JSClass.ForUpdate_TYPE.isAssignableFrom(jSClass)) {
                this.m_so.setOperationCode(7);
            }
            if (this.m_so.getOperationCode() == 2 && jSClass != null && this.m_so.getResultType() == JSClass.ResultSetIterator_TYPE) {
                this.m_so.setOperationCode(19);
            }
            if (jSClass == null && this.m_so.getResultType() != null) {
                int n6 = this.m_so.getOperationCode();
                if (n6 == 2) {
                    this.m_so.setOperationCode(8);
                } else if (n6 < 1024 && n6 != 1022 && n6 != 1023) {
                    this.m_el.addEntry(new JSError(SemanticErrors.intoListRestriction()));
                }
            }
            int n7 = this.m_so.getOperationCode();
            object4 = null;
            Enumeration enumeration3 = this.m_so.tokens();
            object3 = ExecAnalysis.nextToken(enumeration3);
            while (object3 != null && object3.tokenText().equals("(")) {
                object3 = ExecAnalysis.nextToken(enumeration3);
            }
            object4 = object3 == null || object3.tokenText() == null ? "<EMPTY-STATEMENT>" : object3.tokenText().toLowerCase();
            if (!this.unpreparable && this.m_el.errorCount() == 0) {
                boolean bl3;
                if (n7 == 1023) {
                    if (object4.equals("select")) {
                        this.m_so.setOperationCode(2);
                    } else if (dml.get(object4) != null) {
                        this.m_so.setOperationCode(3);
                    }
                    n7 = this.m_so.getOperationCode();
                    if (n7 == 1023) {
                        this.logError(SemanticErrors.cannotCategorize());
                    } else {
                        this.logWarning(SemanticErrors.checkerDidNotCategorize());
                    }
                }
                if (n7 != 1023) {
                    for (int i = 1; i <= this.m_so.hostItemCount(); ++i) {
                        if (this.m_so.hostItem(i).getHostItemMode() != 0) continue;
                        if (n7 != 4 && n7 != 5 && n7 != 9) {
                            this.logWarning(SemanticErrors.unassignedAssumeInMode(i, this.m_so.hostItem(i).getHostItemName()));
                            this.m_so.hostItem(i).setHostItemMode(1);
                            continue;
                        }
                        this.logError(SemanticErrors.unassignedMode(i, this.m_so.hostItem(i).getHostItemName()));
                    }
                }
                boolean bl4 = bl3 = this.exec_elem.getResultExpr() != null;
                if (n7 == 2 || n7 == 7 || n7 == 19 || n7 == 5) {
                    if (!bl3) {
                        if (n7 == 2 || n7 == 7 || n7 == 19) {
                            this.logWarning(SemanticErrors.unassignedQueryValue());
                        } else {
                            this.logWarning(SemanticErrors.unassignedFunctionValue());
                        }
                    } else {
                        if (n7 == 2 || n7 == 7) {
                            this.exec_elem.getSQL().insertBindExprAt(ReturnBindExpr.QUERY_RETURN, 1);
                        } else if (n7 == 19) {
                            this.exec_elem.getSQL().insertBindExprAt(ReturnBindExpr.COLUMN_RETURN, this.m_so.hostItemCount() + 1);
                        } else {
                            this.exec_elem.getSQL().insertBindExprAt(ReturnBindExpr.COLUMN_RETURN, 1);
                        }
                        bl2 = true;
                        if (n7 == 2 || n7 == 19 || n7 == 7) {
                            object3 = this.m_so.getResultType();
                            if (object3 == null) {
                                this.logError(SemanticErrors.internalError("ExecAnalysis-4"));
                            } else if (object3 != TypeProperties.Invalid_TYPE) {
                                if (this.saf.m_tp.isCursorType((JSClass)object3)) {
                                    object2 = null;
                                    try {
                                        object2 = ((ClassDescriptor)this.exec_elem.getScope().getEnclosingClass().getDescriptor()).getReflection();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (object2 != null && !((JSClass)object2).hasAccessTo((JSClass)object3)) {
                                        this.logError(SemanticErrors.returnTypeNotVisible(this.saf.m_tp.printJavaType((JSClass)object3)));
                                    }
                                } else {
                                    this.logError(SemanticErrors.returnTypeNotACursor(this.saf.m_tp.printJavaType((JSClass)object3)));
                                }
                            }
                        }
                    }
                } else if (bl3 && n7 != 1023 && n7 != 18 && n7 != 4 && n7 < 1024) {
                    this.logError(SemanticErrors.noReturn());
                }
                if (n7 == 5) {
                    object3 = this.m_so.tokens();
                    object2 = ExecAnalysis.nextToken((Enumeration)object3);
                    SQLToken sQLToken = ExecAnalysis.nextToken((Enumeration)object3);
                    object = ExecAnalysis.nextToken((Enumeration)object3);
                    if (object2 != null && object2.tokenText().equals("{")) {
                        if (sQLToken != null && sQLToken.tokenText().equals("?")) {
                            SQLToken sQLToken2 = ExecAnalysis.nextToken((Enumeration)object3);
                            if (object == null || !object.tokenText().equals("=") || sQLToken2 == null || !sQLToken2.tokenText().equals("call")) {
                                this.logError(SemanticErrors.expectedOdbcFunction());
                            }
                        } else if (sQLToken != null && sQLToken.tokenText().equalsIgnoreCase("call")) {
                            String string8 = "{ ? = " + this.exec_elem.getSQL().getSQL().substring(sQLToken.tokenPosition());
                            this.exec_elem.getSQL().setSQL(string8);
                        } else {
                            this.logError(SemanticErrors.expectedOdbcFunction());
                        }
                    } else {
                        String string9 = "{ ? = call " + this.exec_elem.getSQL().getSQL() + "\n}";
                        this.exec_elem.getSQL().setSQL(string9);
                    }
                }
                if (n7 == 4) {
                    object3 = this.m_so.tokens();
                    object2 = ExecAnalysis.nextToken((Enumeration)object3);
                    SQLToken sQLToken = ExecAnalysis.nextToken((Enumeration)object3);
                    if (object2 != null && object2.tokenText().equals("{")) {
                        if (sQLToken == null || !sQLToken.tokenText().equals("call")) {
                            this.logError(SemanticErrors.expectedOdbcFunction());
                        }
                    } else {
                        object = "{ call " + this.exec_elem.getSQL().getSQL() + "\n}";
                        this.exec_elem.getSQL().setSQL((String)object);
                    }
                }
            } else {
                this.unpreparable = true;
            }
            int n8 = 0;
            if (object4 != null && (object4.equals("update") || object4.equals("delete"))) {
                object3 = this.m_so.tokens();
                object2 = ExecAnalysis.nextToken((Enumeration)object3);
                while (object2 != null) {
                    if (object2.tokenText().equalsIgnoreCase("WHERE") && (object2 = ExecAnalysis.nextToken((Enumeration)object3)) != null && object2.tokenText().equalsIgnoreCase("CURRENT")) {
                        object2 = ExecAnalysis.nextToken((Enumeration)object3);
                        if (object2 == null || !object2.tokenText().equalsIgnoreCase("OF")) {
                            this.logError("Expected: WHERE CURRENT OF :hostvar. Found: WHERE CURRENT " + (object2 == null ? "" : object2.tokenText()) + " ...");
                        } else {
                            object2 = ExecAnalysis.nextToken((Enumeration)object3);
                            if (object2 == null || object2.tokenType() != 3) {
                                this.logError("Expected: WHERE CURRENT OF :hostvar. Found: WHERE CURRENT OF " + (object2 == null ? "" : object2.tokenText()) + " ...");
                            } else {
                                this.logInfo("[Found WHERE CURRENT OF as host item#" + ++n8 + " at position " + object2.tokenPosition() + "]");
                                this.exec_elem.getSQL().setDescriptor(new Integer(n8));
                                JSClass jSClass3 = this.m_so.hostItem(n8).getHostItemType();
                                if (jSClass3 == null) {
                                    this.logError("Invalid Java type in cursor for WHERE CURRENT OF");
                                    break;
                                }
                                if (!JSClass.ForUpdate_TYPE.isAssignableFrom(jSClass3) && jSClass3 != JSClass.ForUpdate_TYPE) {
                                    this.logError("Cursor for WHERE CURRENT OF has illegal type " + jSClass3.getName() + ". It must implement ForUpdate.");
                                    break;
                                }
                                this.m_so.setOperationCode(6);
                                break;
                            }
                        }
                    }
                    if (object2 == null) continue;
                    if (object2.tokenType() == 3) {
                        ++n8;
                    }
                    object2 = ExecAnalysis.nextToken((Enumeration)object3);
                }
            }
            object3 = null;
            object3 = sQLChecker != null && sQLChecker instanceof OfflineCheckerBuilder ? ((OfflineCheckerBuilder)sQLChecker).m_tp : this.saf.m_tp;
            if (this.m_so.getOperationCode() != 1022) {
                for (int i = 1; i <= this.m_so.hostItemCount(); ++i) {
                    this.checkSQLJPrefix(this.m_so.hostItem(i).getHostItemName());
                    JSClass jSClass4 = this.m_so.hostItem(i).getHostItemType();
                    if (jSClass4 == null) break;
                    int n9 = this.m_so.hostItem(i).getHostItemMode();
                    if (n9 != 1 && !JSClass.ResultSet_TYPE.hasAccessTo(jSClass4)) {
                        this.logError(SemanticErrors.inaccessibleJavaTypeForHostItem(i, ((TypeProperties)object3).printJavaType(jSClass4), this.m_so.hostItem(i).getHostItemName()));
                    }
                    if (i == n8) break;
                    if (this.m_so.getOperationCode() >= 1024 || this.m_so.getOperationCode() == 18) continue;
                    this.checkHostItemType(jSClass4, (TypeProperties)object3, n9, i, this.m_so.hostItem(i).getHostItemName(), false);
                }
            }
            if (this.saf.getPortable() && this.m_so.getOperationCode() == 9) {
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                for (int i = 1; i <= this.m_so.hostItemCount(); ++i) {
                    String string10 = this.m_so.hostItem(i).getHostItemName();
                    if (string10 == null) continue;
                    int n10 = -1;
                    n = this.m_so.hostItem(i).getHostItemMode();
                    if (n == 1) {
                        if (hashtable2.get(string10) != null) {
                            n10 = (Integer)hashtable2.get(string10);
                        }
                        hashtable.put(string10, new Integer(i));
                    } else if (n == 4 || n == 2) {
                        if (hashtable2.get(string10) != null) {
                            n10 = (Integer)hashtable2.get(string10);
                        } else if (hashtable.get(string10) != null) {
                            n10 = (Integer)hashtable.get(string10);
                        }
                        hashtable2.put(string10, new Integer(i));
                    }
                    if (n10 < 0) continue;
                    this.logWarning(SemanticErrors.repeatedHostItem(string10, n10, i));
                }
            }
            if (this.m_so.getOperationCode() == 8) {
                JSClass jSClass5 = this.m_so.getResultType();
                JSMethod[] jSMethodArray = jSClass5.getDeclaredMethods();
                for (int i = 0; i < jSMethodArray.length; ++i) {
                    String string11 = jSMethodArray[i].getName();
                    int n11 = jSMethodArray[i].getParameterTypes().length;
                    if (n11 > 0) break;
                    n = 0;
                    if (!string11.startsWith("getCol")) break;
                    try {
                        n = Integer.parseInt(string11.substring(6));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JSClass jSClass6 = jSMethodArray[i].getReturnType();
                    if (n <= 0) continue;
                    this.checkHostItemType(jSClass6, (TypeProperties)object3, 4, n, null, true);
                }
            }
            if (string3 != null && !bl && !this.unpreparable && n2 == this.m_el.warningCount() && this.m_so.getOperationCode() != 1022) {
                analysisCache = new AnalysisCache(this.m_so, string5, string4, nArray, bl2, this.saf);
                this.saf.cachedAnalyses.put(string3, analysisCache);
                this.logInfo(SemanticErrors.preserveCheckingInfo());
            }
        }
        if (!this.unpreparable && this.m_el.errorCount() > 0) {
            this.unpreparable = true;
        }
        return !this.unpreparable;
    }

    static {
        for (int i = 0; i < dml_tokens.length; ++i) {
            dml.put(dml_tokens[i], yes);
        }
    }
}

