/*
 * Decompiled with CFR 0.152.
 */
package sqlj.syntax;

import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.error.ErrorLog;
import sqlj.javac.ExpressionNode;
import sqlj.syntax.Elem;
import sqlj.syntax.SQLUnit;
import sqlj.util.Parselet;

public class ExecElem
extends Elem {
    Vector contextList;
    Parselet resultExpr;
    SQLUnit sqlUnit;

    ExecElem(ErrorLog errorLog, Vector vector, Parselet parselet, SQLUnit sQLUnit) {
        super(errorLog);
        if (vector == null) {
            vector = new Vector();
        }
        if (sQLUnit == null) {
            throw new NullPointerException("Missing SQLUnit");
        }
        this.contextList = vector;
        this.resultExpr = parselet;
        this.sqlUnit = sQLUnit;
    }

    ExecElem(ErrorLog errorLog, Vector vector, SQLUnit sQLUnit) {
        this(errorLog, vector, null, sQLUnit);
    }

    public Enumeration getContextExprList() {
        return this.contextList.elements();
    }

    public Parselet getResultExpr() {
        return this.resultExpr;
    }

    public SQLUnit getSQL() {
        return this.sqlUnit;
    }

    public void setScope(Parselet parselet) {
        super.setScope(parselet);
        Enumeration enumeration = this.getContextExprList();
        while (enumeration.hasMoreElements()) {
            ((Parselet)enumeration.nextElement()).setScope(parselet);
        }
        if (this.resultExpr != null) {
            this.resultExpr.setScope(parselet);
        }
        this.sqlUnit.setScope(parselet);
    }

    void getTextTo(StringBuffer stringBuffer) {
        stringBuffer.append("#sql ");
        if (this.contextList != null && !this.contextList.isEmpty()) {
            stringBuffer.append("[");
            Enumeration enumeration = this.getContextExprList();
            while (true) {
                ((ExpressionNode)enumeration.nextElement()).getTextTo(stringBuffer);
                if (!enumeration.hasMoreElements()) break;
                stringBuffer.append(",");
            }
            stringBuffer.append("] ");
        }
        if (this.resultExpr != null) {
            ((ExpressionNode)this.resultExpr).getTextTo(stringBuffer);
            stringBuffer.append(" = ");
        }
        stringBuffer.append("{ ");
        this.sqlUnit.getTextTo(stringBuffer);
        stringBuffer.append(" };");
    }
}

