/*
 * Decompiled with CFR 0.152.
 */
package sqlj.translator;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import sqlj.codegen.ParseletFactory;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.framework.options.HasOptions;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.PropertyList;
import sqlj.javac.JavaParserSub;
import sqlj.mesg.TranslatorErrors;
import sqlj.translator.FileTranslationUnit;
import sqlj.translator.Main;
import sqlj.translator.TranslationUnit;
import sqlj.util.Disposable;
import sqlj.util.ParseContext;
import sqlj.util.ParseException;
import sqlj.util.Parselet;
import sqlj.util.TranslationContext;
import sqlj.util.UnitDescriptor;

public class Translator
implements HasOptions {
    private Disposable.Disposer disposer;
    private TranslationContext xlatCtx;
    private ParseletFactory parseletFactory;
    private ErrorLog m_log = null;
    private JavaParserSub m_parser = null;
    private Vector m_units = new Vector();
    private Vector m_parselets = new Vector();
    private int m_numUnitsProcessed = 0;

    public Translator(TranslationOptionsQuery translationOptionsQuery) {
        this.disposer = new Disposable.Disposer();
        this.xlatCtx = new TranslationContext(this.disposer, translationOptionsQuery);
        this.parseletFactory = new ParseletFactory(this.xlatCtx);
    }

    public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
        this.parseletFactory.setOptions(propertyList, errorLog);
        this.m_log = errorLog;
        try {
            this.m_parser = new JavaParserSub(this.parseletFactory);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidOptionException();
        }
    }

    public String[][] getOptionInfo() {
        return this.parseletFactory.getOptionInfo();
    }

    public void addUnit(TranslationUnit translationUnit) throws ParseException {
        boolean bl = false;
        ParseContext parseContext = null;
        try {
            parseContext = translationUnit.getInput();
            if (Main.immediateStream != null) {
                Main.immediateStream.write(TranslatorErrors.readingFile(parseContext.getFileName()) + "\n");
                Main.immediateStream.flush();
            }
            Parselet parselet = this.m_parser.parseSQLJUnit(parseContext);
            try {
                parseContext.getReader().close();
                if (translationUnit instanceof FileTranslationUnit) {
                    ((FileTranslationUnit)translationUnit).deleteInput();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            UnitDescriptor unitDescriptor = (UnitDescriptor)parselet.getDescriptor();
            translationUnit.setPackageName(unitDescriptor.getPackageName());
            this.m_parselets.addElement(parselet);
            this.m_units.addElement(translationUnit);
        }
        catch (ParseException parseException) {
            bl = true;
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (Main.immediateStream != null && parseContext != null) {
            parseContext.getErrorLogger().printLog(Main.immediateStream);
            Main.immediateStream.flush();
        }
        if (bl) {
            try {
                translationUnit.translationComplete(false);
            }
            catch (IOException iOException) {}
            finally {
                throw new ParseException();
            }
        }
    }

    public boolean translate() {
        return this.translate(true);
    }

    public boolean translate(boolean bl) {
        boolean bl2 = true;
        while (this.m_numUnitsProcessed < this.m_units.size()) {
            Parselet parselet = (Parselet)this.m_parselets.elementAt(this.m_numUnitsProcessed);
            TranslationUnit translationUnit = (TranslationUnit)this.m_units.elementAt(this.m_numUnitsProcessed);
            if (Main.immediateStream != null) {
                try {
                    Main.immediateStream.write(TranslatorErrors.translatingFile(translationUnit.getInput().getFileName()) + "\n");
                    Main.immediateStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                bl2 = parselet.generate(translationUnit.getOutput()) && bl2;
            }
            catch (IOException iOException) {
                this.m_log.addEntry(new JSError(TranslatorErrors.output_io_error(iOException.getMessage())));
                bl2 = false;
            }
            try {
                translationUnit.translationComplete(bl2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Main.immediateStream != null) {
                try {
                    translationUnit.getInput().getErrorLogger().printLog(Main.immediateStream);
                    Main.immediateStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++this.m_numUnitsProcessed;
        }
        if (bl) {
            this.disposer.dispose();
        }
        return bl2;
    }
}

