/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt;

import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSymbol;
import com.ibm.wala.cast.tree.impl.CAstOperator;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JDT2CAstUtils {
    public static Collection<CAstQualifier> mapModifiersToQualifiers(int modifiers, boolean isInterface, boolean isAnnotation) {
        LinkedHashSet<CAstQualifier> quals = new LinkedHashSet<CAstQualifier>();
        if (isInterface) {
            quals.add(CAstQualifier.INTERFACE);
        }
        if (isAnnotation) {
            quals.add(CAstQualifier.ANNOTATION);
        }
        if ((modifiers & 0x400) != 0) {
            quals.add(CAstQualifier.ABSTRACT);
        }
        if ((modifiers & 0x10) != 0) {
            quals.add(CAstQualifier.FINAL);
        }
        if ((modifiers & 0x100) != 0) {
            quals.add(CAstQualifier.NATIVE);
        }
        if ((modifiers & 2) != 0) {
            quals.add(CAstQualifier.PRIVATE);
        }
        if ((modifiers & 4) != 0) {
            quals.add(CAstQualifier.PROTECTED);
        }
        if ((modifiers & 1) != 0) {
            quals.add(CAstQualifier.PUBLIC);
        }
        if ((modifiers & 8) != 0) {
            quals.add(CAstQualifier.STATIC);
        }
        if ((modifiers & 0x800) != 0) {
            quals.add(CAstQualifier.STRICTFP);
        }
        if ((modifiers & 0x20) != 0) {
            quals.add(CAstQualifier.SYNCHRONIZED);
        }
        if ((modifiers & 0x80) != 0) {
            quals.add(CAstQualifier.TRANSIENT);
        }
        if ((modifiers & 0x40) != 0) {
            quals.add(CAstQualifier.VOLATILE);
        }
        return quals;
    }

    public static CAstOperator mapAssignOperator(Assignment.Operator op) {
        if (op == Assignment.Operator.PLUS_ASSIGN) {
            return CAstOperator.OP_ADD;
        }
        if (op == Assignment.Operator.BIT_AND_ASSIGN) {
            return CAstOperator.OP_BIT_AND;
        }
        if (op == Assignment.Operator.BIT_OR_ASSIGN) {
            return CAstOperator.OP_BIT_OR;
        }
        if (op == Assignment.Operator.BIT_XOR_ASSIGN) {
            return CAstOperator.OP_BIT_XOR;
        }
        if (op == Assignment.Operator.DIVIDE_ASSIGN) {
            return CAstOperator.OP_DIV;
        }
        if (op == Assignment.Operator.REMAINDER_ASSIGN) {
            return CAstOperator.OP_MOD;
        }
        if (op == Assignment.Operator.TIMES_ASSIGN) {
            return CAstOperator.OP_MUL;
        }
        if (op == Assignment.Operator.LEFT_SHIFT_ASSIGN) {
            return CAstOperator.OP_LSH;
        }
        if (op == Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN) {
            return CAstOperator.OP_RSH;
        }
        if (op == Assignment.Operator.MINUS_ASSIGN) {
            return CAstOperator.OP_SUB;
        }
        if (op == Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN) {
            return CAstOperator.OP_URSH;
        }
        Assertions.UNREACHABLE((String)"Unknown assignment operator");
        return null;
    }

    protected static CAstOperator mapBinaryOpcode(InfixExpression.Operator operator) {
        if (operator == InfixExpression.Operator.PLUS) {
            return CAstOperator.OP_ADD;
        }
        if (operator == InfixExpression.Operator.AND) {
            return CAstOperator.OP_BIT_AND;
        }
        if (operator == InfixExpression.Operator.OR) {
            return CAstOperator.OP_BIT_OR;
        }
        if (operator == InfixExpression.Operator.XOR) {
            return CAstOperator.OP_BIT_XOR;
        }
        if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
            return CAstOperator.OP_REL_AND;
        }
        if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
            return CAstOperator.OP_REL_OR;
        }
        if (operator == InfixExpression.Operator.DIVIDE) {
            return CAstOperator.OP_DIV;
        }
        if (operator == InfixExpression.Operator.EQUALS) {
            return CAstOperator.OP_EQ;
        }
        if (operator == InfixExpression.Operator.GREATER_EQUALS) {
            return CAstOperator.OP_GE;
        }
        if (operator == InfixExpression.Operator.GREATER) {
            return CAstOperator.OP_GT;
        }
        if (operator == InfixExpression.Operator.LESS_EQUALS) {
            return CAstOperator.OP_LE;
        }
        if (operator == InfixExpression.Operator.LESS) {
            return CAstOperator.OP_LT;
        }
        if (operator == InfixExpression.Operator.REMAINDER) {
            return CAstOperator.OP_MOD;
        }
        if (operator == InfixExpression.Operator.TIMES) {
            return CAstOperator.OP_MUL;
        }
        if (operator == InfixExpression.Operator.NOT_EQUALS) {
            return CAstOperator.OP_NE;
        }
        if (operator == InfixExpression.Operator.LEFT_SHIFT) {
            return CAstOperator.OP_LSH;
        }
        if (operator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
            return CAstOperator.OP_RSH;
        }
        if (operator == InfixExpression.Operator.MINUS) {
            return CAstOperator.OP_SUB;
        }
        if (operator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
            return CAstOperator.OP_URSH;
        }
        Assertions.UNREACHABLE((String)"Java2CAstTranslator.JavaTranslatingVisitorImpl.mapBinaryOpcode(): unrecognized binary operator.");
        return null;
    }

    public static boolean isLongOrLess(ITypeBinding type) {
        String t = type.getBinaryName();
        return t.equals("C") || t.equals("B") || t.equals("S") || t.equals("I") || t.equals("J");
    }

    public static Object defaultValueForType(ITypeBinding type) {
        if (JDT2CAstUtils.isLongOrLess(type)) {
            return 0;
        }
        if (type.getBinaryName().equals("D") || type.getBinaryName().equals("F")) {
            return 0.0;
        }
        return CAstSymbol.NULL_DEFAULT_VALUE;
    }

    public static ITypeBinding promoteTypes(ITypeBinding t1, ITypeBinding t2, AST ast) {
        ITypeBinding doble = ast.resolveWellKnownType("double");
        if (t1.equals(doble) || t2.equals(doble)) {
            return doble;
        }
        ITypeBinding flotando = ast.resolveWellKnownType("float");
        if (t1.equals(flotando) || t2.equals(flotando)) {
            return flotando;
        }
        ITypeBinding largo = ast.resolveWellKnownType("long");
        if (t1.equals(largo) || t2.equals(largo)) {
            return largo;
        }
        return ast.resolveWellKnownType("int");
    }

    public static ITypeBinding getDeclaringClassOfNode(ASTNode n) {
        for (ASTNode current = n; current != null; current = current.getParent()) {
            if (current instanceof TypeDeclaration) {
                return ((TypeDeclaration)current).resolveBinding();
            }
            if (current instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)current).resolveBinding();
            }
            if (!(current instanceof EnumDeclaration)) continue;
            return ((EnumDeclaration)current).resolveBinding();
        }
        Assertions.UNREACHABLE((String)"Couldn't find declaring class of node");
        return null;
    }

    static String anonTypeName(ITypeBinding ct) {
        String binName = ct.getBinaryName();
        String dollarSignNumber = binName.substring(binName.indexOf(36));
        return "<anonymous subclass of " + ct.getSuperclass().getBinaryName() + '>' + dollarSignNumber;
    }

    public static ITypeBinding getErasedType(ITypeBinding returnType, AST ast) {
        if (returnType.isTypeVariable() || returnType.isCapture()) {
            return JDT2CAstUtils.getTypesVariablesBase(returnType, ast);
        }
        return returnType.getTypeDeclaration();
    }

    public static ITypeBinding getTypesVariablesBase(ITypeBinding returnType, AST ast) {
        assert (returnType.isTypeVariable() || returnType.isCapture());
        if (returnType.getTypeBounds().length > 0) {
            return returnType.getTypeBounds()[0];
        }
        return ast.resolveWellKnownType("java.lang.Object");
    }

    public static InfixExpression.Operator mapAssignOperatorToInfixOperator(Assignment.Operator op) {
        if (op == Assignment.Operator.PLUS_ASSIGN) {
            return InfixExpression.Operator.PLUS;
        }
        if (op == Assignment.Operator.BIT_AND_ASSIGN) {
            return InfixExpression.Operator.AND;
        }
        if (op == Assignment.Operator.BIT_OR_ASSIGN) {
            return InfixExpression.Operator.OR;
        }
        if (op == Assignment.Operator.BIT_XOR_ASSIGN) {
            return InfixExpression.Operator.XOR;
        }
        if (op == Assignment.Operator.DIVIDE_ASSIGN) {
            return InfixExpression.Operator.DIVIDE;
        }
        if (op == Assignment.Operator.REMAINDER_ASSIGN) {
            return InfixExpression.Operator.REMAINDER;
        }
        if (op == Assignment.Operator.TIMES_ASSIGN) {
            return InfixExpression.Operator.TIMES;
        }
        if (op == Assignment.Operator.LEFT_SHIFT_ASSIGN) {
            return InfixExpression.Operator.LEFT_SHIFT;
        }
        if (op == Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN) {
            return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
        }
        if (op == Assignment.Operator.MINUS_ASSIGN) {
            return InfixExpression.Operator.MINUS;
        }
        if (op == Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN) {
            return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
        }
        Assertions.UNREACHABLE((String)"Unknown assignment operator");
        return null;
    }

    private static void getMethodInClassOrSuperclass(IMethodBinding met, ITypeBinding klass, boolean superclassonly, HashMap<ITypeBinding, IMethodBinding> overridden) {
        if (!superclassonly) {
            for (IMethodBinding iMethodBinding : klass.getDeclaredMethods()) {
                if (!met.overrides(iMethodBinding)) continue;
                overridden.put(iMethodBinding.getMethodDeclaration().getReturnType(), iMethodBinding.getMethodDeclaration());
                break;
            }
        }
        for (IMethodBinding iMethodBinding : klass.getInterfaces()) {
            JDT2CAstUtils.getMethodInClassOrSuperclass(met, (ITypeBinding)iMethodBinding, false, overridden);
        }
        ITypeBinding superclass = klass.getSuperclass();
        if (superclass != null) {
            JDT2CAstUtils.getMethodInClassOrSuperclass(met, superclass, false, overridden);
        }
    }

    public static Collection<IMethodBinding> getOverriddenMethod(IMethodBinding met) {
        HashMap<ITypeBinding, IMethodBinding> overridden = new HashMap<ITypeBinding, IMethodBinding>();
        if (met == null) {
            return null;
        }
        JDT2CAstUtils.getMethodInClassOrSuperclass(met, met.getDeclaringClass(), true, overridden);
        if (overridden.size() == 0) {
            return null;
        }
        return overridden.values();
    }

    public static boolean sameErasedSignatureAndReturnType(IMethodBinding met1, IMethodBinding met2) {
        ITypeBinding[] params2;
        if (!met1.getReturnType().getErasure().isEqualTo((IBinding)met2.getReturnType().getErasure())) {
            return false;
        }
        ITypeBinding[] params1 = met1.getParameterTypes();
        if (params1.length != (params2 = met2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            if (params1[i].getErasure().isEqualTo((IBinding)params2[i].getErasure())) continue;
            return false;
        }
        return true;
    }
}

