/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt.ecj;

import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.Java2IRTranslator;
import com.ibm.wala.cast.java.translator.SourceModuleTranslator;
import com.ibm.wala.cast.java.translator.jdt.JDTJava2CAstTranslator;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJSourceLoaderImpl;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.classLoader.DirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.JarStreamModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.io.TemporaryFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class ECJSourceModuleTranslator
implements SourceModuleTranslator {
    protected boolean dump;
    protected ECJSourceLoaderImpl sourceLoader;
    private final String[] sources;
    private final String[] libs;
    private final SetOfClasses exclusions;

    public ECJSourceModuleTranslator(AnalysisScope scope, ECJSourceLoaderImpl sourceLoader) {
        this(scope, sourceLoader, false);
    }

    public ECJSourceModuleTranslator(AnalysisScope scope, ECJSourceLoaderImpl sourceLoader, boolean dump) {
        this.sourceLoader = sourceLoader;
        this.dump = dump;
        Pair<String[], String[]> paths = ECJSourceModuleTranslator.computeClassPath(scope);
        this.sources = (String[])paths.fst;
        this.libs = (String[])paths.snd;
        this.exclusions = scope.getExclusions();
    }

    private static Pair<String[], String[]> computeClassPath(AnalysisScope scope) {
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> libs = new ArrayList<String>();
        Iterator iterator = scope.getLoaders().iterator();
        while (iterator.hasNext()) {
            for (ClassLoaderReference cl = (ClassLoaderReference)iterator.next(); cl != null; cl = cl.getParent()) {
                List modules = scope.getModules(cl);
                for (Module m : modules) {
                    if (m instanceof JarFileModule) {
                        JarFileModule jarFileModule = (JarFileModule)m;
                        libs.add(jarFileModule.getAbsolutePath());
                        continue;
                    }
                    if (m instanceof JarStreamModule) {
                        try {
                            File F = File.createTempFile("tmp", "jar");
                            F.deleteOnExit();
                            TemporaryFile.streamToFile((File)F, (InputStream[])new InputStream[]{(JarStreamModule)m});
                            libs.add(F.getAbsolutePath());
                            continue;
                        }
                        catch (IOException e) {
                            assert (false) : e;
                            continue;
                        }
                    }
                    if (!(m instanceof DirectoryTreeModule)) continue;
                    DirectoryTreeModule directoryTreeModule = (DirectoryTreeModule)m;
                    sources.add(directoryTreeModule.getPath());
                }
            }
        }
        return Pair.make((Object)sources.toArray(new String[0]), (Object)libs.toArray(new String[0]));
    }

    public void loadAllSources(Set<ModuleEntry> modules) {
        ArrayList<String> sources = new ArrayList<String>();
        HashMap sourceMap = HashMapFactory.make();
        for (ModuleEntry m : modules) {
            if (!m.isSourceFile()) continue;
            SourceFileModule s = (SourceFileModule)m;
            sourceMap.put(s.getAbsolutePath(), s);
            sources.add(s.getAbsolutePath());
        }
        String[] sourceFiles = sources.toArray(new String[0]);
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setEnvironment(this.libs, this.sources, null, false);
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.8");
        parser.setCompilerOptions((Map)options);
        parser.createASTs(sourceFiles, null, new String[0], (FileASTRequestor)new ECJAstToIR(sourceMap), (IProgressMonitor)new NullProgressMonitor());
    }

    protected Java2IRTranslator makeIRTranslator() {
        return new Java2IRTranslator((JavaSourceLoaderImpl)this.sourceLoader, this.exclusions);
    }

    protected JDTJava2CAstTranslator<CAstSourcePositionMap.Position> makeCAstTranslator(CompilationUnit cu, String fullPath) {
        return new ECJJavaToCAstTranslator(this.sourceLoader, cu, fullPath, false, this.dump);
    }

    private final class ECJAstToIR
    extends FileASTRequestor {
        private final Map<String, ModuleEntry> sourceMap;

        public ECJAstToIR(Map<String, ModuleEntry> sourceMap) {
            this.sourceMap = sourceMap;
        }

        public void acceptAST(String source, CompilationUnit ast) {
            IProblem[] problems;
            int length;
            JDTJava2CAstTranslator<CAstSourcePositionMap.Position> jdt2cast = ECJSourceModuleTranslator.this.makeCAstTranslator(ast, source);
            Java2IRTranslator java2ir = ECJSourceModuleTranslator.this.makeIRTranslator();
            java2ir.translate(this.sourceMap.get(source), jdt2cast.translateToCAst());
            if (!"true".equals(System.getProperty("wala.jdt.quiet")) && (length = (problems = ast.getProblems()).length) > 0) {
                StringBuilder buffer = new StringBuilder();
                for (IProblem problem : problems) {
                    buffer.append(problem.getMessage());
                    buffer.append('\n');
                }
                if (length != 0) {
                    System.err.println("Unexpected problems in " + source + "\n " + buffer);
                }
            }
        }
    }

    protected static class ECJJavaToCAstTranslator
    extends JDTJava2CAstTranslator<CAstSourcePositionMap.Position> {
        public ECJJavaToCAstTranslator(JavaSourceLoaderImpl sourceLoader, CompilationUnit astRoot, String fullPath, boolean replicateForDoLoops, boolean dump) {
            super(sourceLoader, astRoot, fullPath, replicateForDoLoops, dump);
        }

        @Override
        public CAstSourcePositionMap.Position makePosition(final int start, final int end) {
            return new AbstractSourcePosition(){

                public URL getURL() {
                    try {
                        return new URL("file://" + fullPath);
                    }
                    catch (MalformedURLException e) {
                        assert (false) : ECJJavaToCAstTranslator.access$100(this);
                        return null;
                    }
                }

                public Reader getReader() throws IOException {
                    return new InputStreamReader(this.getURL().openConnection().getInputStream());
                }

                public int getFirstLine() {
                    return cu.getLineNumber(start);
                }

                public int getLastLine() {
                    return cu.getLineNumber(end);
                }

                public int getFirstCol() {
                    return cu.getColumnNumber(start);
                }

                public int getLastCol() {
                    return cu.getColumnNumber(end);
                }

                public int getFirstOffset() {
                    return start;
                }

                public int getLastOffset() {
                    return end;
                }
            };
        }

        static /* synthetic */ String access$100(ECJJavaToCAstTranslator x0) {
            return x0.fullPath;
        }
    }
}

