/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.Objects;

public abstract class AstLexicalAccess
extends SSAInstruction {
    private Access[] accesses;

    AstLexicalAccess(int iindex, Access[] accesses) {
        super(iindex);
        this.setAccesses(accesses);
    }

    public void setAccesses(Access[] accesses) {
        this.accesses = accesses;
    }

    public Access[] getAccesses() {
        return this.accesses;
    }

    public Access getAccess(int i) {
        return this.accesses[i];
    }

    public int getAccessCount() {
        return this.accesses.length;
    }

    public boolean isFallThrough() {
        return true;
    }

    public Collection<TypeReference> getExceptionTypes() {
        return null;
    }

    public int hashCode() {
        int v = 1;
        for (Access accesse : this.accesses) {
            v *= accesse.variableName.hashCode();
        }
        return v;
    }

    public static class Access {
        public final String variableName;
        public final String variableDefiner;
        public final TypeReference type;
        public final int valueNumber;

        public Access(String name, String definer, TypeReference type, int vn) {
            this.variableName = name;
            this.variableDefiner = definer;
            this.type = type;
            this.valueNumber = vn;
        }

        public Pair<String, String> getName() {
            return Pair.make((Object)this.variableName, (Object)this.variableDefiner);
        }

        public int hashCode() {
            return this.variableName.hashCode() * this.valueNumber;
        }

        public boolean equals(Object other) {
            return other instanceof Access && this.variableName.equals(((Access)other).variableName) && this.valueNumber == ((Access)other).valueNumber && Objects.equals(this.variableDefiner, ((Access)other).variableDefiner);
        }

        public String toString() {
            return "Access(" + this.variableName + '@' + this.variableDefiner + ':' + this.valueNumber + ')';
        }
    }
}

