/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.classLoader.DexIClass;
import com.ibm.wala.dalvik.classLoader.DexUtil;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import java.util.Collection;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.iface.Field;

public class DexIField
implements IField {
    private final Field eField;
    private final DexIClass myClass;
    private FieldReference fieldReference;
    private final FieldReference myFieldRef;
    private final Atom name;

    public DexIField(Field encodedField, DexIClass klass) {
        this.eField = encodedField;
        this.myClass = klass;
        String fieldName = this.eField.getName();
        this.name = Atom.findOrCreateUnicodeAtom((String)fieldName);
        String fieldType = this.eField.getType();
        TypeName T = DexUtil.getTypeName(fieldType);
        TypeReference type = TypeReference.findOrCreate((ClassLoaderReference)this.myClass.getClassLoader().getReference(), (TypeName)T);
        this.myFieldRef = FieldReference.findOrCreate((TypeReference)this.myClass.getReference(), (Atom)this.name, (TypeReference)type);
    }

    public TypeReference getFieldTypeReference() {
        return this.myFieldRef.getFieldType();
    }

    public FieldReference getReference() {
        if (this.fieldReference == null) {
            this.fieldReference = FieldReference.findOrCreate((TypeReference)this.myClass.getReference(), (Atom)this.getName(), (TypeReference)this.getFieldTypeReference());
        }
        return this.fieldReference;
    }

    public Atom getName() {
        return this.name;
    }

    public boolean isFinal() {
        return (this.eField.getAccessFlags() & AccessFlags.FINAL.getValue()) != 0;
    }

    public boolean isPrivate() {
        return (this.eField.getAccessFlags() & AccessFlags.PRIVATE.getValue()) != 0;
    }

    public boolean isProtected() {
        return (this.eField.getAccessFlags() & AccessFlags.PROTECTED.getValue()) != 0;
    }

    public boolean isPublic() {
        return (this.eField.getAccessFlags() & AccessFlags.PUBLIC.getValue()) != 0;
    }

    public boolean isStatic() {
        return (this.eField.getAccessFlags() & AccessFlags.STATIC.getValue()) != 0;
    }

    public IClass getDeclaringClass() {
        return this.myClass;
    }

    public boolean isVolatile() {
        return (this.eField.getAccessFlags() & AccessFlags.VOLATILE.getValue()) != 0;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.myClass.getClassHierarchy();
    }

    public Collection<Annotation> getAnnotations() {
        return this.myClass.getAnnotations(this.eField);
    }
}

