/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.core.util.strings.ImmutableByteArray;
import com.ibm.wala.shrike.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;

public class DexUtil {
    static Collection<Annotation> getAnnotations(Collection<org.jf.dexlib2.iface.Annotation> as, ClassLoaderReference clr) {
        HashSet result = HashSetFactory.make();
        for (org.jf.dexlib2.iface.Annotation a : as) {
            result.add(DexUtil.getAnnotation(a, clr));
        }
        return result;
    }

    static Annotation getAnnotation(org.jf.dexlib2.iface.Annotation ea, ClassLoaderReference clr) {
        HashMap values = HashMapFactory.make();
        TypeReference at = DexUtil.getTypeRef(ea.getType(), clr);
        for (AnnotationElement elt : ea.getElements()) {
            String name = elt.getName();
            EncodedValue v = elt.getValue();
            AnnotationsReader.ElementValue value = DexUtil.getValue(clr, v);
            values.put(name, value);
        }
        return Annotation.makeWithNamed((TypeReference)at, (Map)values);
    }

    static AnnotationsReader.ElementValue getValue(ClassLoaderReference clr, EncodedValue v) {
        switch (v.getValueType()) {
            case 29: {
                HashMap values = HashMapFactory.make();
                String at = ((AnnotationEncodedValue)v).getType();
                for (AnnotationElement elt : ((AnnotationEncodedValue)v).getElements()) {
                    String name = elt.getName();
                    EncodedValue ev = elt.getValue();
                    AnnotationsReader.ElementValue value = DexUtil.getValue(clr, ev);
                    values.put(name, value);
                }
                return new AnnotationsReader.AnnotationAttribute(at, (Map)values);
            }
            case 28: {
                List vs = ((ArrayEncodedValue)v).getValue();
                AnnotationsReader.ElementValue[] rs = new AnnotationsReader.ElementValue[vs.size()];
                int idx = 0;
                for (EncodedValue ev : vs) {
                    rs[idx++] = DexUtil.getValue(clr, ev);
                }
                return new AnnotationsReader.ArrayElementValue(rs);
            }
            case 31: {
                Boolean bl = ((BooleanEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)bl);
            }
            case 0: {
                Byte bt = ((ByteEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)bt);
            }
            case 3: {
                Character c = Character.valueOf(((CharEncodedValue)v).getValue());
                return new AnnotationsReader.ConstantElementValue((Object)c);
            }
            case 17: {
                Double d = ((DoubleEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)d);
            }
            case 27: {
                FieldReference o = ((EnumEncodedValue)v).getValue();
                return new AnnotationsReader.EnumElementValue(o.getType(), o.getName());
            }
            case 25: {
                FieldReference o = v.getValueType() == 27 ? ((EnumEncodedValue)v).getValue() : ((FieldEncodedValue)v).getValue();
                String fieldName = o.getName();
                TypeReference ft = DexUtil.getTypeRef(o.getType(), clr);
                TypeReference ct = DexUtil.getTypeRef(o.getDefiningClass(), clr);
                return new AnnotationsReader.ConstantElementValue((Object)com.ibm.wala.types.FieldReference.findOrCreate((TypeReference)ct, (Atom)Atom.findOrCreateUnicodeAtom((String)fieldName), (TypeReference)ft));
            }
            case 16: {
                Float f = Float.valueOf(((FloatEncodedValue)v).getValue());
                return new AnnotationsReader.ConstantElementValue((Object)f);
            }
            case 4: {
                Integer iv = ((IntEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)iv);
            }
            case 6: {
                Long l = ((LongEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)l);
            }
            case 26: {
                MethodReference m = ((MethodEncodedValue)v).getValue();
                TypeReference ct = DexUtil.getTypeRef(m.getDefiningClass(), clr);
                String methodName = m.getName();
                String methodSig = DexUtil.getSignature(m);
                return new AnnotationsReader.ConstantElementValue((Object)com.ibm.wala.types.MethodReference.findOrCreate((TypeReference)ct, (Atom)Atom.findOrCreateUnicodeAtom((String)methodName), (Descriptor)Descriptor.findOrCreateUTF8((String)methodSig)));
            }
            case 30: {
                return new AnnotationsReader.ConstantElementValue(null);
            }
            case 2: {
                Short s = ((ShortEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)s);
            }
            case 23: {
                String str = ((StringEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)str);
            }
            case 24: {
                String t = ((TypeEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue((Object)(DexUtil.getTypeName(t) + ";"));
            }
        }
        assert (false) : v;
        return null;
    }

    static String getSignature(MethodReference ref) {
        StringBuilder sig = new StringBuilder("(");
        for (CharSequence p : ref.getParameterTypes()) {
            sig = sig.append(p);
        }
        sig.append(')').append(ref.getReturnType());
        return sig.toString();
    }

    static TypeReference getTypeRef(String type, ClassLoaderReference clr) {
        return TypeReference.findOrCreate((ClassLoaderReference)clr, (TypeName)DexUtil.getTypeName(type));
    }

    static TypeName getTypeName(String fieldType) {
        ImmutableByteArray fieldTypeArray = ImmutableByteArray.make((String)fieldType);
        TypeName T = null;
        T = fieldTypeArray.get(fieldTypeArray.length() - 1) == 59 ? TypeName.findOrCreate((ImmutableByteArray)fieldTypeArray, (int)0, (int)(fieldTypeArray.length() - 1)) : TypeName.findOrCreate((ImmutableByteArray)fieldTypeArray);
        return T;
    }
}

