/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.dex.instructions;

import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.classLoader.Literal;
import com.ibm.wala.dalvik.dex.instructions.BinaryOperation;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.shrike.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrike.shrikeBT.IShiftInstruction;
import org.jf.dexlib2.Opcode;

public class BinaryLiteralOperation
extends Instruction {
    public final OpID op;
    public final int oper1;
    public final Literal oper2;
    public final int destination;

    public BinaryLiteralOperation(int pc, OpID op, int destination, int oper1, Literal oper2, Opcode opcode, DexIMethod method) {
        super(pc, opcode, method);
        this.op = op;
        this.destination = destination;
        this.oper1 = oper1;
        this.oper2 = oper2;
    }

    @Override
    public void visit(Instruction.Visitor visitor) {
        visitor.visitBinaryLiteral(this);
    }

    public IBinaryOpInstruction.IOperator getOperator() {
        switch (this.op) {
            case CMPL_FLOAT: 
            case CMPL_DOUBLE: 
            case CMPL_LONG: 
            case CMPL_INT: {
                return BinaryOperation.DalvikBinaryOp.LT;
            }
            case CMPG_FLOAT: 
            case CMPG_DOUBLE: 
            case CMPG_LONG: 
            case CMPG_INT: {
                return BinaryOperation.DalvikBinaryOp.GT;
            }
            case ADD_INT: 
            case ADD_LONG: 
            case ADD_DOUBLE: 
            case ADD_FLOAT: {
                return IBinaryOpInstruction.Operator.ADD;
            }
            case RSUB_INT: 
            case RSUB_LONG: 
            case RSUB_DOUBLE: 
            case RSUB_FLOAT: {
                return IBinaryOpInstruction.Operator.SUB;
            }
            case MUL_INT: 
            case MUL_LONG: 
            case MUL_DOUBLE: 
            case MUL_FLOAT: {
                return IBinaryOpInstruction.Operator.MUL;
            }
            case DIV_INT: 
            case DIV_LONG: 
            case DIV_DOUBLE: 
            case DIV_FLOAT: {
                return IBinaryOpInstruction.Operator.DIV;
            }
            case REM_INT: 
            case REM_LONG: 
            case REM_DOUBLE: 
            case REM_FLOAT: {
                return IBinaryOpInstruction.Operator.REM;
            }
            case AND_INT: 
            case AND_LONG: {
                return IBinaryOpInstruction.Operator.AND;
            }
            case OR_INT: 
            case OR_LONG: {
                return IBinaryOpInstruction.Operator.OR;
            }
            case XOR_INT: 
            case XOR_LONG: {
                return IBinaryOpInstruction.Operator.XOR;
            }
            case SHL_INT: 
            case SHL_LONG: {
                return IShiftInstruction.Operator.SHL;
            }
            case SHR_INT: 
            case SHR_LONG: {
                return IShiftInstruction.Operator.SHR;
            }
            case USHR_INT: 
            case USHR_LONG: {
                return IShiftInstruction.Operator.USHR;
            }
        }
        return null;
    }

    public boolean isFloat() {
        switch (this.op) {
            case CMPL_FLOAT: 
            case CMPL_DOUBLE: 
            case CMPG_FLOAT: 
            case CMPG_DOUBLE: 
            case ADD_DOUBLE: 
            case ADD_FLOAT: 
            case RSUB_DOUBLE: 
            case RSUB_FLOAT: 
            case MUL_DOUBLE: 
            case MUL_FLOAT: 
            case DIV_DOUBLE: 
            case DIV_FLOAT: 
            case REM_DOUBLE: 
            case REM_FLOAT: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnsigned() {
        switch (this.op) {
            case AND_INT: 
            case AND_LONG: 
            case OR_INT: 
            case OR_LONG: 
            case XOR_INT: 
            case XOR_LONG: 
            case SHL_INT: 
            case SHL_LONG: 
            case USHR_INT: 
            case USHR_LONG: {
                return true;
            }
        }
        return false;
    }

    public boolean isSub() {
        switch (this.op) {
            case RSUB_INT: 
            case RSUB_LONG: 
            case RSUB_DOUBLE: 
            case RSUB_FLOAT: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("%04dpc: v%d = v%d %s v%d", this.pc, this.destination, this.oper1, this.op.toString(), this.oper2.value);
    }

    public static enum OpID {
        CMPL_FLOAT,
        CMPG_FLOAT,
        CMPL_DOUBLE,
        CMPG_DOUBLE,
        CMPL_LONG,
        CMPG_LONG,
        CMPL_INT,
        CMPG_INT,
        ADD_INT,
        RSUB_INT,
        MUL_INT,
        DIV_INT,
        REM_INT,
        AND_INT,
        OR_INT,
        XOR_INT,
        SHL_INT,
        SHR_INT,
        USHR_INT,
        ADD_LONG,
        RSUB_LONG,
        MUL_LONG,
        DIV_LONG,
        REM_LONG,
        AND_LONG,
        OR_LONG,
        XOR_LONG,
        SHL_LONG,
        SHR_LONG,
        USHR_LONG,
        ADD_FLOAT,
        RSUB_FLOAT,
        MUL_FLOAT,
        DIV_FLOAT,
        REM_FLOAT,
        ADD_DOUBLE,
        RSUB_DOUBLE,
        MUL_DOUBLE,
        DIV_DOUBLE,
        REM_DOUBLE;

    }
}

