/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters;

import com.ibm.wala.core.util.ssa.ParameterAccessor;
import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.IInstantiationBehavior;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidModelParameterManager {
    private int nextLocal;
    private int currentScope = 0;
    private IInstantiationBehavior behaviour = null;
    private String description;
    private final Map<TypeReference, List<ManagedParameter>> seenTypes = new HashMap<TypeReference, List<ManagedParameter>>();

    public AndroidModelParameterManager(IInstantiationBehavior behaviour) {
        this.behaviour = behaviour;
        this.description = " based on behaviours of " + behaviour;
    }

    public AndroidModelParameterManager(MethodReference mRef, boolean isStatic) {
        this(new ParameterAccessor(mRef, isStatic));
        this.description = " based on MethodReference " + mRef;
    }

    public AndroidModelParameterManager(ParameterAccessor acc) {
        this.behaviour = null;
        this.nextLocal = acc.getFirstAfter();
        this.description = " based on ParameterAccessor " + acc;
    }

    public void setAllocation(TypeReference type, int ssaValue, SSAInstruction setBy) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (ssaValue <= 0) {
            throw new IllegalArgumentException("The SSA-Variable may not be zero or negative.");
        }
        if (this.seenTypes.containsKey(type)) {
            for (ManagedParameter param : this.seenTypes.get(type)) {
                if (param.status != ValueStatus.UNALLOCATED) continue;
                assert (param.type.equals((Object)type)) : "Inequal types";
                if (ssaValue + 1 > this.nextLocal) {
                    this.nextLocal = ssaValue + 1;
                }
                param.status = ValueStatus.ALLOCATED;
                param.ssa = ssaValue;
                param.setInScope = this.currentScope;
                return;
            }
            throw new IllegalStateException("The parameter " + type.getName() + " has already been allocated!");
        }
        ManagedParameter param = new ManagedParameter();
        param.status = ValueStatus.ALLOCATED;
        param.type = type;
        param.ssa = ssaValue;
        if (ssaValue + 1 > this.nextLocal) {
            this.nextLocal = ssaValue + 1;
        }
        param.setInScope = this.currentScope;
        ArrayList<ManagedParameter> aParam = new ArrayList<ManagedParameter>();
        aParam.add(param);
        this.seenTypes.put(type, aParam);
    }

    public void setAllocation(TypeReference type, int ssaValue) {
        this.setAllocation(type, ssaValue, null);
    }

    public void setAllocation(SSAValue val) {
        this.setAllocation(val.getType(), val.getNumber(), null);
    }

    public void setPhi(TypeReference type, int ssaValue, SSAInstruction setBy) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (ssaValue <= 0) {
            throw new IllegalArgumentException("The SSA-Variable may not be zero or negative.");
        }
        boolean didPhi = false;
        if (this.seenTypes.containsKey(type)) {
            for (ManagedParameter param : this.seenTypes.get(type)) {
                if (param.status == ValueStatus.FREE || param.status == ValueStatus.FREE_INVALIDATED || param.status == ValueStatus.FREE_CLOSED) {
                    assert (param.type.equals((Object)type)) : "Inequal types";
                    if (param.ssa != ssaValue) {
                        if (param.status != ValueStatus.FREE || param.setInScope != this.currentScope) continue;
                        param.status = ValueStatus.FREE_CLOSED;
                        continue;
                    }
                    switch (param.status) {
                        case FREE: {
                            param.status = ValueStatus.ALLOCATED;
                            break;
                        }
                        case FREE_INVALIDATED: {
                            param.status = ValueStatus.INVALIDATED;
                            break;
                        }
                        case FREE_CLOSED: {
                            param.status = ValueStatus.CLOSED;
                        }
                    }
                    param.setInScope = this.currentScope;
                    didPhi = true;
                    continue;
                }
                if (param.setInScope == this.currentScope) {
                    if (param.status == ValueStatus.INVALIDATED) {
                        param.status = ValueStatus.CLOSED;
                        continue;
                    }
                    if (param.status != ValueStatus.FREE_INVALIDATED) continue;
                    param.status = ValueStatus.FREE_CLOSED;
                    continue;
                }
                if (param.setInScope >= this.currentScope) continue;
            }
            assert (didPhi);
        } else {
            ManagedParameter param = new ManagedParameter();
            param.status = ValueStatus.ALLOCATED;
            param.type = type;
            param.setInScope = this.currentScope;
            param.ssa = ssaValue;
            if (ssaValue + 1 > this.nextLocal) {
                this.nextLocal = ssaValue + 1;
            }
            ArrayList<ManagedParameter> aParam = new ArrayList<ManagedParameter>();
            aParam.add(param);
            this.seenTypes.put(type, aParam);
        }
    }

    public int getFree(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        ManagedParameter param = new ManagedParameter();
        param.status = ValueStatus.FREE;
        param.type = type;
        param.ssa = this.nextLocal++;
        param.setInScope = this.currentScope;
        if (this.seenTypes.containsKey(type)) {
            this.seenTypes.get(type).add(param);
        } else {
            ArrayList<ManagedParameter> aParam = new ArrayList<ManagedParameter>();
            aParam.add(param);
            this.seenTypes.put(type, aParam);
        }
        return param.ssa;
    }

    public int getUnallocated(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (this.seenTypes.containsKey(type)) {
            for (ManagedParameter p : this.seenTypes.get(type)) {
                if (p.status != ValueStatus.UNALLOCATED) continue;
                throw new IllegalStateException("There may be only one unallocated instance to a type (" + type + ") at a time");
            }
        }
        ManagedParameter param = new ManagedParameter();
        param.status = ValueStatus.UNALLOCATED;
        param.type = type;
        param.ssa = this.nextLocal++;
        param.setInScope = this.currentScope;
        if (this.seenTypes.containsKey(type)) {
            this.seenTypes.get(type).add(param);
        } else {
            ArrayList<ManagedParameter> aParam = new ArrayList<ManagedParameter>();
            aParam.add(param);
            this.seenTypes.put(type, aParam);
        }
        return param.ssa;
    }

    public int getUnmanaged() {
        int ret = this.nextLocal++;
        return ret;
    }

    public int getCurrent(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        int candidateSSA = -1;
        int candidateScope = -1;
        if (this.seenTypes.containsKey(type)) {
            for (ManagedParameter param : this.seenTypes.get(type)) {
                if (param.status != ValueStatus.FREE && param.status != ValueStatus.ALLOCATED) continue;
                assert (param.type.equals((Object)type)) : "Inequal types";
                if (param.setInScope > this.currentScope) continue;
                if (param.setInScope == this.currentScope) {
                    return param.ssa;
                }
                if (param.setInScope <= candidateScope) continue;
                candidateScope = param.setInScope;
                candidateSSA = param.ssa;
            }
        } else {
            throw new IllegalArgumentException("Type " + type + " has never been seen before!");
        }
        if (candidateSSA < 0) {
            return candidateSSA;
        }
        throw new IllegalStateException("No suitable candidate has been found for " + type.getName());
    }

    public int getSuper(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        --this.currentScope;
        assert (this.currentScope >= 0);
        int ssa = this.getCurrent(type);
        ++this.currentScope;
        return ssa;
    }

    public List<Integer> getAllForPhi(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (this.seenTypes.containsKey(type)) {
            for (ManagedParameter param : this.seenTypes.get(type)) {
                if (param.status == ValueStatus.FREE || param.status == ValueStatus.ALLOCATED) {
                    assert (param.type.equals((Object)type)) : "Inequal types";
                    ret.add(param.ssa);
                    continue;
                }
                if (param.status != ValueStatus.INVALIDATED || param.setInScope <= this.currentScope) continue;
                ret.add(param.ssa);
            }
        } else {
            throw new IllegalArgumentException("Type " + type + " has never been seen before!");
        }
        return ret;
    }

    public boolean isSeen(TypeReference type, boolean withSuper) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (withSuper) {
            return this.seenTypes.containsKey(type);
        }
        return this.seenTypes.containsKey(type) && this.seenTypes.get((Object)type).get((int)0).type.equals((Object)type);
    }

    public boolean isSeen(TypeReference type) {
        return this.isSeen(type, true);
    }

    public boolean needsAllocation(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (this.seenTypes.containsKey(type)) {
            if (this.seenTypes.get(type).size() > 1) {
                return false;
            }
            return this.seenTypes.get((Object)type).get((int)0).status == ValueStatus.UNALLOCATED;
        }
        return true;
    }

    public boolean needsPhi(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        boolean seenLive = false;
        if (this.seenTypes.containsKey(type)) {
            for (ManagedParameter param : this.seenTypes.get(type)) {
                if (param.status == ValueStatus.FREE) {
                    return true;
                }
                if (param.status != ValueStatus.ALLOCATED) continue;
                if (seenLive) {
                    return true;
                }
                seenLive = true;
            }
        } else {
            throw new IllegalArgumentException("Type " + type + " has never been seen before!");
        }
        throw new IllegalStateException("No suitable candidate has been found");
    }

    public void invalidate(TypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (this.seenTypes.containsKey(type)) {
            for (ManagedParameter param : this.seenTypes.get(type)) {
                if (param.status == ValueStatus.CLOSED || param.status == ValueStatus.FREE_CLOSED || param.status == ValueStatus.FREE_INVALIDATED || param.status == ValueStatus.INVALIDATED || param.setInScope != this.currentScope) continue;
                assert (param.type.equals((Object)type));
                if (param.status == ValueStatus.FREE) {
                    param.status = ValueStatus.FREE_INVALIDATED;
                    continue;
                }
                param.status = ValueStatus.INVALIDATED;
            }
        }
    }

    public int scopeDown(boolean doesLoop) {
        ++this.currentScope;
        return this.currentScope;
    }

    public int scopeUp() {
        for (List<ManagedParameter> plist : this.seenTypes.values()) {
            for (ManagedParameter param : plist) {
                if (param.setInScope == this.currentScope) {
                    this.invalidate(param.type);
                    continue;
                }
                if (param.setInScope <= this.currentScope || param.status == ValueStatus.INVALIDATED && param.status == ValueStatus.CLOSED) continue;
                throw new IllegalStateException("Something went wrong in leaving a sub-subordinate scope");
            }
        }
        --this.currentScope;
        return this.currentScope;
    }

    public boolean isReuse(TypeReference type) {
        if (this.behaviour == null) {
            throw new IllegalStateException("AndroidModelParameterManager was constructed without an IInstanciationBehavior");
        }
        if (type.isPrimitiveType()) {
            return false;
        }
        IInstantiationBehavior.InstanceBehavior beh = this.behaviour.getBehavior(type.getName(), null, null, null);
        return beh == IInstantiationBehavior.InstanceBehavior.REUSE;
    }

    public boolean isCreate(TypeReference type) {
        return !this.isReuse(type);
    }

    public String toString() {
        return "<AndroidModelParameterManager " + this.description + '>';
    }

    private static class ManagedParameter {
        public ValueStatus status = ValueStatus.UNUSED;
        public TypeReference type = null;
        public int ssa = -1;
        public int setInScope = -1;

        private ManagedParameter() {
        }
    }

    private static enum ValueStatus {
        UNUSED,
        UNALLOCATED,
        ALLOCATED,
        FREE,
        INVALIDATED,
        CLOSED,
        FREE_INVALIDATED,
        FREE_CLOSED;

    }
}

