/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.structure;

import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.core.util.ssa.SSAValueManager;
import com.ibm.wala.core.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.structure.SingleStartAndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrike.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopAndroidModel
extends SingleStartAndroidModel {
    private static final Logger logger = LoggerFactory.getLogger(LoopAndroidModel.class);
    private int outerLoopPC = -1;
    Map<TypeReference, SSAValue> outerStartingPhis;

    public LoopAndroidModel(VolatileMethodSummary body, TypeSafeInstructionFactory insts, SSAValueManager paramManager, Iterable<? extends Entrypoint> entryPoints) {
        super(body, insts, paramManager, entryPoints);
    }

    @Override
    protected int enterSTART_OF_LOOP(int PC) {
        logger.info("PC {} is the jump target of START_OF_LOOP", (Object)PC);
        this.outerLoopPC = PC;
        PC = this.body.getNextProgramCounter();
        this.paramManager.scopeDown(true);
        this.outerStartingPhis = new HashMap<TypeReference, SSAValue>();
        List<TypeReference> outerPhisNeeded = this.returnTypesBetween(AndroidEntryPoint.ExecutionOrder.START_OF_LOOP, AndroidEntryPoint.ExecutionOrder.AFTER_LOOP);
        for (TypeReference phiType : outerPhisNeeded) {
            SSAValue.TypeKey phiKey = new SSAValue.TypeKey(phiType.getName());
            if (!this.paramManager.isSeen((SSAValue.VariableKey)phiKey, false)) continue;
            SSAValue newValue = this.paramManager.getFree(phiType, (SSAValue.VariableKey)phiKey);
            this.outerStartingPhis.put(phiType, newValue);
        }
        this.body.reserveProgramCounters(outerPhisNeeded.size());
        PC = this.body.getNextProgramCounter();
        return PC;
    }

    @Override
    protected int enterAFTER_LOOP(int PC) {
        assert (this.outerLoopPC > 0) : "Somehow you managed to get the loop-target negative. This is wierd!";
        int phiPC = this.outerLoopPC + 1;
        boolean oldAllowReserved = this.body.allowReserved(true);
        logger.info("Setting block-inner Phis");
        for (SSAValue oldPhi : this.outerStartingPhis.values()) {
            ArrayList<SSAValue> forPhi = new ArrayList<SSAValue>(2);
            forPhi.add(this.paramManager.getSuper(oldPhi.key));
            forPhi.add(this.paramManager.getCurrent(oldPhi.key));
            SSAPhiInstruction phi = this.insts.PhiInstruction(phiPC, oldPhi, forPhi);
            ++phiPC;
            this.body.addStatement((SSAInstruction)phi);
            this.paramManager.setPhi(oldPhi, (SSAInstruction)phi);
        }
        this.body.allowReserved(oldAllowReserved);
        logger.info("Closing Loop");
        logger.info("PC {}: Goto {}", (Object)PC, (Object)this.outerLoopPC);
        SSAValue.NamedKey trueKey = new SSAValue.NamedKey(TypeReference.BooleanName, "true");
        SSAValue trueVal = this.paramManager.getFree(TypeReference.Boolean, (SSAValue.VariableKey)trueKey);
        this.paramManager.setPhi(trueVal, null);
        this.body.addConstant(Integer.valueOf(trueVal.getNumber()), new ConstantValue((Object)true));
        this.body.addStatement((SSAInstruction)this.insts.ConditionalBranchInstruction(PC, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.EQ, TypeReference.Boolean, trueVal.getNumber(), trueVal.getNumber(), this.outerLoopPC));
        this.paramManager.scopeUp();
        logger.info("Setting outer-block Phis");
        for (Map.Entry<TypeReference, SSAValue> entry : this.outerStartingPhis.entrySet()) {
            SSAValue.VariableKey phiKey = entry.getValue().key;
            PC = this.body.getNextProgramCounter();
            List all = this.paramManager.getAllForPhi(phiKey);
            TypeReference phiType = entry.getKey();
            logger.debug("Into phi {} for {}", (Object)all, (Object)phiType.getName());
            this.paramManager.invalidate(phiKey);
            SSAValue newValue = this.paramManager.getFree(phiType, phiKey);
            SSAPhiInstruction phi = this.insts.PhiInstruction(PC, newValue, (Collection)all);
            this.body.addStatement((SSAInstruction)phi);
            this.paramManager.setPhi(newValue, (SSAInstruction)phi);
        }
        PC = this.body.getNextProgramCounter();
        return PC;
    }

    @Override
    protected int leaveAT_LAST(int PC) {
        logger.info("Leaving Model with PC = {}", (Object)PC);
        return PC;
    }
}

