/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.core.util.ssa.SSAValueManager;
import com.ibm.wala.core.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;

public class AndroidBoot {
    private TypeSafeInstructionFactory instructionFactory;
    private SSAValueManager pm;
    private VolatileMethodSummary body;
    private SSAValue mainThread = null;
    private SSAValue systemContext = null;
    private SSAValue packageContext = null;

    public void addBootCode(TypeSafeInstructionFactory instructionFactory, SSAValueManager pm, VolatileMethodSummary body) {
        this.instructionFactory = instructionFactory;
        this.pm = pm;
        this.body = body;
        this.mainThread = this.createMainThred();
        this.systemContext = this.createSystemContext(this.mainThread);
        this.packageContext = this.createPackageContext(this.mainThread);
    }

    public SSAValue getSystemContext() {
        if (this.systemContext == null) {
            throw new IllegalStateException("No value for systemContext - was addBootCode called?");
        }
        return this.systemContext;
    }

    public SSAValue getPackageContext() {
        if (this.packageContext == null) {
            throw new IllegalStateException("No value for packageContext - was addBootCode called?");
        }
        return this.packageContext;
    }

    public SSAValue getMainThread() {
        if (this.mainThread == null) {
            throw new IllegalStateException("No value for mainThread - was addBootCode called?");
        }
        return this.mainThread;
    }

    private SSAValue createMainThred() {
        SSAValue mainThread = this.pm.getUnmanaged(AndroidTypes.ActivityThread, "mMainThred");
        int pc = this.body.getNextProgramCounter();
        NewSiteReference nRef = NewSiteReference.make((int)pc, (TypeReference)AndroidTypes.ActivityThread);
        SSANewInstruction newInstr = this.instructionFactory.NewInstruction(pc, mainThread, nRef);
        this.body.addStatement((SSAInstruction)newInstr);
        pc = this.body.getNextProgramCounter();
        MethodReference mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.ActivityThread, (Selector)MethodReference.initSelector);
        SSAValue exception = this.pm.getUnmanaged(TypeReference.JavaLangException, "ctor_exc");
        CallSiteReference site = CallSiteReference.make((int)pc, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
        params.add(mainThread);
        SSAAbstractInvokeInstruction ctorCall = this.instructionFactory.InvokeInstruction(pc, params, exception, site);
        this.body.addStatement((SSAInstruction)ctorCall);
        return mainThread;
    }

    private SSAValue createSystemContext(SSAValue mainThread) {
        SSAValue systemContext = this.pm.getUnmanaged(AndroidTypes.ContextImpl, "systemContextImpl");
        int pc = this.body.getNextProgramCounter();
        Descriptor desc = Descriptor.findOrCreate((TypeName[])new TypeName[0], (TypeName)AndroidTypes.ContextImplName);
        Selector mSel = new Selector(Atom.findOrCreateAsciiAtom((String)"getSystemContext"), desc);
        MethodReference mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.ActivityThread, (Selector)mSel);
        CallSiteReference site = CallSiteReference.make((int)pc, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
        SSAValue exception = this.pm.getException();
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
        params.add(mainThread);
        SSAAbstractInvokeInstruction call = this.instructionFactory.InvokeInstruction(pc, systemContext, params, exception, site);
        this.body.addStatement((SSAInstruction)call);
        SSAValue falseConst = this.pm.getUnmanaged(TypeReference.Boolean, "falseConst");
        this.body.addConstant(Integer.valueOf(falseConst.getNumber()), new ConstantValue((Object)false));
        falseConst.setAssigned();
        int pc2 = this.body.getNextProgramCounter();
        FieldReference mRestricted = FieldReference.findOrCreate((TypeReference)AndroidTypes.ContextImpl, (Atom)Atom.findOrCreateAsciiAtom((String)"mRestricted"), (TypeReference)TypeReference.Boolean);
        SSAPutInstruction putInst = this.instructionFactory.PutInstruction(pc2, systemContext, falseConst, mRestricted);
        this.body.addStatement((SSAInstruction)putInst);
        return systemContext;
    }

    private SSAValue createPackageContext(SSAValue mainThread) {
        SSAValue packageContext = this.pm.getUnmanaged(AndroidTypes.ContextImpl, "packageContextImpl");
        int pc = this.body.getNextProgramCounter();
        NewSiteReference nRef = NewSiteReference.make((int)pc, (TypeReference)AndroidTypes.ContextImpl);
        SSANewInstruction newInstr = this.instructionFactory.NewInstruction(pc, packageContext, nRef);
        this.body.addStatement((SSAInstruction)newInstr);
        pc = this.body.getNextProgramCounter();
        MethodReference mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.ContextImpl, (Selector)MethodReference.initSelector);
        SSAValue exception = this.pm.getUnmanaged(TypeReference.JavaLangException, "ctor_exc");
        CallSiteReference site = CallSiteReference.make((int)pc, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
        params.add(packageContext);
        SSAAbstractInvokeInstruction ctorCall = this.instructionFactory.InvokeInstruction(pc, params, exception, site);
        this.body.addStatement((SSAInstruction)ctorCall);
        SSAValue falseConst = this.pm.getUnmanaged(TypeReference.Boolean, "falseConst");
        this.body.addConstant(Integer.valueOf(falseConst.getNumber()), new ConstantValue((Object)false));
        falseConst.setAssigned();
        int pc2 = this.body.getNextProgramCounter();
        FieldReference mRestricted = FieldReference.findOrCreate((TypeReference)AndroidTypes.ContextImpl, (Atom)Atom.findOrCreateAsciiAtom((String)"mRestricted"), (TypeReference)TypeReference.Boolean);
        SSAPutInstruction putInst = this.instructionFactory.PutInstruction(pc2, packageContext, falseConst, mRestricted);
        this.body.addStatement((SSAInstruction)putInst);
        SSAValue packageName = this.pm.getUnmanaged(TypeReference.JavaLangString, "packageName");
        this.body.addConstant(Integer.valueOf(packageName.getNumber()), new ConstantValue((Object)"foo"));
        packageName.setAssigned();
        SSAValue uid = this.pm.getUnmanaged(AndroidTypes.UserHandle, "uid");
        int pc3 = this.body.getNextProgramCounter();
        NewSiteReference nRef2 = NewSiteReference.make((int)pc3, (TypeReference)AndroidTypes.UserHandle);
        SSANewInstruction newInstr2 = this.instructionFactory.NewInstruction(pc3, uid, nRef2);
        this.body.addStatement((SSAInstruction)newInstr2);
        SSAValue nullApk = this.pm.getUnmanaged(AndroidTypes.LoadedApk, "nullApk");
        this.body.addConstant(Integer.valueOf(nullApk.getNumber()), new ConstantValue(null));
        nullApk.setAssigned();
        SSAValue nullIBinder = this.pm.getUnmanaged(AndroidTypes.IBinder, "nullBinder");
        this.body.addConstant(Integer.valueOf(nullIBinder.getNumber()), new ConstantValue(null));
        nullIBinder.setAssigned();
        int pc4 = this.body.getNextProgramCounter();
        Descriptor desc = Descriptor.findOrCreate((TypeName[])new TypeName[]{AndroidTypes.LoadedApkName, AndroidTypes.IBinderName, AndroidTypes.ActivityThreadName}, (TypeName)TypeReference.VoidName);
        Selector mSel = new Selector(Atom.findOrCreateAsciiAtom((String)"init"), desc);
        MethodReference mRef2 = MethodReference.findOrCreate((TypeReference)AndroidTypes.ContextImpl, (Selector)mSel);
        SSAValue exception2 = this.pm.getException();
        CallSiteReference site2 = CallSiteReference.make((int)pc4, (MethodReference)mRef2, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
        ArrayList<SSAValue> params2 = new ArrayList<SSAValue>(7);
        params2.add(packageContext);
        params2.add(nullApk);
        params2.add(nullIBinder);
        params2.add(mainThread);
        SSAAbstractInvokeInstruction call = this.instructionFactory.InvokeInstruction(pc4, params2, exception2, site2);
        this.body.addStatement((SSAInstruction)call);
        return packageContext;
    }

    public static enum BootAction {
        CREATE_SYSTEM_CONTEXT,
        CREATE_APK_CONTEXT;

    }
}

