/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.core.util.ssa.ParameterAccessor;
import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.core.util.ssa.SSAValueManager;
import com.ibm.wala.core.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModelClass;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.IntentStarters;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidStartComponentTool {
    private static final Logger logger = LoggerFactory.getLogger(AndroidStartComponentTool.class);
    private final IClassHierarchy cha;
    private final Set<IntentStarters.StarterFlags> flags;
    private final TypeReference caller;
    private final TypeSafeInstructionFactory instructionFactory;
    private final ParameterAccessor acc;
    private final SSAValueManager pm;
    private final VolatileMethodSummary redirect;
    private final ParameterAccessor.Parameter self;
    private AndroidTypes.AndroidContextType callerContext;

    public AndroidStartComponentTool(IClassHierarchy cha, MethodReference asMethod, Set<IntentStarters.StarterFlags> flags, TypeReference caller, TypeSafeInstructionFactory instructionFactory, ParameterAccessor acc, SSAValueManager pm, VolatileMethodSummary redirect, ParameterAccessor.Parameter self, IntentStarters.StartInfo info) {
        if (cha == null) {
            throw new IllegalArgumentException("cha may not be null");
        }
        if (asMethod == null) {
            throw new IllegalArgumentException("asMethod may not be null");
        }
        if (flags == null) {
            throw new IllegalArgumentException("Flags may not be null");
        }
        if (caller == null && !flags.contains((Object)IntentStarters.StarterFlags.CONTEXT_FREE)) {
            throw new IllegalArgumentException("Caller may not be null if StarterFlags.CONTEXT_FREE is not set. Flags: " + flags);
        }
        if (instructionFactory == null) {
            throw new IllegalArgumentException("The instructionFactory may not be null");
        }
        if (acc == null) {
            throw new IllegalArgumentException("acc may not be null");
        }
        if (pm == null) {
            throw new IllegalArgumentException("pm may not be null");
        }
        if (redirect == null) {
            throw new IllegalArgumentException("self may not be null");
        }
        if (info == null) {
            throw new IllegalArgumentException("info may not be null");
        }
        this.cha = cha;
        this.flags = flags;
        this.caller = caller;
        this.instructionFactory = instructionFactory;
        this.acc = acc;
        this.pm = pm;
        this.redirect = redirect;
        this.self = self;
    }

    public void attachActivities(Set<? extends SSAValue> activities, SSAValue application, SSAValue thread, SSAValue context, SSAValue iBinderToken, SSAValue intent) {
        SSAValue nullInstrumentation = this.pm.getUnmanaged(AndroidTypes.Instrumentation, "nullInstrumentation");
        this.redirect.addConstant(Integer.valueOf(nullInstrumentation.getNumber()), new ConstantValue(null));
        nullInstrumentation.setAssigned();
        SSAValue nullInfo = this.pm.getUnmanaged(AndroidTypes.ActivityInfo, "nullInfo");
        this.redirect.addConstant(Integer.valueOf(nullInfo.getNumber()), new ConstantValue(null));
        nullInfo.setAssigned();
        SSAValue title = this.pm.getUnmanaged(TypeReference.JavaLangString, "title");
        this.redirect.addConstant(Integer.valueOf(title.getNumber()), new ConstantValue((Object)"title"));
        title.setAssigned();
        SSAValue nullParent = this.pm.getUnmanaged(AndroidTypes.Activity, "nullParent");
        this.redirect.addConstant(Integer.valueOf(nullParent.getNumber()), new ConstantValue(null));
        nullParent.setAssigned();
        TypeName cName = TypeName.string2TypeName((String)"Landroid/app/Activity$NonConfigurationInstances");
        TypeReference type = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)cName);
        SSAValue nullConfigInstance = this.pm.getUnmanaged(type, "noState");
        this.redirect.addConstant(Integer.valueOf(nullConfigInstance.getNumber()), new ConstantValue(null));
        nullConfigInstance.setAssigned();
        SSAValue nullConfiguration = this.pm.getUnmanaged(AndroidTypes.Configuration, "nullConfig");
        this.redirect.addConstant(Integer.valueOf(nullConfiguration.getNumber()), new ConstantValue(null));
        nullConfiguration.setAssigned();
        Descriptor desc = Descriptor.findOrCreate((TypeName[])new TypeName[]{AndroidTypes.ContextName, AndroidTypes.ActivityThreadName, AndroidTypes.InstrumentationName, AndroidTypes.IBinderName, AndroidTypes.ApplicationName, AndroidTypes.IntentName, AndroidTypes.ActivityInfoName, TypeName.string2TypeName((String)"Ljava/lang/CharSequence"), AndroidTypes.ActivityName, TypeReference.JavaLangString.getName(), TypeName.string2TypeName((String)"Landroid/app/Activity$NonConfigurationInstances"), AndroidTypes.ConfigurationName}, (TypeName)TypeReference.VoidName);
        Selector mSel = new Selector(Atom.findOrCreateAsciiAtom((String)"attach"), desc);
        MethodReference mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.Activity, (Selector)mSel);
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(13);
        params.add(null);
        params.add(context);
        params.add(thread);
        params.add(nullInstrumentation);
        params.add(iBinderToken);
        params.add(application);
        params.add(intent);
        params.add(nullInfo);
        params.add(title);
        params.add(nullParent);
        params.add(title);
        params.add(nullConfigInstance);
        params.add(nullConfiguration);
        for (SSAValue sSAValue : activities) {
            int callPC = this.redirect.getNextProgramCounter();
            CallSiteReference site = CallSiteReference.make((int)callPC, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
            SSAValue exception = this.pm.getException();
            params.set(0, sSAValue);
            SSAAbstractInvokeInstruction invokation = this.instructionFactory.InvokeInstruction(callPC, params, exception, site);
            this.redirect.addStatement((SSAInstruction)invokation);
        }
    }

    public AndroidTypes.AndroidContextType typeOfCallerContext() {
        return this.callerContext;
    }

    public SSAValue fetchCallerContext() {
        if (this.caller == null) {
            return null;
        }
        IClass iCaller = this.cha.lookupClass(this.caller);
        IClass iActivity = this.cha.lookupClass(AndroidTypes.Activity);
        IClass iApp = this.cha.lookupClass(AndroidTypes.Application);
        IClass iService = this.cha.lookupClass(AndroidTypes.Service);
        if (this.caller.getName().equals((Object)AndroidTypes.ContextWrapperName)) {
            this.callerContext = AndroidTypes.AndroidContextType.USELESS;
            return null;
        }
        if (this.caller.getName().equals((Object)AndroidTypes.ContextImplName)) {
            ParameterAccessor.Parameter androidContext = this.self;
            this.callerContext = AndroidTypes.AndroidContextType.CONTEXT_IMPL;
            return androidContext;
        }
        if (this.cha.isAssignableFrom(iActivity, iCaller)) {
            SSAValue androidContext = null;
            this.callerContext = AndroidTypes.AndroidContextType.ACTIVITY;
            return androidContext;
        }
        if (this.caller.equals((Object)AndroidModelClass.ANDROID_MODEL_CLASS)) {
            this.callerContext = AndroidTypes.AndroidContextType.USELESS;
            return null;
        }
        if (this.caller.getName().equals((Object)AndroidTypes.BridgeContextName)) {
            ParameterAccessor.Parameter androidContext = this.self;
            this.callerContext = AndroidTypes.AndroidContextType.CONTEXT_BRIDGE;
            return androidContext;
        }
        if (this.cha.isAssignableFrom(iApp, iCaller)) {
            ParameterAccessor.Parameter androidContext = this.self;
            this.callerContext = AndroidTypes.AndroidContextType.APPLICATION;
            return androidContext;
        }
        if (this.cha.isAssignableFrom(iService, iCaller)) {
            ParameterAccessor.Parameter androidContext = this.self;
            this.callerContext = AndroidTypes.AndroidContextType.SERVICE;
            return androidContext;
        }
        logger.debug("Can not handle the callers android-context of " + this.caller);
        return null;
    }

    public SSAValue fetchIBinder(SSAValue androidContext) {
        SSAValue iBinder = this.pm.getUnmanaged(AndroidTypes.IBinder, "foreignIBinder");
        if (this.flags.contains((Object)IntentStarters.StarterFlags.CONTEXT_FREE)) {
            return null;
        }
        if (this.flags.contains((Object)IntentStarters.StarterFlags.QUENCH_PERMISSIONS)) {
            ParameterAccessor.Parameter intentSender = this.acc.firstOf(AndroidTypes.IntentSenderName);
            assert (intentSender != null) : "Unable to look up the IntentSender-Object";
            assert (intentSender.getNumber() == 2) : "The IntentSender-Object was not located at SSA-Number 2. This may be entirely ok! I left this assertion to ashure the ParameterAccessor does its job right.";
            SSAValue iIntentSender = this.pm.getUnmanaged(AndroidTypes.IIntentSender, "iIntentSender");
            int callPC = this.redirect.getNextProgramCounter();
            Selector mSel = Selector.make((String)"getTarget()Landroid/content/IIntentSender;");
            MethodReference mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.IntentSender, (Selector)mSel);
            CallSiteReference site = CallSiteReference.make((int)callPC, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
            SSAValue exception = this.pm.getException();
            ArrayList<Object> params = new ArrayList<Object>(1);
            params.add(intentSender);
            SSAAbstractInvokeInstruction invokation = this.instructionFactory.InvokeInstruction(callPC, iIntentSender, params, exception, site);
            this.redirect.addStatement((SSAInstruction)invokation);
            callPC = this.redirect.getNextProgramCounter();
            mSel = Selector.make((String)"asBinder()Landroid/os/IBinder;");
            mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.IntentSender, (Selector)mSel);
            site = CallSiteReference.make((int)callPC, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
            exception = this.pm.getException();
            params = new ArrayList(1);
            params.add(iIntentSender);
            invokation = this.instructionFactory.InvokeInstruction(callPC, iBinder, params, exception, site);
            this.redirect.addStatement((SSAInstruction)invokation);
            return iBinder;
        }
        if (this.callerContext == AndroidTypes.AndroidContextType.ACTIVITY) {
            SSAValue mMainThread = this.pm.getUnmanaged(AndroidTypes.ActivityThread, "callersMainThred");
            int instPC = this.redirect.getNextProgramCounter();
            FieldReference mMainThreadRef = FieldReference.findOrCreate((TypeReference)AndroidTypes.Activity, (Atom)Atom.findOrCreateAsciiAtom((String)"mMainThread"), (TypeReference)AndroidTypes.ActivityThread);
            SSAGetInstruction getInst = this.instructionFactory.GetInstruction(instPC, mMainThread, (SSAValue)this.self, mMainThreadRef);
            this.redirect.addStatement((SSAInstruction)getInst);
            int callPC = this.redirect.getNextProgramCounter();
            Selector mSel = Selector.make((String)"getApplicationThread()Landroid/app/ActivityThread$ApplicationThread;");
            MethodReference mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.ActivityThread, (Selector)mSel);
            CallSiteReference site = CallSiteReference.make((int)callPC, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
            SSAValue exception = this.pm.getException();
            ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
            params.add(mMainThread);
            SSAAbstractInvokeInstruction invokation = this.instructionFactory.InvokeInstruction(callPC, iBinder, params, exception, site);
            this.redirect.addStatement((SSAInstruction)invokation);
            return iBinder;
        }
        if (this.callerContext == AndroidTypes.AndroidContextType.CONTEXT_IMPL) {
            FieldReference mActivityTokenRef = FieldReference.findOrCreate((TypeReference)AndroidTypes.ContextImpl, (Atom)Atom.findOrCreateAsciiAtom((String)"mActivityToken"), (TypeReference)AndroidTypes.IBinder);
            int instPC = this.redirect.getNextProgramCounter();
            SSAGetInstruction getInst = this.instructionFactory.GetInstruction(instPC, iBinder, androidContext, mActivityTokenRef);
            this.redirect.addStatement((SSAInstruction)getInst);
            return iBinder;
        }
        if (this.callerContext == AndroidTypes.AndroidContextType.CONTEXT_BRIDGE) {
            return null;
        }
        if (this.caller.equals((Object)AndroidModelClass.ANDROID_MODEL_CLASS)) {
            return null;
        }
        throw new UnsupportedOperationException("No implementation on how to extract an iBinder from a " + this.caller);
    }

    public void assignIBinder(SSAValue iBinder, List<? extends SSAValue> allActivities) {
        if (iBinder == null) {
            return;
        }
        for (SSAValue sSAValue : allActivities) {
            FieldReference mTokenRef = FieldReference.findOrCreate((TypeReference)AndroidTypes.Activity, (Atom)Atom.findOrCreateAsciiAtom((String)"mToken"), (TypeReference)AndroidTypes.IBinder);
            int instPC = this.redirect.getNextProgramCounter();
            SSAPutInstruction putInst = this.instructionFactory.PutInstruction(instPC, sSAValue, iBinder, mTokenRef);
            this.redirect.addStatement((SSAInstruction)putInst);
        }
    }

    public void setIntent(SSAValue intent, List<? extends SSAValue> allActivities) {
        if (intent == null) {
            throw new IllegalArgumentException("Null-Intent");
        }
        for (SSAValue sSAValue : allActivities) {
            int callPC = this.redirect.getNextProgramCounter();
            Selector mSel = Selector.make((String)"setIntent(Landroid/content/Intent;)V");
            MethodReference mRef = MethodReference.findOrCreate((TypeReference)AndroidTypes.Activity, (Selector)mSel);
            CallSiteReference site = CallSiteReference.make((int)callPC, (MethodReference)mRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL);
            SSAValue exception = this.pm.getException();
            ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
            params.add(sSAValue);
            params.add(intent);
            SSAAbstractInvokeInstruction invokation = this.instructionFactory.InvokeInstruction(callPC, params, exception, site);
            this.redirect.addStatement((SSAInstruction)invokation);
        }
    }

    public void fetchResults(List<? super SSAValue> resultCodes, List<? super SSAValue> resultData, List<? extends SSAValue> allActivities) {
        for (SSAValue sSAValue : allActivities) {
            SSAValue tmpResultCode = this.pm.getUnmanaged(TypeReference.Int, "mResultCode");
            FieldReference mResultCodeRef = FieldReference.findOrCreate((TypeReference)AndroidTypes.Activity, (Atom)Atom.findOrCreateAsciiAtom((String)"mResultCode"), (TypeReference)TypeReference.Int);
            int instPC = this.redirect.getNextProgramCounter();
            SSAGetInstruction getInst = this.instructionFactory.GetInstruction(instPC, tmpResultCode, sSAValue, mResultCodeRef);
            this.redirect.addStatement((SSAInstruction)getInst);
            SSAValue tmpResultData = this.pm.getUnmanaged(AndroidTypes.Intent, "mResultData");
            FieldReference mResultDataRef = FieldReference.findOrCreate((TypeReference)AndroidTypes.Activity, (Atom)Atom.findOrCreateAsciiAtom((String)"mResultData"), (TypeReference)AndroidTypes.Intent);
            int instPC2 = this.redirect.getNextProgramCounter();
            SSAGetInstruction getInst2 = this.instructionFactory.GetInstruction(instPC2, tmpResultData, sSAValue, mResultDataRef);
            this.redirect.addStatement((SSAInstruction)getInst2);
            resultCodes.add((SSAValue)tmpResultCode);
            resultData.add((SSAValue)tmpResultData);
        }
        assert (resultCodes.size() == resultData.size());
    }

    public SSAValue addPhi(List<? extends SSAValue> from) {
        if (from.size() == 1) {
            return from.get(0);
        }
        SSAValue retVal = this.pm.getUnmanaged(from.get(0).getType(), "forPhi");
        int phiPC = this.redirect.getNextProgramCounter();
        SSAPhiInstruction phi = this.instructionFactory.PhiInstruction(phiPC, retVal, from);
        this.redirect.addStatement((SSAInstruction)phi);
        return retVal;
    }
}

