/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.ssa.ParameterAccessor;
import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.core.util.ssa.SSAValueManager;
import com.ibm.wala.core.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModelClass;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.Instantiator;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import java.util.Collection;
import java.util.HashSet;

public class SystemServiceModel
extends AndroidModel {
    public final Atom name;
    private SummarizedMethod activityModel;
    private final String target;

    @Override
    protected boolean selectEntryPoint(AndroidEntryPoint ep) {
        return false;
    }

    public SystemServiceModel(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache, Atom target) {
        super(cha, options, cache);
        if (target == null) {
            throw new IllegalArgumentException("The target requested to create an SystemServiceModel for was null");
        }
        String sName = target.toString();
        String cName = Character.toUpperCase(sName.charAt(0)) + sName.substring(1);
        this.name = Atom.findOrCreateAsciiAtom((String)("startSystemService" + cName));
        this.target = target.toString();
    }

    private void register(SummarizedMethod model) {
        AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
        if (!mClass.containsMethod(model.getSelector())) {
            mClass.addMethod((IMethod)model);
        }
    }

    @Override
    public SummarizedMethod getMethod() throws CancelException {
        if (!this.built) {
            super.build(this.name);
            this.register(this.model);
            this.activityModel = this.model;
        }
        return this.activityModel;
    }

    @Override
    protected void build(Atom name, Collection<? extends AndroidEntryPoint> entrypoints) {
        assert (entrypoints == null || !entrypoints.iterator().hasNext());
        Descriptor descr = Descriptor.findOrCreate((TypeName[])new TypeName[]{AndroidTypes.ContextName}, (TypeName)TypeName.string2TypeName((String)"Ljava/lang/Object"));
        this.mRef = MethodReference.findOrCreate((TypeReference)AndroidModelClass.ANDROID_MODEL_CLASS, (Atom)name, (Descriptor)descr);
        Selector selector = new Selector(name, descr);
        AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
        if (mClass.containsMethod(selector)) {
            this.model = (SummarizedMethod)mClass.getMethod(selector);
            return;
        }
        this.body = new VolatileMethodSummary(new MethodSummary(this.mRef));
        this.body.setStatic(true);
        this.populate(null);
        this.klass = AndroidModelClass.getInstance(this.cha);
        this.model = new SummarizedMethod(this.mRef, this.body.getMethodSummary(), this.klass){

            public TypeReference getParameterType(int i) {
                IClassHierarchy cha = this.getClassHierarchy();
                TypeReference tRef = super.getParameterType(i);
                if (tRef.isClassType()) {
                    if (cha.lookupClass(tRef) != null) {
                        return tRef;
                    }
                    for (IClass c : cha) {
                        if (!c.getName().toString().equals(tRef.getName().toString())) continue;
                        return c.getReference();
                    }
                    throw new IllegalStateException("Error looking up " + tRef);
                }
                return tRef;
            }
        };
        this.built = true;
    }

    private void populate(Iterable<? extends AndroidEntryPoint> entrypoints) {
        SSAValue retVal;
        assert (entrypoints == null || !entrypoints.iterator().hasNext());
        assert (!this.built) : "You can only build once";
        TypeSafeInstructionFactory instructionFactory = new TypeSafeInstructionFactory(this.getClassHierarchy());
        VolatileMethodSummary body = this.body;
        ParameterAccessor pAcc = new ParameterAccessor(this.mRef, false);
        SSAValueManager pm = new SSAValueManager(pAcc);
        Instantiator instantiator = new Instantiator(body, instructionFactory, pm, this.cha, this.mRef, this.scope);
        switch (this.target) {
            case "phone": {
                retVal = instantiator.createInstance(AndroidTypes.TelephonyManager, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "keyguard": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/app/KeyguardManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "location": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/location/LocationManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "search": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/app/SearchManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "connection": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/net/ConnectivityManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "wifi": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/net/wifi/WifiManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "input_method": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/view/inputmethod/InputMethodManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "uimode": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/app/UiModeManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            case "download": {
                TypeName n = TypeName.findOrCreate((String)"Landroid/app/DownloadManager");
                TypeReference T = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)n);
                retVal = instantiator.createInstance(T, false, (SSAValue.VariableKey)new SSAValue.UniqueKey(), new HashSet(pAcc.all()));
                break;
            }
            default: {
                retVal = pm.getUnmanaged(TypeReference.JavaLangObject, "notFound");
                this.body.addConstant(Integer.valueOf(retVal.getNumber()), new ConstantValue(null));
                retVal.setAssigned();
            }
        }
        int returnPC = this.body.getNextProgramCounter();
        SSAReturnInstruction returnInstruction = instructionFactory.ReturnInstruction(returnPC, retVal);
        this.body.addStatement((SSAInstruction)returnInstruction);
    }
}

