/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.ssa.IInstantiator;
import com.ibm.wala.core.util.ssa.ParameterAccessor;
import com.ibm.wala.core.util.ssa.SSAValue;
import com.ibm.wala.core.util.ssa.SSAValueManager;
import com.ibm.wala.core.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModelClass;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.MiniModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.Instantiator;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.ExternalModel;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class UnknownTargetModel
extends AndroidModel {
    public final Atom name;
    private boolean doMini = true;
    private MiniModel miniModel = null;
    private ExternalModel externalModel = null;
    private final AndroidComponent target;

    @Override
    protected boolean selectEntryPoint(AndroidEntryPoint ep) {
        return false;
    }

    public UnknownTargetModel(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache, AndroidComponent target) {
        super(cha, options, cache);
        if (target == null) {
            throw new IllegalArgumentException("The component type requested to create an UnknownTargetModel for was null");
        }
        String sName = target.toString();
        String cName = Character.toUpperCase(sName.charAt(0)) + sName.substring(1).toLowerCase();
        this.name = Atom.findOrCreateAsciiAtom((String)("startUnknown" + cName));
        this.target = target;
    }

    private void register(SummarizedMethod model) {
        AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
        if (!mClass.containsMethod(model.getSelector())) {
            mClass.addMethod((IMethod)model);
        }
    }

    @Override
    public SummarizedMethod getMethod() throws CancelException {
        if (!this.built) {
            super.build(this.name);
            this.register(this.model);
        }
        return this.model;
    }

    @Override
    protected void build(Atom name, Collection<? extends AndroidEntryPoint> entrypoints) throws CancelException {
        Descriptor descr;
        assert (entrypoints == null || !entrypoints.iterator().hasNext());
        this.doMini = false;
        for (AndroidEntryPoint ep : AndroidEntryPointManager.ENTRIES) {
            if (!ep.belongsTo(this.target)) continue;
            this.doMini = true;
            break;
        }
        if (this.doMini) {
            this.miniModel = new MiniModel(this.cha, this.options, this.cache, this.target);
        }
        this.externalModel = new ExternalModel(this.cha, this.options, this.cache, this.target);
        if (this.doMini) {
            TypeName[] othersA = this.miniModel.getDescriptor().getParameters();
            HashSet<Object> others = othersA != null ? new HashSet<TypeName>(Arrays.asList(othersA)) : new HashSet();
            this.doMini = others.size() > 0;
            others.addAll(Arrays.asList(this.externalModel.getDescriptor().getParameters()));
            descr = Descriptor.findOrCreate((TypeName[])others.toArray(new TypeName[0]), (TypeName)TypeReference.VoidName);
        } else {
            descr = Descriptor.findOrCreate((TypeName[])this.externalModel.getDescriptor().getParameters(), (TypeName)TypeReference.VoidName);
        }
        this.klass = AndroidModelClass.getInstance(this.cha);
        this.mRef = MethodReference.findOrCreate((TypeReference)AndroidModelClass.ANDROID_MODEL_CLASS, (Atom)name, (Descriptor)descr);
        this.body = new VolatileMethodSummary(new MethodSummary(this.mRef));
        this.body.setStatic(true);
        this.populate(null);
        this.model = new SummarizedMethod(this.mRef, this.body.getMethodSummary(), this.klass){

            public TypeReference getParameterType(int i) {
                IClassHierarchy cha = this.getClassHierarchy();
                TypeReference tRef = super.getParameterType(i);
                if (tRef.isClassType()) {
                    if (cha.lookupClass(tRef) != null) {
                        return tRef;
                    }
                    for (IClass c : cha) {
                        if (!c.getName().toString().equals(tRef.getName().toString())) continue;
                        return c.getReference();
                    }
                    throw new IllegalStateException("Error looking up " + tRef);
                }
                return tRef;
            }
        };
        this.built = true;
    }

    private void populate(Iterable<? extends AndroidEntryPoint> entrypoints) throws CancelException {
        assert (entrypoints == null || !entrypoints.iterator().hasNext());
        assert (!this.built) : "You can only build once";
        TypeSafeInstructionFactory instructionFactory = new TypeSafeInstructionFactory(this.cha);
        ParameterAccessor pAcc = new ParameterAccessor(this.mRef, false);
        SSAValueManager pm = new SSAValueManager(pAcc);
        Instantiator instantiator = new Instantiator(this.body, instructionFactory, pm, this.cha, this.mRef, this.scope);
        if (this.doMini) {
            SummarizedMethod mini = this.miniModel.getMethod();
            ParameterAccessor miniAcc = new ParameterAccessor((IMethod)mini);
            List params = pAcc.connectThrough(miniAcc, null, null, this.cha, (IInstantiator)instantiator, new Object[]{false, null, null});
            SSAValue excpetion = pm.getException();
            int pc = this.body.getNextProgramCounter();
            CallSiteReference site = CallSiteReference.make((int)pc, (MethodReference)mini.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            SSAAbstractInvokeInstruction invokation = instructionFactory.InvokeInstruction(pc, params, excpetion, site);
            this.body.addStatement((SSAInstruction)invokation);
        }
        SummarizedMethod external = this.externalModel.getMethod();
        ParameterAccessor externalAcc = new ParameterAccessor((IMethod)external);
        List params = pAcc.connectThrough(externalAcc, null, null, this.cha, (IInstantiator)instantiator, new Object[]{false, null, null});
        SSAValue excpetion = pm.getException();
        SSAValue extRet = pm.getUnmanaged(external.getReturnType(), "extRet");
        int pc = this.body.getNextProgramCounter();
        CallSiteReference site = CallSiteReference.make((int)pc, (MethodReference)external.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
        SSAAbstractInvokeInstruction invokation = instructionFactory.InvokeInstruction(pc, extRet, params, excpetion, site);
        this.body.addStatement((SSAInstruction)invokation);
        this.body.setLocalNames(pm.makeLocalNames());
    }
}

