/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.dalvik.ipa.callgraph.impl.DexEntryPoint;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointLocator;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import java.util.Comparator;

public class AndroidEntryPoint
extends DexEntryPoint {
    public ExecutionOrder order;
    protected AndroidComponent superType;

    public AndroidEntryPoint(AndroidEntryPointLocator.AndroidPossibleEntryPoint p, IMethod method, IClassHierarchy cha, AndroidComponent inComponent) {
        super(method, cha);
        this.order = p.order;
        this.superType = inComponent;
    }

    public AndroidEntryPoint(AndroidEntryPointLocator.AndroidPossibleEntryPoint p, IMethod method, IClassHierarchy cha) {
        super(method, cha);
        this.order = p.order;
        this.superType = AndroidComponent.from(method, cha);
    }

    public AndroidEntryPoint(ExecutionOrder o, IMethod method, IClassHierarchy cha, AndroidComponent inComponent) {
        this(o, method, cha);
        this.superType = inComponent;
    }

    public AndroidEntryPoint(ExecutionOrder o, IMethod method, IClassHierarchy cha) {
        super(method, cha);
        if (o == null) {
            throw new IllegalArgumentException("The execution order may not be null.");
        }
        this.order = o;
        this.superType = AndroidComponent.from(method, cha);
    }

    public AndroidComponent getComponent() {
        return this.superType;
    }

    public boolean isActivity() {
        IClassHierarchy cha = this.getClassHierarchy();
        TypeReference activity = AndroidTypes.Activity;
        return cha.isSubclassOf(this.method.getDeclaringClass(), cha.lookupClass(activity));
    }

    public boolean belongsTo(AndroidComponent compo) {
        if (compo == AndroidComponent.SERVICE && this.superType.equals((Object)AndroidComponent.INTENT_SERVICE)) {
            return true;
        }
        return this.superType.equals((Object)compo);
    }

    public boolean isMemberOf(Atom klass) {
        return this.method.getDeclaringClass().getName().toString().startsWith(klass.toString());
    }

    public ExecutionOrder getSection() {
        if (this.order.compareTo(ExecutionOrder.BEFORE_LOOP) < 0) {
            return ExecutionOrder.AT_FIRST;
        }
        if (this.order.compareTo(ExecutionOrder.START_OF_LOOP) < 0) {
            return ExecutionOrder.BEFORE_LOOP;
        }
        if (this.order.compareTo(ExecutionOrder.MIDDLE_OF_LOOP) < 0) {
            return ExecutionOrder.START_OF_LOOP;
        }
        if (this.order.compareTo(ExecutionOrder.MULTIPLE_TIMES_IN_LOOP) < 0) {
            return ExecutionOrder.MIDDLE_OF_LOOP;
        }
        if (this.order.compareTo(ExecutionOrder.END_OF_LOOP) < 0) {
            return ExecutionOrder.MULTIPLE_TIMES_IN_LOOP;
        }
        if (this.order.compareTo(ExecutionOrder.AFTER_LOOP) < 0) {
            return ExecutionOrder.END_OF_LOOP;
        }
        if (this.order.compareTo(ExecutionOrder.AT_LAST) < 0) {
            return ExecutionOrder.AFTER_LOOP;
        }
        return ExecutionOrder.AT_LAST;
    }

    public int getOrderValue() {
        return this.order.getOrderValue();
    }

    public int compareTo(IExecutionOrder o) {
        return this.order.compareTo(o);
    }

    public boolean equals(Object o) {
        if (o instanceof AndroidEntryPoint) {
            AndroidEntryPoint other = (AndroidEntryPoint)((Object)o);
            return this.getMethod().equals(other.getMethod());
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.getMethod().hashCode();
    }

    public static class ExecutionOrder
    implements IExecutionOrder {
        public static final ExecutionOrder AT_FIRST = new ExecutionOrder(0);
        public static final ExecutionOrder BEFORE_LOOP = new ExecutionOrder(0xFFFFFFF);
        public static final ExecutionOrder START_OF_LOOP = new ExecutionOrder(0x1FFFFFFE);
        public static final ExecutionOrder MIDDLE_OF_LOOP = new ExecutionOrder(0x2FFFFFFD);
        public static final ExecutionOrder MULTIPLE_TIMES_IN_LOOP = new ExecutionOrder(0x3FFFFFFC);
        public static final ExecutionOrder END_OF_LOOP = new ExecutionOrder(0x4FFFFFFB);
        public static final ExecutionOrder AFTER_LOOP = new ExecutionOrder(0x5FFFFFFA);
        public static final ExecutionOrder AT_LAST = new ExecutionOrder(0x6FFFFFF9);
        public static final ExecutionOrder DEFAULT = MIDDLE_OF_LOOP;
        private final int value;

        public ExecutionOrder(int val) {
            this.value = val;
        }

        public ExecutionOrder(String label) {
            if (label.equals("AT_FIRST")) {
                this.value = AT_FIRST.getOrderValue();
                return;
            }
            if (label.equals("BEFORE_LOOP")) {
                this.value = BEFORE_LOOP.getOrderValue();
                return;
            }
            if (label.equals("START_OF_LOOP")) {
                this.value = START_OF_LOOP.getOrderValue();
                return;
            }
            if (label.equals("MIDDLE_OF_LOOP")) {
                this.value = MIDDLE_OF_LOOP.getOrderValue();
                return;
            }
            if (label.equals("MULTIPLE_TIMES_IN_LOOP")) {
                this.value = MULTIPLE_TIMES_IN_LOOP.getOrderValue();
                return;
            }
            if (label.equals("END_OF_LOOP")) {
                this.value = END_OF_LOOP.getOrderValue();
                return;
            }
            if (label.equals("AFTER_LOOP")) {
                this.value = AFTER_LOOP.getOrderValue();
                return;
            }
            if (label.equals("AT_LAST")) {
                this.value = AT_LAST.getOrderValue();
                return;
            }
            throw new IllegalArgumentException("ExecutionOrder was constructed from an illegal label: " + label);
        }

        @Override
        public int getOrderValue() {
            return this.value;
        }

        private static ExecutionOrder between(int after, int before) {
            if (before - after == 1) {
                throw new ArithmeticException("Precision to low when cascading the ExecutionOrder. You can prevent this error by assigning the ExecutionOrders (e.g. using before() and after()) in a different order.");
            }
            if (after > before) {
                throw new IllegalArgumentException("The requested ordering could not be established due to the after-parameter being greater than the before parameter! after=" + after + " before=" + before);
            }
            return new ExecutionOrder(after + (before - after) / 2);
        }

        public static ExecutionOrder between(IExecutionOrder after, IExecutionOrder before) {
            if (after == null) {
                throw new NullPointerException("after may not be null");
            }
            if (before == null) {
                throw new NullPointerException("after may not be null");
            }
            return ExecutionOrder.between(after.getOrderValue(), before.getOrderValue());
        }

        private static ExecutionOrder between(IExecutionOrder after, int before) {
            return ExecutionOrder.between(after.getOrderValue(), before);
        }

        public static ExecutionOrder between(IExecutionOrder[] after, IExecutionOrder[] before) {
            if (after == null || after.length == 0) {
                throw new NullPointerException("after may not be null or empty array");
            }
            if (before == null || before.length == 0) {
                throw new NullPointerException("before may not be null or empty array");
            }
            int max = Integer.MIN_VALUE;
            int min = Integer.MAX_VALUE;
            for (IExecutionOrder i : after) {
                if (max >= i.getOrderValue()) continue;
                max = i.getOrderValue();
            }
            for (IExecutionOrder i : before) {
                if (min <= i.getOrderValue()) continue;
                min = i.getOrderValue();
            }
            return ExecutionOrder.between(max, min);
        }

        public static ExecutionOrder between(IExecutionOrder after, IExecutionOrder[] before) {
            if (before == null || before.length == 0) {
                throw new NullPointerException("after may not be null or empty array");
            }
            int min = Integer.MAX_VALUE;
            for (IExecutionOrder i : before) {
                if (min <= i.getOrderValue()) continue;
                min = i.getOrderValue();
            }
            return ExecutionOrder.between(after, min);
        }

        public static ExecutionOrder between(IExecutionOrder[] after, IExecutionOrder before) {
            if (after == null || after.length == 0) {
                throw new NullPointerException("after may not be null or empty array");
            }
            if (before == null) {
                throw new NullPointerException("before may not be null");
            }
            int max = Integer.MIN_VALUE;
            for (IExecutionOrder i : after) {
                if (max >= i.getOrderValue()) continue;
                max = i.getOrderValue();
            }
            return ExecutionOrder.between(max, before.getOrderValue());
        }

        public static ExecutionOrder after(IExecutionOrder after) {
            if (after == null) {
                throw new NullPointerException("after may not be null");
            }
            return ExecutionOrder.after(after.getOrderValue());
        }

        public static ExecutionOrder after(int after) {
            return ExecutionOrder.between(after, (after / 0xFFFFFFF + 1) * 0xFFFFFFF);
        }

        public static ExecutionOrder after(IExecutionOrder[] after) {
            if (after == null) {
                throw new NullPointerException("after may not be null");
            }
            int max = Integer.MIN_VALUE;
            for (IExecutionOrder i : after) {
                if (max >= i.getOrderValue()) continue;
                max = i.getOrderValue();
            }
            return ExecutionOrder.after(max);
        }

        public static ExecutionOrder directlyBefore(IExecutionOrder before) {
            return new ExecutionOrder(before.getOrderValue() - 1);
        }

        public static ExecutionOrder directlyAfter(IExecutionOrder before) {
            return new ExecutionOrder(before.getOrderValue() + 1);
        }

        @Override
        public ExecutionOrder getSection() {
            if (this.compareTo(BEFORE_LOOP) < 0) {
                return AT_FIRST;
            }
            if (this.compareTo(START_OF_LOOP) < 0) {
                return BEFORE_LOOP;
            }
            if (this.compareTo(MIDDLE_OF_LOOP) < 0) {
                return START_OF_LOOP;
            }
            if (this.compareTo(MULTIPLE_TIMES_IN_LOOP) < 0) {
                return MIDDLE_OF_LOOP;
            }
            if (this.compareTo(END_OF_LOOP) < 0) {
                return MULTIPLE_TIMES_IN_LOOP;
            }
            if (this.compareTo(AFTER_LOOP) < 0) {
                return END_OF_LOOP;
            }
            if (this.compareTo(AT_LAST) < 0) {
                return AFTER_LOOP;
            }
            return AT_LAST;
        }

        @Override
        public int compareTo(IExecutionOrder o) {
            return this.value - o.getOrderValue();
        }

        public String toString() {
            if (this.compareTo(AT_FIRST) == 0) {
                return "ExecutionOrder.AT_FIRST";
            }
            if (this.compareTo(BEFORE_LOOP) == 0) {
                return "ExecutionOrder.BEFORE_LOOP";
            }
            if (this.compareTo(START_OF_LOOP) == 0) {
                return "ExecutionOrder.START_OF_LOOP";
            }
            if (this.compareTo(MIDDLE_OF_LOOP) == 0) {
                return "ExecutionOrder.MIDDLE_OF_LOOP";
            }
            if (this.compareTo(MULTIPLE_TIMES_IN_LOOP) == 0) {
                return "ExecutionOrder.MULTIPLE_TIMES_IN_LOOP";
            }
            if (this.compareTo(END_OF_LOOP) == 0) {
                return "ExecutionOrder.END_OF_LOOP";
            }
            if (this.compareTo(AFTER_LOOP) == 0) {
                return "ExecutionOrder.AFTER_LOOP";
            }
            if (this.compareTo(AT_LAST) == 0) {
                return "ExecutionOrder.AT_LAST";
            }
            if (this.compareTo(BEFORE_LOOP) < 0) {
                return "in section ExecutionOrder.AT_FIRST";
            }
            if (this.compareTo(START_OF_LOOP) < 0) {
                return "in section ExecutionOrder.BEFORE_LOOP";
            }
            if (this.compareTo(MIDDLE_OF_LOOP) < 0) {
                return "in section ExecutionOrder.START_OF_LOOP";
            }
            if (this.compareTo(MULTIPLE_TIMES_IN_LOOP) < 0) {
                return "in section ExecutionOrder.MIDDLE_OF_LOOP";
            }
            if (this.compareTo(END_OF_LOOP) < 0) {
                return "in section ExecutionOrder.MULTIPLE_TIMES_IN_LOOP";
            }
            if (this.compareTo(AFTER_LOOP) < 0) {
                return "in section ExecutionOrder.END_OF_LOOP";
            }
            if (this.compareTo(AT_LAST) < 0) {
                return "in section ExecutionOrder.AFTER_LOOP";
            }
            return "in section ExecutionOrder.AT_LAST";
        }
    }

    public static class ExecutionOrderComperator
    implements Comparator<AndroidEntryPoint> {
        @Override
        public int compare(AndroidEntryPoint a, AndroidEntryPoint b) {
            return a.order.compareTo(b.order);
        }
    }

    public static interface IExecutionOrder
    extends Comparable<IExecutionOrder> {
        public int getOrderValue();

        public ExecutionOrder getSection();
    }
}

