/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ssa;

import com.ibm.wala.core.util.CancelRuntimeException;
import com.ibm.wala.dalvik.classLoader.DexCFG;
import com.ibm.wala.dalvik.classLoader.DexConstants;
import com.ibm.wala.dalvik.dex.instructions.ArrayGet;
import com.ibm.wala.dalvik.dex.instructions.ArrayLength;
import com.ibm.wala.dalvik.dex.instructions.ArrayPut;
import com.ibm.wala.dalvik.dex.instructions.BinaryOperation;
import com.ibm.wala.dalvik.dex.instructions.Branch;
import com.ibm.wala.dalvik.dex.instructions.Constant;
import com.ibm.wala.dalvik.dex.instructions.GetField;
import com.ibm.wala.dalvik.dex.instructions.InstanceOf;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.dalvik.dex.instructions.Invoke;
import com.ibm.wala.dalvik.dex.instructions.Monitor;
import com.ibm.wala.dalvik.dex.instructions.New;
import com.ibm.wala.dalvik.dex.instructions.PutField;
import com.ibm.wala.dalvik.dex.instructions.Switch;
import com.ibm.wala.dalvik.dex.instructions.Throw;
import com.ibm.wala.dalvik.dex.instructions.UnaryOperation;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BasicFramework;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.AbstractVariable;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.INodeWithNumber;
import java.util.Arrays;
import java.util.Iterator;

public abstract class AbstractIntRegisterMachine
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    public static final int TOP = -1;
    public static final int BOTTOM = -2;
    public static final int UNANALYZED = -3;
    public static final int IGNORE = -4;
    private DataflowSolver solver;
    private final DexCFG cfg;
    protected final int maxLocals;
    public static final boolean OPTIMISTIC = true;

    protected AbstractIntRegisterMachine(DexCFG G) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.maxLocals = G.getDexMethod().getMaxLocals();
        this.cfg = G;
    }

    protected void init(Meeter meeter, final FlowProvider flow) {
        final MeetOperator meet = new MeetOperator(meeter);
        ITransferFunctionProvider<DexCFG.BasicBlock, MachineState> xferFunctions = new ITransferFunctionProvider<DexCFG.BasicBlock, MachineState>(){

            public boolean hasNodeTransferFunctions() {
                return flow.needsNodeFlow();
            }

            public boolean hasEdgeTransferFunctions() {
                return flow.needsEdgeFlow();
            }

            public UnaryOperator<MachineState> getNodeTransferFunction(final DexCFG.BasicBlock node) {
                return new UnaryOperator<MachineState>(){

                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, node);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    public String toString() {
                        return "NODE-FLOW";
                    }

                    public int hashCode() {
                        return 9973 * node.hashCode();
                    }

                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            public UnaryOperator<MachineState> getEdgeTransferFunction(final DexCFG.BasicBlock from, final DexCFG.BasicBlock to) {
                return new UnaryOperator<MachineState>(){

                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, from, to);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    public String toString() {
                        return "EDGE-FLOW";
                    }

                    public int hashCode() {
                        return 9973 * (from.hashCode() ^ to.hashCode());
                    }

                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            public AbstractMeetOperator<MachineState> getMeetOperator() {
                return meet;
            }
        };
        BasicFramework problem = new BasicFramework((Graph)this.cfg, (ITransferFunctionProvider)xferFunctions);
        this.solver = new DataflowSolver<DexCFG.BasicBlock, MachineState>((IKilldallFramework)problem){
            private MachineState entry;

            protected MachineState makeNodeVariable(DexCFG.BasicBlock n, boolean IN) {
                assert (n != null);
                MachineState result = new MachineState(n);
                if (IN && n.equals(AbstractIntRegisterMachine.this.cfg.entry())) {
                    this.entry = result;
                }
                return result;
            }

            protected MachineState makeEdgeVariable(DexCFG.BasicBlock from, DexCFG.BasicBlock to) {
                assert (from != null);
                assert (to != null);
                MachineState result = new MachineState(from);
                return result;
            }

            protected void initializeWorkList() {
                super.buildEquations(false, false);
                for (INodeWithNumber inn : Iterator2Iterable.make((Iterator)this.getFixedPointSystem().getStatementsThatUse((IVariable)this.entry))) {
                    AbstractStatement s = (AbstractStatement)inn;
                    this.addToWorkList(s);
                }
            }

            protected void initializeVariables() {
                super.initializeVariables();
                AbstractIntRegisterMachine.this.initializeVariables();
            }

            protected MachineState[] makeStmtRHS(int size) {
                return new MachineState[size];
            }
        };
    }

    public boolean solve() {
        try {
            return this.solver.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException((Exception)((Object)e));
        }
    }

    protected void initializeVariables() {
    }

    public MachineState getEntryState() {
        return (MachineState)this.solver.getIn((Object)this.cfg.entry());
    }

    public MachineState getIn(DexCFG.BasicBlock bb) {
        return (MachineState)this.solver.getIn((Object)bb);
    }

    private static boolean meet(IVariable lhs, IVariable[] rhs, DexCFG.BasicBlock bb, Meeter meeter) {
        return AbstractIntRegisterMachine.meetLocals(lhs, rhs, bb, meeter);
    }

    private static boolean meetForCatchBlock(IVariable lhs, IVariable[] rhs, DexCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = AbstractIntRegisterMachine.meetLocals(lhs, rhs, bb, meeter);
        return changed;
    }

    private static boolean meetLocals(IVariable lhs, IVariable[] rhs, DexCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        MachineState L = (MachineState)lhs;
        int nLocals = AbstractIntRegisterMachine.computeMeetNLocals(rhs);
        if (nLocals > -1 && L.locals == null) {
            L.allocateLocals();
            changed = true;
        }
        for (int i = 0; i < nLocals; ++i) {
            int[] R = new int[rhs.length];
            for (int j = 0; j < rhs.length; ++j) {
                R[j] = ((MachineState)rhs[j]).getLocal(i);
            }
            int meet = meeter.meetLocal(i, R, bb);
            if (L.locals[i] == -1) {
                if (meet == -1) continue;
                changed = true;
                ((MachineState)L).locals[i] = meet;
                continue;
            }
            if (meet == L.locals[i]) continue;
            changed = true;
            ((MachineState)L).locals[i] = meet;
        }
        return changed;
    }

    private static int computeMeetNLocals(IVariable[] operands) {
        MachineState lhs = (MachineState)operands[0];
        int nLocals = -1;
        if (lhs.locals != null) {
            nLocals = lhs.locals.length;
        } else {
            for (int i = 1; i < operands.length; ++i) {
                MachineState rhs = (MachineState)operands[i];
                if (rhs.locals == null) continue;
                nLocals = rhs.locals.length;
                break;
            }
        }
        return nLocals;
    }

    private static int computeMeetStackHeight(IVariable[] operands) {
        MachineState lhs = (MachineState)operands[0];
        int height = -1;
        if (lhs.stack != null) {
            height = lhs.stackHeight;
        } else {
            for (int i = 1; i < operands.length; ++i) {
                MachineState rhs = (MachineState)operands[i];
                if (rhs.stack == null) continue;
                height = rhs.stackHeight;
                break;
            }
        }
        return height;
    }

    public int[] allocateNewLocalsArray() {
        int[] result = new int[this.maxLocals];
        Arrays.fill(result, -1);
        return result;
    }

    protected static abstract class BasicRegisterFlowProvider
    implements FlowProvider,
    DexConstants {
        private final DexCFG cfg;
        protected MachineState workingState;
        private BasicRegisterMachineVisitor visitor;
        private Instruction.Visitor edgeVisitor;
        private int currentInstructionIndex = 0;
        private DexCFG.BasicBlock currentBlock;
        private DexCFG.BasicBlock currentSuccessorBlock;

        protected BasicRegisterFlowProvider(DexCFG cfg) {
            this.cfg = cfg;
        }

        protected void init(BasicRegisterMachineVisitor v, Instruction.Visitor ev) {
            this.visitor = v;
            this.edgeVisitor = ev;
        }

        @Override
        public boolean needsNodeFlow() {
            return true;
        }

        @Override
        public boolean needsEdgeFlow() {
            return false;
        }

        @Override
        public MachineState flow(MachineState entry, DexCFG.BasicBlock basicBlock) {
            this.workingState = entry.duplicate();
            this.currentBlock = basicBlock;
            this.currentSuccessorBlock = null;
            Instruction[] instructions = this.getInstructions();
            for (int i = basicBlock.getFirstInstructionIndex(); i <= basicBlock.getLastInstructionIndex(); ++i) {
                this.currentInstructionIndex = i;
                instructions[i].visit(this.visitor);
            }
            return this.workingState;
        }

        @Override
        public MachineState flow(MachineState entry, DexCFG.BasicBlock from, DexCFG.BasicBlock to) {
            this.workingState = entry.duplicate();
            this.currentBlock = from;
            this.currentSuccessorBlock = to;
            Instruction[] instructions = this.getInstructions();
            for (int i = from.getFirstInstructionIndex(); i <= from.getLastInstructionIndex(); ++i) {
                this.currentInstructionIndex = i;
                instructions[i].visit(this.edgeVisitor);
            }
            return this.workingState;
        }

        protected int getCurrentInstructionIndex() {
            return this.currentInstructionIndex;
        }

        protected int getCurrentProgramCounter() {
            return this.cfg.getProgramCounter(this.currentInstructionIndex);
        }

        protected DexCFG.BasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        protected DexCFG.BasicBlock getCurrentSuccessor() {
            return this.currentSuccessorBlock;
        }

        public abstract Instruction[] getInstructions();

        protected static class BasicRegisterMachineVisitor
        extends Instruction.Visitor {
            protected BasicRegisterMachineVisitor() {
            }

            @Override
            public void visitArrayLength(ArrayLength instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitArrayGet(ArrayGet instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitArrayPut(ArrayPut instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitBinaryOperation(BinaryOperation instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitBranch(Branch instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitConstant(Constant instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitGetField(GetField instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitInstanceof(InstanceOf instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitInvoke(Invoke instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitMonitor(Monitor instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitNew(New instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitPutField(PutField instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitSwitch(Switch instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitThrow(Throw instruction) {
                throw new UnimplementedError();
            }

            @Override
            public void visitUnaryOperation(UnaryOperation instruction) {
                throw new UnimplementedError();
            }
        }
    }

    public static interface FlowProvider {
        public boolean needsNodeFlow();

        public boolean needsEdgeFlow();

        public MachineState flow(MachineState var1, DexCFG.BasicBlock var2);

        public MachineState flow(MachineState var1, DexCFG.BasicBlock var2, DexCFG.BasicBlock var3);
    }

    public class MachineState
    extends AbstractVariable<MachineState> {
        private int[] stack;
        private int[] locals;
        private int stackHeight;
        private final DexCFG.BasicBlock bb;

        public MachineState duplicate() {
            MachineState result = new MachineState(this.bb);
            result.copyState(this);
            return result;
        }

        public MachineState(DexCFG.BasicBlock bb) {
            this.setTOP();
            this.bb = bb;
        }

        public DexCFG.BasicBlock getBasicBlock() {
            return this.bb;
        }

        void setTOP() {
            this.stackHeight = -1;
        }

        public void allocateLocals() {
            this.locals = AbstractIntRegisterMachine.this.allocateNewLocalsArray();
        }

        public void setLocal(int i, int j) {
            if (this.locals == null) {
                if (j == -1) {
                    return;
                }
                this.allocateLocals();
            }
            this.locals[i] = j;
        }

        public int getLocal(int i) {
            if (this.locals == null) {
                return -1;
            }
            return this.locals[i];
        }

        public void replaceValue(int from, int to) {
            int i;
            if (this.stack != null) {
                for (i = 0; i < this.stackHeight; ++i) {
                    if (this.stack[i] != from) continue;
                    this.stack[i] = to;
                }
            }
            if (this.locals != null) {
                for (i = 0; i < AbstractIntRegisterMachine.this.maxLocals; ++i) {
                    if (this.locals[i] != from) continue;
                    this.locals[i] = to;
                }
            }
        }

        public boolean hasValue(int val) {
            int i;
            if (this.stack != null) {
                for (i = 0; i < this.stackHeight; ++i) {
                    if (this.stack[i] != val) continue;
                    return true;
                }
            }
            if (this.locals != null) {
                for (i = 0; i < AbstractIntRegisterMachine.this.maxLocals; ++i) {
                    if (this.locals[i] != val) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "Some machine state...";
        }

        public void copyState(MachineState other) {
            this.stack = other.stack == null ? null : (int[])other.stack.clone();
            this.locals = other.locals == null ? null : (int[])other.locals.clone();
            this.stackHeight = other.stackHeight;
        }

        boolean stateEquals(MachineState exit) {
            int i;
            if (this.stackHeight != exit.stackHeight) {
                return false;
            }
            if (this.locals == null) {
                if (exit.locals != null) {
                    return false;
                }
            } else {
                if (exit.locals == null) {
                    return false;
                }
                if (this.locals.length != exit.locals.length) {
                    return false;
                }
            }
            for (i = 0; i < this.stackHeight; ++i) {
                if (this.stack[i] == exit.stack[i]) continue;
                return false;
            }
            if (this.locals != null) {
                for (i = 0; i < this.locals.length; ++i) {
                    if (this.locals[i] == -1 && exit.locals[i] != -1) {
                        return false;
                    }
                    if (this.locals[i] == exit.locals[i]) continue;
                    return false;
                }
            }
            return true;
        }

        public int getStackHeight() {
            return this.stackHeight;
        }

        public int[] getLocals() {
            return this.locals;
        }
    }

    protected static interface Meeter {
        public int meetLocal(int var1, int[] var2, DexCFG.BasicBlock var3);
    }

    private class MeetOperator
    extends AbstractMeetOperator<MachineState> {
        private final Meeter meeter;

        MeetOperator(Meeter meeter) {
            this.meeter = meeter;
        }

        public boolean isUnaryNoOp() {
            return false;
        }

        public byte evaluate(MachineState lhs, MachineState[] rhs) {
            DexCFG.BasicBlock bb = lhs.getBasicBlock();
            if (!bb.isCatchBlock()) {
                return AbstractIntRegisterMachine.meet((IVariable)lhs, (IVariable[])rhs, bb, this.meeter) ? (byte)1 : 0;
            }
            return AbstractIntRegisterMachine.meetForCatchBlock((IVariable)lhs, (IVariable[])rhs, bb, this.meeter) ? (byte)1 : 0;
        }

        public int hashCode() {
            return 72223 * this.meeter.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof MeetOperator) {
                MeetOperator other = (MeetOperator)((Object)o);
                return this.meeter.equals(other.meeter);
            }
            return false;
        }

        public String toString() {
            return "MEETER";
        }
    }
}

