/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.util;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.core.util.config.AnalysisScopeReader;
import com.ibm.wala.core.util.io.FileProvider;
import com.ibm.wala.dalvik.classLoader.DexFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.jar.JarFile;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.MultiDexContainer;

public class AndroidAnalysisScope {
    private static final String BASIC_FILE = "primordial.txt";

    public static AnalysisScope setUpAndroidAnalysisScope(URI codeFileName, String exclusions, ClassLoader loader, URI ... androidLib) throws IOException {
        return AndroidAnalysisScope.setUpAndroidAnalysisScope(codeFileName, -1, exclusions, loader, androidLib);
    }

    public static AnalysisScope setUpAndroidAnalysisScope(URI codeFileName, int apiLevel, String exclusions, ClassLoader loader, URI ... androidLib) throws IOException {
        boolean isContainerFile;
        AnalysisScope scope;
        File exclusionsFile;
        File file = exclusionsFile = exclusions != null ? new File(exclusions) : null;
        if (androidLib == null || androidLib.length == 0) {
            scope = AnalysisScopeReader.instance.readJavaScope(BASIC_FILE, exclusionsFile, loader);
        } else {
            scope = AnalysisScope.createJavaAnalysisScope();
            if (exclusionsFile != null) {
                try (InputStream fs = exclusionsFile.exists() ? new FileInputStream(exclusionsFile) : FileProvider.class.getClassLoader().getResourceAsStream(exclusionsFile.getName());){
                    scope.setExclusions((SetOfClasses)new FileOfClasses(fs));
                }
            }
            scope.setLoaderImpl(ClassLoaderReference.Primordial, "com.ibm.wala.dalvik.classLoader.WDexClassLoaderImpl");
            for (URI al : androidLib) {
                try {
                    scope.addToScope(ClassLoaderReference.Primordial, (Module)DexFileModule.make(new File(al)));
                }
                catch (Exception e) {
                    scope.addToScope(ClassLoaderReference.Primordial, (Module)new JarFileModule(new JarFile(new File(al))));
                }
            }
        }
        scope.setLoaderImpl(ClassLoaderReference.Application, "com.ibm.wala.dalvik.classLoader.WDexClassLoaderImpl");
        File codeFile = new File(codeFileName);
        boolean bl = isContainerFile = codeFile.getName().endsWith(".oat") || codeFile.getName().endsWith(".apk");
        if (isContainerFile) {
            MultiDexContainer multiDex = DexFileFactory.loadDexContainer((File)codeFile, (Opcodes)(apiLevel == -1 ? null : Opcodes.forApi((int)apiLevel)));
            for (String dexEntry : multiDex.getDexEntryNames()) {
                scope.addToScope(ClassLoaderReference.Application, (Module)new DexFileModule(codeFile, dexEntry, apiLevel));
            }
        } else {
            scope.addToScope(ClassLoaderReference.Application, (Module)DexFileModule.make(codeFile, apiLevel));
        }
        return scope;
    }

    public static void addClassPathToScope(String classPath, AnalysisScope scope, ClassLoaderReference loader) {
        if (classPath == null) {
            throw new IllegalArgumentException("null classPath");
        }
        try {
            String[] paths;
            for (String path : paths = classPath.split(File.pathSeparator)) {
                File f;
                if (path.endsWith(".jar") || path.endsWith(".apk") || path.endsWith(".dex")) {
                    f = new File(path);
                    scope.addToScope(loader, (Module)DexFileModule.make(f));
                    continue;
                }
                f = new File(path);
                if (f.isDirectory()) {
                    scope.addToScope(loader, (Module)new BinaryDirectoryTreeModule(f));
                    continue;
                }
                try {
                    scope.addClassFileToScope(loader, f);
                }
                catch (InvalidClassFileException e) {
                    throw new IllegalArgumentException("Invalid class file", e);
                }
            }
        }
        catch (IOException e) {
            Assertions.UNREACHABLE((String)e.toString());
        }
    }
}

