/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.util;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.strings.StringStuff;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;

public enum AndroidComponent {
    APPLICATION(AndroidTypes.Application, "Application"),
    ACTIVITY(AndroidTypes.Activity, "Activity"),
    FRAGMENT(AndroidTypes.Fragment, "Fragment"),
    SERVICE(AndroidTypes.Service, "Service"),
    INTENT_SERVICE(AndroidTypes.IntentService, "IntentService"),
    ABSTRACT_INPUT_METHOD_SERVICE(AndroidTypes.AbstractInputMethodService, "AbstractInputMethodService"),
    ACCESSIBILITY_SERVICE(AndroidTypes.AccessibilityService, "AccessibilityService"),
    DREAM_SERVICE(AndroidTypes.DreamService, "DreamService"),
    HOST_APDU_SERVICE(AndroidTypes.HostApduService, "HostApduService"),
    MEDIA_ROUTE_PROVIDER_SERVICE(AndroidTypes.MediaRouteProviderService, "MediaRouteProviderService"),
    NOTIFICATION_LISTENER_SERVICE(AndroidTypes.NotificationListenerService, "NotificationListenerService"),
    OFF_HOST_APDU_SERVICE(AndroidTypes.OffHostApduService, "OffHostApduService"),
    PRINT_SERVICE(AndroidTypes.PrintService, "PrintService"),
    RECOGNITION_SERVICE(AndroidTypes.RecognitionService, "RecognitionService"),
    REMOTE_VIEWS_SERVICE(AndroidTypes.RemoteViewsService, "RemoteViewsService"),
    SETTING_INJECTOR_SERVICE(AndroidTypes.SettingInjectorService, "SettingInjectorService"),
    SPELL_CHECKER_SERVICE(AndroidTypes.SpellCheckerService, "SpellCheckerService"),
    TEXT_TO_SPEECH_SERVICE(AndroidTypes.TextToSpeechService, "TextToSpeechService"),
    VPN_SERVICE(AndroidTypes.VpnService, "VpnService"),
    WALLPAPER_SERVICE(AndroidTypes.WallpaperService, "WallpaperService"),
    INPUT_METHOD_SERVICE(AndroidTypes.InputMethodService, "InputMethodService"),
    PROVIDER(AndroidTypes.ContentProvider, "ContentProvider"),
    BROADCAST_RECEIVER(AndroidTypes.BroadcastReceiver, "BroadcastReceiver"),
    LOADER_CB("Landroid/app/LoaderManager/LoaderCallbacks", "CallBackFromLoader"),
    RESOLVER(AndroidTypes.ContentResolver, "ContentResolver"),
    CONTEXT(AndroidTypes.Context, "Context"),
    HTTP("Landroid/net/AndroidHttpClient", "AndroidHttpClient"),
    BINDER(AndroidTypes.IBinder, "IBinder"),
    LOCATION_MGR("Landroid/location/LocationManager", "LocationManager"),
    TELEPHONY("Landroid/telephony/TelephonyManager", "TelephonyManager"),
    SMS("Landroid/telephony/SmsManager", "SmsManager"),
    SMS_GSM("Landroid/telephony/gsm/SmsManager", "GsmSmsManager"),
    LOCATION_LISTENER("Landroid/location/LocationListener", "LocationListener"),
    GPS_LISTENER("Landroid/location/GpsStatus$Listener", "GpsStatusListener"),
    GPS_NMEA_LISTENER("Landroid/location/GpsStatus$NmeaListener", "GpsNmeaListener"),
    UNKNOWN((String)null, "NULL");

    private TypeReference tRef;
    private final TypeName type;
    private final String prettyName;

    private AndroidComponent(TypeReference type, String prettyName) {
        this.tRef = type;
        this.type = type.getName();
        this.prettyName = prettyName;
    }

    private AndroidComponent(String type, String prettyName) {
        if (prettyName.contains(".") || prettyName.contains("/") || prettyName.contains("$") || prettyName.contains(" ") || prettyName.contains("\t")) {
            throw new IllegalArgumentException("The prettyName may not contain one of the reserved characters ., /, $ or whitespace. The given name was " + prettyName);
        }
        this.tRef = null;
        this.prettyName = prettyName;
        this.type = type != null ? TypeName.findOrCreate((String)type) : null;
    }

    public static boolean isAndroidComponent(TypeReference T, IClassHierarchy cha) {
        for (AndroidComponent candid : AndroidComponent.values()) {
            if (candid == UNKNOWN) continue;
            if (candid.getName().equals((Object)T.getName())) {
                return true;
            }
            IClass iT = cha.lookupClass(T);
            IClass iCand = cha.lookupClass(candid.toReference());
            if (iT == null) {
                return false;
            }
            if (iCand == null) {
                return false;
            }
            if (!cha.isAssignableFrom(iCand, iT)) continue;
            return true;
        }
        return false;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public TypeName getName() {
        return this.type;
    }

    TypeReference toReference() {
        if (this.tRef != null) {
            return this.tRef;
        }
        if (this.type == null) {
            return null;
        }
        this.tRef = TypeReference.find((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)this.type);
        if (this.tRef == null) {
            this.tRef = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)this.type);
        }
        if (this.tRef == null) {
            throw new IllegalStateException("Unable to resolve " + this.type.toString() + " in Primordial-Loader. Perhaps the Android-Stubs used are the wrong ones: The analysis needs a view more functions, than the Vanilla-Stubs offer. A script 'stubsBuilder.sh' should have been bundled to generate these.");
        }
        return this.tRef;
    }

    public static AndroidComponent explicit(TypeName type) {
        for (AndroidComponent test : AndroidComponent.values()) {
            if (!type.equals((Object)test.type)) continue;
            return test;
        }
        return UNKNOWN;
    }

    public static AndroidComponent explicit(TypeReference type) {
        return AndroidComponent.explicit(type.getName());
    }

    public static AndroidComponent explicit(String type) {
        if (!type.startsWith("L") && !type.contains("/")) {
            type = StringStuff.deployment2CanonicalTypeString((String)type);
        }
        return AndroidComponent.explicit(TypeName.findOrCreate((String)type));
    }

    public static AndroidComponent from(IClass type, IClassHierarchy cha) {
        for (AndroidComponent test : AndroidComponent.values()) {
            if (!type.getReference().equals((Object)test.toReference()) && !cha.isSubclassOf(type, cha.lookupClass(test.toReference()))) continue;
            return test;
        }
        return UNKNOWN;
    }

    public static AndroidComponent from(IMethod method, IClassHierarchy cha) {
        if (method == null) {
            return UNKNOWN;
        }
        IClass type = method.getDeclaringClass();
        if (type == null) {
            throw new IllegalStateException("Unable to retreive the declaring class of " + method);
        }
        for (AndroidComponent test : AndroidComponent.values()) {
            IClass testClass;
            TypeReference testRef;
            if (test.equals((Object)UNKNOWN) || (testRef = test.toReference()) == null || (testClass = cha.lookupClass(testRef)) == null || !(testClass.isInterface() ? cha.isAssignableFrom(testClass, type) && testClass.getMethod(method.getSelector()) != null : cha.isSubclassOf(type, testClass) && testClass.getMethod(method.getSelector()) != null)) continue;
            return test;
        }
        return UNKNOWN;
    }
}

